/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.aggregator.impl;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.commons.collections.list.TreeList;
import org.apache.jetspeed.aggregator.PortletContent;
import org.apache.jetspeed.cache.ContentCacheKey;
import org.apache.jetspeed.portlet.HeadElement;
import org.apache.jetspeed.util.DefaultKeyValue;
import org.apache.jetspeed.util.HeadElementUtils;
import org.apache.jetspeed.util.KeyValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletContentImpl
implements PortletContent {
    private CharArrayWriter cw = new CharArrayWriter();
    private PrintWriter writer = new PrintWriter(this.cw);
    private boolean complete;
    private ContentCacheKey cacheKey;
    private int expiration;
    private String title;
    private String contentType;
    private PortletMode portletMode;
    private WindowState windowState;
    private List<KeyValue<String, HeadElement>> headElements;

    PortletContentImpl() {
    }

    PortletContentImpl(ContentCacheKey cacheKey, int expiration, String title, PortletMode portletMode, WindowState windowState) {
        this();
        this.cacheKey = cacheKey;
        this.expiration = expiration;
        this.title = title;
        this.portletMode = portletMode;
        this.windowState = windowState;
    }

    public PrintWriter getWriter() {
        return this.writer;
    }

    public void release() {
        if (this.writer != null) {
            this.writer.close();
            this.cw.reset();
        }
        this.cw = null;
        this.writer = null;
        this.headElements = null;
    }

    public String toString() {
        this.writer.flush();
        return this.cw.toString();
    }

    public void writeTo(Writer out) throws IOException {
        this.writer.flush();
        this.cw.writeTo(out);
    }

    public char[] toCharArray() {
        this.writer.flush();
        return this.cw.toCharArray();
    }

    public boolean isComplete() {
        return this.complete;
    }

    public String getContent() {
        return this.toString();
    }

    public void complete() {
        this.complete = true;
    }

    public ContentCacheKey getCacheKey() {
        return this.cacheKey;
    }

    public int getExpiration() {
        return this.expiration;
    }

    public void setExpiration(int expiration) {
        this.expiration = expiration;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public PortletMode getPortletMode() {
        return this.portletMode != null ? this.portletMode : PortletMode.VIEW;
    }

    public WindowState getWindowState() {
        return this.windowState != null ? this.windowState : WindowState.NORMAL;
    }

    public void reset() {
        if (!this.complete) {
            this.resetBuffer();
            this.headElements = null;
        }
    }

    public void resetBuffer() {
        if (!this.complete) {
            this.writer.flush();
            this.cw.reset();
        }
    }

    public void addHeadElement(HeadElement headElement, String keyHint) {
        DefaultKeyValue<String, HeadElement> kvPair;
        if (this.headElements == null) {
            this.headElements = new TreeList();
        }
        if (headElement == null) {
            if (keyHint != null) {
                DefaultKeyValue<String, Object> kvPair2 = new DefaultKeyValue<String, Object>(keyHint, null, true);
                this.headElements.remove(kvPair2);
            } else {
                this.headElements.clear();
            }
            return;
        }
        if (keyHint == null) {
            keyHint = HeadElementUtils.toHtmlString(headElement);
        }
        if (!this.headElements.contains(kvPair = new DefaultKeyValue<String, HeadElement>(keyHint, headElement, true))) {
            this.headElements.add(kvPair);
        }
    }

    public List<KeyValue<String, HeadElement>> getHeadElements() {
        List<Object> headElems = null;
        headElems = this.headElements != null ? this.headElements : Collections.emptyList();
        return headElems;
    }
}

