/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.aggregator.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.apache.jetspeed.aggregator.PortletTrackingManager;
import org.apache.jetspeed.aggregator.RenderTrackable;
import org.apache.jetspeed.container.PortletWindow;
import org.apache.jetspeed.om.portlet.LocalizedField;
import org.apache.jetspeed.om.portlet.PortletDefinition;

public class PortletTrackingManagerImpl
implements PortletTrackingManager {
    protected Map outOfService = Collections.synchronizedMap(new HashMap());
    protected long defaultPortletTimeout;
    protected int outOfServiceLimit;

    public PortletTrackingManagerImpl(long defaultPortletTimeout, int outOfServiceLimit) {
        this.defaultPortletTimeout = defaultPortletTimeout;
        this.outOfServiceLimit = outOfServiceLimit;
    }

    public long getDefaultPortletTimeout() {
        return this.defaultPortletTimeout;
    }

    public boolean exceededTimeout(long renderTime, PortletWindow window) {
        RenderTrackable trackInfo = (RenderTrackable)window;
        long defaultTimeout = this.getDefaultPortletTimeout();
        if (trackInfo.getExpiration() > 0L) {
            return renderTime > trackInfo.getExpiration();
        }
        if (defaultTimeout > 0L) {
            return renderTime > defaultTimeout;
        }
        return false;
    }

    public boolean isOutOfService(PortletWindow window) {
        RenderTrackable trackable = (RenderTrackable)window;
        if (trackable.getRenderTimeoutCount() > this.outOfServiceLimit) {
            return true;
        }
        PortletDefinition def = window.getPortletDefinition();
        Collection fields = def.getMetadata().getFields("service.out");
        return fields != null && !fields.isEmpty() && BooleanUtils.toBoolean((String)((LocalizedField)fields.iterator().next()).getValue());
    }

    public int getOutOfServiceLimit() {
        return this.outOfServiceLimit;
    }

    public void incrementRenderTimeoutCount(PortletWindow window) {
        RenderTrackable trackable = (RenderTrackable)window;
        trackable.incrementRenderTimeoutCount();
    }

    public void success(PortletWindow window) {
        RenderTrackable trackable = (RenderTrackable)window;
        trackable.success();
    }

    public void setExpiration(PortletWindow window, long expiration) {
        RenderTrackable trackable = (RenderTrackable)window;
        trackable.setExpiration(expiration);
    }

    public void takeOutOfService(PortletWindow window) {
        RenderTrackable trackable = (RenderTrackable)window;
        trackable.setRenderTimeoutCount((int)this.defaultPortletTimeout + 1);
    }

    public void putIntoService(PortletWindow window) {
        RenderTrackable trackable = (RenderTrackable)window;
        trackable.setRenderTimeoutCount(0);
    }

    public void putIntoService(List fullPortletNames) {
    }

    public List getOutOfServiceList(String fullPortletName) {
        ArrayList outs = new ArrayList();
        return outs;
    }

    public List getOutOfServiceList() {
        ArrayList outs = new ArrayList();
        return outs;
    }
}

