/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.aggregator.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jetspeed.aggregator.PortletContent;
import org.apache.jetspeed.aggregator.PortletRenderer;
import org.apache.jetspeed.aggregator.PortletTrackingManager;
import org.apache.jetspeed.aggregator.RenderingJob;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.statistics.PortalStatistics;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderingJobImpl
implements RenderingJob {
    protected static final Logger log = LoggerFactory.getLogger(RenderingJobImpl.class);
    protected org.apache.jetspeed.container.PortletWindow window = null;
    protected HttpServletRequest request = null;
    protected HttpServletResponse response = null;
    protected PortletContainer container = null;
    protected PortletRenderer renderer = null;
    protected RequestContext requestContext = null;
    protected PortletTrackingManager portletTracking = null;
    protected PortletDefinition portletDefinition;
    protected PortalStatistics statistics;
    protected int expirationCache = 0;
    protected Map<String, Object> workerAttributes;
    protected boolean parallel;
    protected long startTimeMillis = 0L;
    protected long timeout;

    public RenderingJobImpl(PortletContainer container, PortletRenderer renderer, PortletDefinition portletDefinition, HttpServletRequest request, HttpServletResponse response, RequestContext requestContext, org.apache.jetspeed.container.PortletWindow window, PortalStatistics statistics, int expirationCache) {
        this.container = container;
        this.renderer = renderer;
        this.portletTracking = renderer.getPortletTrackingManager();
        this.statistics = statistics;
        this.portletDefinition = portletDefinition;
        this.request = request;
        this.response = response;
        this.requestContext = requestContext;
        this.window = window;
        this.expirationCache = expirationCache;
    }

    public PortletRenderer getRenderer() {
        return this.renderer;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public boolean isTimeout() {
        if (this.timeout > 0L && this.startTimeMillis > 0L) {
            return System.currentTimeMillis() - this.startTimeMillis > this.timeout;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block11: {
            this.parallel = true;
            boolean clearContext = this.requestContext.ensureThreadContext();
            try {
                if (this.timeout > 0L) {
                    this.startTimeMillis = System.currentTimeMillis();
                }
                this.execute();
                Object var3_2 = null;
                if (!clearContext) break block11;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (clearContext) {
                    this.requestContext.clearThreadContext();
                }
                this.parallel = false;
                PortletContent portletContent = this.window.getFragment().getPortletContent();
                synchronized (portletContent) {
                    if (log.isDebugEnabled()) {
                        log.debug("Notifying completion of rendering job for portlet window " + this.window.getId());
                    }
                    this.window.getFragment().getPortletContent().notifyAll();
                }
                throw throwable;
            }
            this.requestContext.clearThreadContext();
        }
        this.parallel = false;
        PortletContent portletContent = this.window.getFragment().getPortletContent();
        synchronized (portletContent) {
            if (log.isDebugEnabled()) {
                log.debug("Notifying completion of rendering job for portlet window " + this.window.getId());
            }
            this.window.getFragment().getPortletContent().notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        long start = System.currentTimeMillis();
        ContentFragment fragment = this.window.getFragment();
        try {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Rendering OID " + this.window.getId() + " " + this.request + " " + this.response);
                }
                this.container.doRender((PortletWindow)this.window, this.request, this.response);
            }
            catch (Throwable t) {
                if (t instanceof UnavailableException) {
                    log.error("Error rendering portlet OID " + this.window.getId() + ": " + t.toString());
                } else {
                    log.error("Error rendering portlet OID " + this.window.getId(), t);
                }
                fragment.overrideRenderedContent(t.getMessage());
                Object var6_4 = null;
                try {}
                catch (Throwable throwable) {
                    Object var11_15 = null;
                    PortletContent portletContent2 = fragment.getPortletContent();
                    synchronized (portletContent2) {
                        fragment.getPortletContent().complete();
                        if (fragment.getOverriddenContent() != null) throw throwable;
                        this.renderer.notifyContentComplete(this.requestContext, this.window);
                        throw throwable;
                    }
                }
                if (fragment.getType().equals("portlet")) {
                    long end = System.currentTimeMillis();
                    boolean exceededTimeout = this.portletTracking.exceededTimeout(end - start, this.window);
                    if (this.statistics != null) {
                        this.statistics.logPortletAccess(this.requestContext, fragment.getName(), "200", end - start);
                    }
                    if (exceededTimeout) {
                        log.info("Portlet Exceeded timeout: " + this.window.getPortletDefinition().getPortletName() + " for window " + this.window.getId());
                        this.portletTracking.incrementRenderTimeoutCount(this.window);
                    } else {
                        this.portletTracking.success(this.window);
                    }
                }
                Object var11_14 = null;
                PortletContent portletContent3 = fragment.getPortletContent();
                synchronized (portletContent3) {
                    fragment.getPortletContent().complete();
                    if (fragment.getOverriddenContent() != null) return;
                    this.renderer.notifyContentComplete(this.requestContext, this.window);
                    return;
                }
            }
            Object var6_3 = null;
            try {
                if (fragment.getType().equals("portlet")) {
                    long end = System.currentTimeMillis();
                    boolean exceededTimeout = this.portletTracking.exceededTimeout(end - start, this.window);
                    if (this.statistics != null) {
                        this.statistics.logPortletAccess(this.requestContext, fragment.getName(), "200", end - start);
                    }
                    if (exceededTimeout) {
                        log.info("Portlet Exceeded timeout: " + this.window.getPortletDefinition().getPortletName() + " for window " + this.window.getId());
                        this.portletTracking.incrementRenderTimeoutCount(this.window);
                    } else {
                        this.portletTracking.success(this.window);
                    }
                }
                Object var11_12 = null;
                PortletContent portletContent = fragment.getPortletContent();
                synchronized (portletContent) {
                    fragment.getPortletContent().complete();
                    if (fragment.getOverriddenContent() != null) return;
                    this.renderer.notifyContentComplete(this.requestContext, this.window);
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                PortletContent portletContent2 = fragment.getPortletContent();
                synchronized (portletContent2) {
                    fragment.getPortletContent().complete();
                    if (fragment.getOverriddenContent() != null) throw throwable;
                    this.renderer.notifyContentComplete(this.requestContext, this.window);
                    throw throwable;
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            try {}
            catch (Throwable throwable2) {
                Object var11_17 = null;
                PortletContent portletContent3 = fragment.getPortletContent();
                synchronized (portletContent3) {
                    fragment.getPortletContent().complete();
                    if (fragment.getOverriddenContent() != null) throw throwable2;
                    this.renderer.notifyContentComplete(this.requestContext, this.window);
                    throw throwable2;
                }
            }
            if (fragment.getType().equals("portlet")) {
                long end = System.currentTimeMillis();
                boolean exceededTimeout = this.portletTracking.exceededTimeout(end - start, this.window);
                if (this.statistics != null) {
                    this.statistics.logPortletAccess(this.requestContext, fragment.getName(), "200", end - start);
                }
                if (exceededTimeout) {
                    log.info("Portlet Exceeded timeout: " + this.window.getPortletDefinition().getPortletName() + " for window " + this.window.getId());
                    this.portletTracking.incrementRenderTimeoutCount(this.window);
                } else {
                    this.portletTracking.success(this.window);
                }
            }
            Object var11_16 = null;
            PortletContent portletContent4 = fragment.getPortletContent();
            synchronized (portletContent4) {
                fragment.getPortletContent().complete();
                if (fragment.getOverriddenContent() != null) throw throwable;
                this.renderer.notifyContentComplete(this.requestContext, this.window);
                throw throwable;
            }
        }
    }

    public org.apache.jetspeed.container.PortletWindow getWindow() {
        return this.window;
    }

    public PortletContent getPortletContent() {
        return this.window.getFragment().getPortletContent();
    }

    public PortletDefinition getPortletDefinition() {
        return this.portletDefinition;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public ContentFragment getFragment() {
        return this.window.getFragment();
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public int getExpirationCache() {
        return this.expirationCache;
    }

    public void setWorkerAttribute(String name, Object value) {
        if (this.workerAttributes == null) {
            this.workerAttributes = Collections.synchronizedMap(new HashMap());
        }
        if (value != null) {
            this.workerAttributes.put(name, value);
        } else {
            this.workerAttributes.remove(name);
        }
    }

    public Object getWorkerAttribute(String name) {
        Object value = null;
        if (this.workerAttributes != null) {
            value = this.workerAttributes.get(name);
        }
        return value;
    }

    public void removeWorkerAttribute(String name) {
        if (this.workerAttributes != null) {
            this.workerAttributes.remove(name);
        }
    }
}

