/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.aggregator.impl;

import java.security.AccessControlContext;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.apache.jetspeed.aggregator.RenderingJob;
import org.apache.jetspeed.aggregator.Worker;
import org.apache.jetspeed.aggregator.WorkerMonitor;
import org.apache.jetspeed.aggregator.impl.WorkerMonitorImpl;
import org.apache.jetspeed.security.JSSubject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerImpl
extends Thread
implements Worker {
    protected static final Logger log = LoggerFactory.getLogger(WorkerImpl.class);
    private volatile boolean running = true;
    private volatile int jobCount = 0;
    Runnable job = null;
    private AccessControlContext context = null;
    private WorkerMonitor monitor = null;

    public WorkerImpl(WorkerMonitor monitor) {
        this.setMonitor(monitor);
        this.setDaemon(true);
    }

    public WorkerImpl(WorkerMonitor monitor, ThreadGroup tg, String name) {
        super(tg, name);
        this.setMonitor(monitor);
        this.setDaemon(true);
    }

    public int getJobCount() {
        return this.jobCount;
    }

    public void resetJobCount() {
        this.jobCount = 0;
    }

    public void setRunning(boolean status) {
        this.running = status;
    }

    public void setMonitor(WorkerMonitor monitor) {
        this.monitor = monitor;
    }

    public void setJob(Runnable job, AccessControlContext context) {
        this.job = job;
        this.context = context;
    }

    public void setJob(Runnable job) {
        this.job = job;
        this.context = null;
    }

    public Runnable getJob() {
        return this.job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.running) {
            WorkerImpl workerImpl = this;
            synchronized (workerImpl) {
                if (this.job == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        ((WorkerMonitorImpl)this.monitor).release(this);
                        this.running = false;
                    }
                }
            }
            if (this.job != null) {
                log.debug("Processing job for window :" + ((RenderingJob)this.job).getWindow().getId());
                Subject subject = null;
                if (this.context != null) {
                    subject = JSSubject.getSubject((AccessControlContext)this.context);
                }
                if (subject != null) {
                    JSSubject.doAsPrivileged((Subject)subject, (PrivilegedAction)new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            try {
                                WorkerImpl.this.job.run();
                            }
                            catch (Throwable t) {
                                log.error("Thread error", t);
                            }
                            return null;
                        }
                    }, (AccessControlContext)this.context);
                } else {
                    try {
                        this.job.run();
                    }
                    catch (Throwable t) {
                        log.error("Thread error", t);
                    }
                }
            }
            ++this.jobCount;
            ((WorkerMonitorImpl)this.monitor).release(this);
        }
    }

    public void interrupt() {
        this.running = false;
        super.interrupt();
    }
}

