/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.aggregator.impl;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.apache.jetspeed.aggregator.PortletContent;
import org.apache.jetspeed.aggregator.RenderingJob;
import org.apache.jetspeed.aggregator.WorkerMonitor;
import org.apache.jetspeed.aggregator.impl.WorkerImpl;
import org.apache.jetspeed.container.PortletWindow;
import org.apache.jetspeed.container.PortletWindowID;
import org.apache.jetspeed.util.FIFOQueue;
import org.apache.jetspeed.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkerMonitorImpl
implements WorkerMonitor {
    public static final String ACCESS_CONTROL_CONTEXT_WORKER_ATTR = AccessControlContext.class.getName();
    protected static final Logger log = LoggerFactory.getLogger(WorkerMonitorImpl.class);
    protected static long sCount = 0L;
    protected int runningJobs = 0;
    protected int minWorkers = 5;
    protected int maxWorkers = 50;
    protected int spareWorkers = 3;
    protected int maxJobsPerWorker = 10;
    protected Stack<WorkerImpl> workers = new Stack();
    protected ThreadGroup tg = new ThreadGroup("Workers");
    protected Queue queue;
    protected List<WorkerImpl> workersMonitored = Collections.synchronizedList(new LinkedList());
    protected RenderingJobTimeoutMonitor jobMonitor = null;

    public WorkerMonitorImpl(int minWorkers, int maxWorkers, int spareWorkers, int maxJobsPerWorker) {
        this.minWorkers = minWorkers;
        this.maxWorkers = maxWorkers;
        this.spareWorkers = spareWorkers;
        this.maxJobsPerWorker = maxJobsPerWorker;
    }

    public void start() {
        this.addWorkers(this.minWorkers);
        this.queue = new FIFOQueue();
        this.jobMonitor = new RenderingJobTimeoutMonitor(1000L);
        this.jobMonitor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        List<WorkerImpl> list = this.workers;
        synchronized (list) {
            for (WorkerImpl worker : new ArrayList<WorkerImpl>(this.workers)) {
                worker.interrupt();
            }
        }
        list = this.workersMonitored;
        synchronized (list) {
            for (WorkerImpl worker : new ArrayList<WorkerImpl>(this.workersMonitored)) {
                worker.interrupt();
            }
        }
        if (this.jobMonitor != null) {
            this.jobMonitor.endThread();
        }
        this.jobMonitor = null;
    }

    protected synchronized void addWorkers(int wCount) {
        int wCurrent = this.tg.activeCount();
        if (wCurrent < this.maxWorkers) {
            if (wCurrent + wCount > this.maxWorkers) {
                wCount = this.maxWorkers - wCurrent;
            }
            log.info("Creating " + wCount + " workers -> " + (wCurrent + wCount));
            for (int i = 0; i < wCount; ++i) {
                WorkerImpl worker = new WorkerImpl(this, this.tg, "WORKER_" + ++sCount);
                worker.start();
                this.workers.push(worker);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WorkerImpl getWorker() {
        Stack<WorkerImpl> stack = this.workers;
        synchronized (stack) {
            if (this.workers.size() < this.spareWorkers) {
                this.addWorkers(this.spareWorkers);
            }
            if (this.workers.size() == 0) {
                return null;
            }
            return this.workers.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(RenderingJob job) {
        WorkerImpl worker = this.getWorker();
        AccessControlContext context = AccessController.getContext();
        job.setWorkerAttribute(ACCESS_CONTROL_CONTEXT_WORKER_ATTR, (Object)context);
        if (worker == null) {
            this.queue.push((Object)job);
        } else {
            try {
                WorkerImpl workerImpl = worker;
                synchronized (workerImpl) {
                    worker.setJob((Runnable)job, context);
                    if (job.getTimeout() > 0L) {
                        this.workersMonitored.add(worker);
                    }
                    worker.notify();
                    ++this.runningJobs;
                }
            }
            catch (Throwable t) {
                log.error("Worker exception", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitForRenderingJobs(List<RenderingJob> renderingJobs) {
        try {
            for (RenderingJob job : renderingJobs) {
                PortletContent portletContent;
                PortletContent portletContent2 = portletContent = job.getPortletContent();
                synchronized (portletContent2) {
                    if (!portletContent.isComplete()) {
                        portletContent.wait();
                    }
                }
            }
            return;
        }
        catch (Exception e) {
            log.error("Exception during synchronizing all portlet rendering jobs.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void release(WorkerImpl worker) {
        long jobTimeout = 0L;
        RenderingJob oldJob = (RenderingJob)worker.getJob();
        if (oldJob != null) {
            jobTimeout = oldJob.getTimeout();
        }
        Object object = worker;
        synchronized (object) {
            RenderingJob job = null;
            if (worker.getJobCount() < this.maxJobsPerWorker && (job = (RenderingJob)this.queue.pop()) != null) {
                AccessControlContext context = (AccessControlContext)job.getWorkerAttribute(ACCESS_CONTROL_CONTEXT_WORKER_ATTR);
                worker.setJob((Runnable)job, context);
                --this.runningJobs;
                return;
            }
            worker.setJob(null);
            worker.resetJobCount();
            --this.runningJobs;
        }
        if (jobTimeout > 0L) {
            this.workersMonitored.remove(worker);
        }
        object = this.workers;
        synchronized (object) {
            this.workers.push(worker);
        }
    }

    public int getQueuedJobsCount() {
        return this.queue.size();
    }

    public int getAvailableJobsCount() {
        return this.workers.size();
    }

    public int getRunningJobsCount() {
        return this.tg.activeCount();
    }

    class RenderingJobTimeoutMonitor
    extends Thread {
        long interval;
        boolean shouldRun;

        RenderingJobTimeoutMonitor(long interval) {
            super("RenderingJobTimeoutMonitor");
            this.interval = 1000L;
            this.shouldRun = true;
            this.setDaemon(true);
            if (interval > 0L) {
                this.interval = interval;
            }
        }

        public void endThread() {
            this.shouldRun = false;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.shouldRun) {
                try {
                    ArrayList<WorkerImpl> timeoutWorkers = new ArrayList<WorkerImpl>();
                    List<WorkerImpl> list = WorkerMonitorImpl.this.workersMonitored;
                    synchronized (list) {
                        for (WorkerImpl worker : WorkerMonitorImpl.this.workersMonitored) {
                            RenderingJob job = (RenderingJob)worker.getJob();
                            if (null == job || !job.isTimeout()) continue;
                            timeoutWorkers.add(worker);
                        }
                    }
                    for (WorkerImpl worker : timeoutWorkers) {
                        RenderingJob job = (RenderingJob)worker.getJob();
                        if (null == job || !job.isTimeout()) continue;
                        this.killJob(worker, job);
                    }
                }
                catch (Exception e) {
                    log.error("Exception during job monitoring.", (Throwable)e);
                }
                try {
                    RenderingJobTimeoutMonitor e = this;
                    synchronized (e) {
                        this.wait(this.interval);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void killJob(WorkerImpl worker, RenderingJob job) {
            try {
                PortletContent content;
                if (log.isWarnEnabled()) {
                    PortletWindow window = job.getWindow();
                    PortletWindowID windowId = null != window ? window.getId() : null;
                    log.warn("Portlet Rendering job to be interrupted by timeout (" + job.getTimeout() + "ms): " + windowId.getStringId());
                }
                PortletContent portletContent = content = job.getPortletContent();
                synchronized (portletContent) {
                    if (!content.isComplete()) {
                        worker.interrupt();
                        content.wait();
                    }
                }
            }
            catch (Exception e) {
                log.error("Exceptiong during job killing.", (Throwable)e);
            }
        }
    }
}

