/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.ajax;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.jetspeed.ajax.AJAXException;
import org.apache.jetspeed.ajax.AJAXRequest;
import org.apache.jetspeed.ajax.AJAXRequestImpl;
import org.apache.jetspeed.ajax.AJAXResponse;
import org.apache.jetspeed.ajax.AJAXResponseImpl;
import org.apache.jetspeed.ajax.AJAXService;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

public class AJAXServiceImpl
implements AJAXService,
BeanFactoryAware {
    private Map serviceToBeans;
    private Map serviceToTemplates;
    private BeanFactory beanFactory;
    private VelocityEngine engine;

    public AJAXServiceImpl(Map serviceToBeans) {
        this.serviceToBeans = serviceToBeans;
    }

    public AJAXServiceImpl(Map serviceToBeans, VelocityEngine engine, Map serviceToTemplates) {
        this.serviceToBeans = serviceToBeans;
        this.engine = engine;
        this.serviceToTemplates = serviceToTemplates;
    }

    public AJAXResponse processRequest(AJAXRequest request) throws AJAXException {
        String serviceName = request.getServiceName();
        String methodName = request.getMethodName();
        String mappedServiceName = (serviceName + "." + methodName).trim();
        try {
            if (this.engine == null) {
                this.engine = new VelocityEngine();
                Properties props = new Properties();
                props.load(request.getContext().getResourceAsStream("/WEB-INF/velocity.properties"));
                props.setProperty("file.resource.loader.path", request.getContext().getRealPath("/"));
                this.engine.init();
            }
            if (!this.serviceToBeans.containsKey(mappedServiceName)) {
                throw new AJAXException("There is no AJAX service named '" + mappedServiceName + "' defined.  " + "Please make sure that your ajax.xml is set up correctly.");
            }
            String beanId = ((String)this.serviceToBeans.get(mappedServiceName)).trim();
            Object targetService = this.beanFactory.getBean(beanId);
            List parameters = request.getParameters();
            Method method = targetService.getClass().getMethod(methodName, this.getTypes(parameters));
            Object result = method.invoke(targetService, this.getValues(parameters));
            VelocityContext context = new VelocityContext();
            context.put("ajaxRequest", (Object)request);
            context.put("result", result);
            String templateName = ((String)this.serviceToTemplates.get(mappedServiceName)).trim();
            InputStream templateResource = request.getContext().getResourceAsStream(templateName);
            if (templateResource == null) {
                request.getServletResponse().sendError(404, templateName + " ajax template could not be found.");
                throw new IOException(templateName + " does not exist");
            }
            InputStreamReader template = new InputStreamReader(templateResource);
            StringWriter stringWriter = new StringWriter();
            AJAXResponseImpl ajaxResponse = new AJAXResponseImpl((Context)context, this.engine, template, stringWriter);
            ajaxResponse.complete();
            String buffer = stringWriter.getBuffer().toString();
            HttpServletResponse response = request.getServletResponse();
            ServletOutputStream sos = response.getOutputStream();
            sos.print(buffer);
            sos.flush();
            return ajaxResponse;
        }
        catch (AJAXException ae) {
            throw ae;
        }
        catch (Exception e) {
            throw new AJAXException("Unable to process service" + mappedServiceName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected Class[] getTypes(List objects) {
        Class[] args = new Class[objects.size()];
        Iterator itr = objects.iterator();
        int i = 0;
        while (itr.hasNext()) {
            args[i] = ((AJAXRequestImpl.AJAXParameter)itr.next()).getValue().getClass();
            ++i;
        }
        return args;
    }

    protected Object[] getValues(List objects) {
        Object[] args = new Object[objects.size()];
        Iterator itr = objects.iterator();
        int i = 0;
        while (itr.hasNext()) {
            args[i] = ((AJAXRequestImpl.AJAXParameter)itr.next()).getValue();
            ++i;
        }
        return args;
    }
}

