/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.cluster;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import org.apache.jetspeed.cluster.NodeInformation;

public class NodeInformationImpl
implements NodeInformation,
Serializable {
    static final long serialVersionUID = -598265530537353219L;
    private Long revision;
    private String contextName;
    private Date lastDeployDate = null;
    private static final int CompressVersion = 1;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(1);
        out.writeLong(this.revision);
        out.writeUTF(this.contextName);
        if (this.lastDeployDate == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeLong(this.lastDeployDate.getTime());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.readByte();
        this.revision = new Long(in.readLong());
        this.contextName = in.readUTF();
        byte dateSet = in.readByte();
        this.lastDeployDate = dateSet == 1 ? new Date(in.readLong()) : null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NodeInformation)) {
            return false;
        }
        return this.equals((NodeInformation)object);
    }

    public int compareTo(Object object) {
        if (object == null) {
            return 1;
        }
        if (object == this) {
            return 0;
        }
        if (!(object instanceof NodeInformation)) {
            return 1;
        }
        return this.compareTo((NodeInformation)object);
    }

    public final boolean equals(NodeInformation object) {
        if (object == null) {
            return false;
        }
        return object.getContextName().equalsIgnoreCase(this.contextName);
    }

    public final int compareTo(NodeInformation object) {
        return this.getContextName().compareToIgnoreCase(this.contextName);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("revision= " + this.revision);
        buffer.append("; contextName= " + this.getContextName());
        buffer.append("; lastDeployDate= " + this.getContextName());
        if (this.lastDeployDate != null) {
            DateFormat format = DateFormat.getTimeInstance(3);
            try {
                buffer.append(format.format(this.lastDeployDate));
            }
            catch (Exception e) {
                buffer.append("<invalidDate>");
            }
        } else {
            buffer.append("<empty>");
        }
        return buffer.toString();
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public Long getRevision() {
        return this.revision;
    }

    public void setRevision(Long revision) {
        this.revision = revision;
    }

    public void setRevision(long revision) {
        this.revision = new Long(revision);
    }

    public Date getLastDeployDate() {
        return this.lastDeployDate;
    }

    public void setLastDeployDate(Date lastDeployDate) {
        this.lastDeployDate = lastDeployDate;
    }
}

