/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container;

import org.apache.jetspeed.container.PortletWindow;
import org.apache.jetspeed.container.state.NavigationalState;
import org.apache.jetspeed.container.url.PortalURL;
import org.apache.jetspeed.pipeline.PipelineException;
import org.apache.jetspeed.pipeline.valve.AbstractValve;
import org.apache.jetspeed.pipeline.valve.ValveContext;
import org.apache.jetspeed.request.RequestContext;

public class ContainerValve
extends AbstractValve {
    public void invoke(RequestContext request, ValveContext context) throws PipelineException {
        try {
            request.getRequest().getSession(true);
            NavigationalState state = request.getPortalURL().getNavigationalState();
            if (state != null) {
                boolean syncResult = state.sync(request);
                if (!syncResult) {
                    if (PortalURL.URLType.ACTION == state.getURLType()) {
                        request.getResponse().sendRedirect(request.getPortalURL().getPortalURL());
                        return;
                    }
                    request.getResponse().sendError(404);
                    return;
                }
                PortletWindow actionWindow = state.getPortletWindowOfAction();
                if (null == actionWindow) {
                    request.setActionWindow(null);
                } else {
                    request.setActionWindow(actionWindow);
                }
            }
        }
        catch (Exception e) {
            throw new PipelineException((Throwable)e);
        }
        context.invokeNext(request);
    }

    public String toString() {
        return "ContainerValve";
    }
}

