/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jetspeed.container.PortletWindow;
import org.apache.jetspeed.container.impl.PortletStateAwareResponseContextImpl;
import org.apache.pluto.container.PortletActionResponseContext;
import org.apache.pluto.container.PortletContainer;

public class PortletActionResponseContextImpl
extends PortletStateAwareResponseContextImpl
implements PortletActionResponseContext {
    private boolean redirect;
    private String redirectLocation;
    private String renderURLParamName;

    public PortletActionResponseContextImpl(PortletContainer container, HttpServletRequest containerRequest, HttpServletResponse containerResponse, PortletWindow window) {
        super(container, containerRequest, containerResponse, window);
    }

    public String getResponseURL() {
        if (!this.isReleased()) {
            this.close();
            if (!this.redirect || this.renderURLParamName != null) {
                String portalURL = this.getRequestContext().getPortalURL().getPortalURL();
                if (this.redirect) {
                    if (this.redirectLocation.indexOf("://") != -1 && portalURL.indexOf("://") == -1) {
                        portalURL = this.getRequestContext().getPortalURL().getBaseURL() + portalURL;
                    }
                    try {
                        return this.redirectLocation + "?" + URLEncoder.encode(this.renderURLParamName, "UTF-8") + "=" + URLEncoder.encode(portalURL, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        return null;
                    }
                }
                return portalURL;
            }
            return this.redirectLocation;
        }
        return null;
    }

    public boolean isRedirect() {
        return this.redirect;
    }

    public void setRedirect(String location) {
        this.setRedirect(location, null);
    }

    public void setRedirect(String location, String renderURLParamName) {
        if (!this.isClosed()) {
            this.redirectLocation = location;
            this.renderURLParamName = renderURLParamName;
            this.redirect = true;
        }
    }
}

