/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container.invoker;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.jetspeed.util.ThreadLocalHashMap;

public class ConcurrentRequestMethodInterceptor
implements MethodInterceptor {
    private static final String DEFAULT_PROPERTY_ATTRIBUTE_PREFIX = ConcurrentRequestMethodInterceptor.class.getName() + ".";
    private Object requestObject;
    private ThreadLocalHashMap<String, Object> attributes;
    private boolean synchronizeRequestObjectOnDefaultInvocation = true;
    private Set<String> attributableProperties;
    private boolean hasAttributableProperties = false;
    private String propertyAttributePrefix = DEFAULT_PROPERTY_ATTRIBUTE_PREFIX;

    public ConcurrentRequestMethodInterceptor(Object requestObject) {
        this.requestObject = requestObject;
        this.attributes = new ThreadLocalHashMap();
    }

    public void setSynchronizeRequestObjectOnDefaultInvocation(boolean synchronizeRequestObjectOnDefaultInvocation) {
        this.synchronizeRequestObjectOnDefaultInvocation = synchronizeRequestObjectOnDefaultInvocation;
    }

    public boolean getSynchronizeRequestObjectOnDefaultInvocation() {
        return this.synchronizeRequestObjectOnDefaultInvocation;
    }

    public void setAttributableProperties(String[] attributableProperties) {
        this.attributableProperties = new HashSet<String>();
        for (String attributableProperty : attributableProperties) {
            this.attributableProperties.add(attributableProperty);
        }
        this.hasAttributableProperties = !this.attributableProperties.isEmpty();
    }

    public String[] getAttributableProperties() {
        if (this.attributableProperties == null || this.attributableProperties.isEmpty()) {
            return new String[0];
        }
        String[] arr = new String[this.attributableProperties.size()];
        int index = 0;
        for (String attributableProperty : this.attributableProperties) {
            arr[index++] = attributableProperty;
        }
        return arr;
    }

    public void setPropertyAttributePrefix(String propertyAttributePrefix) {
        this.propertyAttributePrefix = propertyAttributePrefix;
    }

    public String getPropertyAttributePrefix() {
        return this.propertyAttributePrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        if (Modifier.isAbstract(method.getModifiers())) {
            return null;
        }
        String methodName = method.getName();
        if ("getAttribute".equals(methodName)) {
            if (this.attributes.containsKey((String)args[0])) {
                return this.attributes.get((String)args[0]);
            }
        } else if ("setAttribute".equals(methodName)) {
            this.attributes.put((String)args[0], args[1]);
        } else if ("removeAttribute".equals(methodName)) {
            this.attributes.remove((String)args[0]);
        } else if (this.hasAttributableProperties) {
            String propName;
            if (methodName.startsWith("get") && args.length == 0) {
                String attrName;
                propName = this.getPropertyName(method);
                if (propName != null && this.attributableProperties.contains(propName) && this.attributes.containsKey(attrName = this.propertyAttributePrefix + propName)) {
                    return this.attributes.get(attrName);
                }
            } else if (methodName.startsWith("set") && args.length == 1 && (propName = this.getPropertyName(method)) != null && this.attributableProperties.contains(propName)) {
                String attrName = this.propertyAttributePrefix + propName;
                this.attributes.put(attrName, args[0]);
            }
        }
        if (this.synchronizeRequestObjectOnDefaultInvocation) {
            Object object = this.requestObject;
            synchronized (object) {
                return method.invoke(this.requestObject, args);
            }
        }
        return method.invoke(this.requestObject, args);
    }

    private String getPropertyName(Method method) {
        String name = method.getName();
        if (name.startsWith("get") || name.startsWith("set")) {
            char firstChar = name.charAt(3);
            if (Character.isUpperCase(firstChar)) {
                StringBuilder sb = new StringBuilder(name.substring(3));
                sb.setCharAt(0, Character.toLowerCase(firstChar));
                name = sb.toString();
            }
            return name;
        }
        return null;
    }
}

