/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container.invoker;

import java.io.IOException;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.jetspeed.container.FilterManager;
import org.apache.jetspeed.container.PortletWindow;
import org.apache.jetspeed.container.invoker.ContainerRequestResponseUnwrapper;
import org.apache.jetspeed.container.invoker.JetspeedPortletInvoker;
import org.apache.jetspeed.factory.PortletFactory;
import org.apache.jetspeed.factory.PortletInstance;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.om.window.impl.PortletWindowImpl;
import org.apache.jetspeed.request.JetspeedRequestContext;
import org.apache.pluto.container.PortletInvokerService;
import org.apache.pluto.container.PortletRequestContext;
import org.apache.pluto.container.PortletResponseContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletPortletInvoker
implements JetspeedPortletInvoker {
    private static final Logger log = LoggerFactory.getLogger(ServletPortletInvoker.class);
    protected PortletFactory portletFactory;
    protected ServletContext jetspeedContext;
    protected ServletConfig jetspeedConfig;
    protected PortletDefinition portletDefinition;
    protected boolean activated = false;
    protected String servletMappingName;
    protected ContainerRequestResponseUnwrapper requestResponseUnwrapper;

    public ServletPortletInvoker(ContainerRequestResponseUnwrapper requestResponseUnwrapper, String servletMappingName) {
        this.requestResponseUnwrapper = requestResponseUnwrapper;
        this.servletMappingName = servletMappingName;
    }

    public void activate(PortletFactory portletFactory, PortletDefinition portletDefinition, ServletConfig servletConfig) {
        this.portletFactory = portletFactory;
        this.jetspeedConfig = servletConfig;
        this.jetspeedContext = servletConfig.getServletContext();
        this.portletDefinition = portletDefinition;
        this.activated = true;
    }

    public void passivate() {
        this.activated = false;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void invoke(PortletRequestContext requestContext, PortletRequest portletRequest, PortletResponse portletResponse, PortletWindow.Action action, FilterManager filter) throws PortletException, IOException {
        PortletWindowImpl window = (PortletWindowImpl)requestContext.getPortletWindow();
        PortletDefinition portletDefinition = window.getPortletDefinition();
        PortletApplication app = portletDefinition.getApplication();
        String appContextPath = app.getContextPath();
        ServletContext appContext = this.jetspeedContext.getContext(appContextPath);
        if (null == appContext) {
            String message = "Failed to find Servlet context for Portlet Application: " + appContextPath;
            log.error(message);
            throw new PortletException(message);
        }
        PortletInstance portletInstance = this.portletFactory.getPortletInstance(appContext, portletDefinition);
        RequestDispatcher dispatcher = appContext.getRequestDispatcher(this.servletMappingName);
        if (null == dispatcher) {
            String message = "Failed to get Request Dispatcher for Portlet Application: " + appContextPath + ", servlet: " + this.servletMappingName;
            log.error(message);
            throw new PortletException(message);
        }
        boolean useForward = window.getAttribute("org.apache.jetspeed.portlet.container.invoker.useForward") != null;
        try {
            PortletResponseContext responseContext = (PortletResponseContext)portletRequest.getAttribute(PortletInvokerService.RESPONSE_CONTEXT);
            ((JetspeedRequestContext)window.getRequestContext()).setCurrentPortletWindow((PortletWindow)window);
            window.setInvocationState(action, requestContext, responseContext, portletRequest, portletResponse, portletInstance);
            window.setAttribute("org.apache.jetspeed.Fragment", (Object)window.getFragment());
            window.setAttribute("org.apache.jetspeed.portlet.window", (Object)window);
            window.setAttribute("org.apache.jetspeed.portlet.definition", (Object)portletDefinition);
            window.setAttribute("org.apache.jetspeed.portlet.container.filterManager", (Object)filter);
            ServletRequest request = this.requestResponseUnwrapper.unwrapContainerRequest(requestContext.getContainerRequest());
            ServletResponse response = this.requestResponseUnwrapper.unwrapContainerResponse(requestContext.getContainerResponse());
            if (useForward) {
                dispatcher.forward(request, response);
            } else {
                dispatcher.include(request, response);
            }
        }
        catch (Exception e) {
            String message = "Failed to dispatch." + (useForward ? "forward" : "include") + " for Portlet Application: " + appContextPath + ", servlet: " + this.servletMappingName;
            log.error(message, (Throwable)e);
            throw new PortletException(message, (Throwable)e);
        }
        finally {
            ((JetspeedRequestContext)window.getRequestContext()).setCurrentPortletWindow(null);
        }
    }
}

