/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container.services;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventPortlet;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceServingPortlet;
import javax.portlet.filter.ActionFilter;
import javax.portlet.filter.EventFilter;
import javax.portlet.filter.FilterChain;
import javax.portlet.filter.FilterConfig;
import javax.portlet.filter.RenderFilter;
import javax.portlet.filter.ResourceFilter;
import org.apache.jetspeed.container.services.JetspeedFilterConfigImpl;
import org.apache.jetspeed.factory.PortletFilterInstance;

public class JetspeedFilterChain
implements FilterChain {
    private List<PortletFilterInstance> filterList = new ArrayList<PortletFilterInstance>();
    private String lifeCycle;
    Portlet portlet;
    EventPortlet eventPortlet;
    ResourceServingPortlet resourceServingPortlet;
    PortletContext portletContext;
    int filterListIndex = 0;
    boolean filtersInitialized;

    public JetspeedFilterChain(String lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public void processFilter(PortletRequest req, PortletResponse res, EventPortlet eventPortlet, PortletContext portletContext) throws IOException, PortletException {
        this.initFilters(portletContext);
        this.eventPortlet = eventPortlet;
        this.portletContext = portletContext;
        this.doFilter((EventRequest)req, (EventResponse)res);
    }

    public void processFilter(PortletRequest req, PortletResponse res, ResourceServingPortlet resourceServingPortlet, PortletContext portletContext) throws IOException, PortletException {
        this.initFilters(portletContext);
        this.resourceServingPortlet = resourceServingPortlet;
        this.portletContext = portletContext;
        this.doFilter((ResourceRequest)req, (ResourceResponse)res);
    }

    public void processFilter(PortletRequest req, PortletResponse res, Portlet portlet, PortletContext portletContext) throws IOException, PortletException {
        this.initFilters(portletContext);
        this.portlet = portlet;
        this.portletContext = portletContext;
        if (this.lifeCycle.equals("ACTION_PHASE")) {
            this.doFilter((ActionRequest)req, (ActionResponse)res);
        } else if (this.lifeCycle.equals("RENDER_PHASE")) {
            this.doFilter((RenderRequest)req, (RenderResponse)res);
        }
    }

    public void addFilterInstance(PortletFilterInstance filter) {
        this.filterList.add(filter);
    }

    public void doFilter(ActionRequest request, ActionResponse response) throws IOException, PortletException {
        if (this.filterListIndex < this.filterList.size()) {
            PortletFilterInstance filter = this.filterList.get(this.filterListIndex);
            ++this.filterListIndex;
            ActionFilter actionFilter = (ActionFilter)filter.getRealPortletFilter();
            actionFilter.doFilter(request, response, (FilterChain)this);
        } else {
            this.portlet.processAction(request, response);
        }
    }

    public void doFilter(EventRequest request, EventResponse response) throws IOException, PortletException {
        if (this.filterListIndex < this.filterList.size()) {
            PortletFilterInstance filter = this.filterList.get(this.filterListIndex);
            ++this.filterListIndex;
            EventFilter eventFilter = (EventFilter)filter.getRealPortletFilter();
            eventFilter.doFilter(request, response, (FilterChain)this);
        } else {
            this.eventPortlet.processEvent(request, response);
        }
    }

    public void doFilter(RenderRequest request, RenderResponse response) throws IOException, PortletException {
        if (this.filterListIndex < this.filterList.size()) {
            PortletFilterInstance filter = this.filterList.get(this.filterListIndex);
            ++this.filterListIndex;
            RenderFilter renderFilter = (RenderFilter)filter.getRealPortletFilter();
            renderFilter.doFilter(request, response, (FilterChain)this);
        } else {
            this.portlet.render(request, response);
        }
    }

    public void doFilter(ResourceRequest request, ResourceResponse response) throws IOException, PortletException {
        if (this.filterListIndex < this.filterList.size()) {
            PortletFilterInstance filter = this.filterList.get(this.filterListIndex);
            ++this.filterListIndex;
            ResourceFilter resourceFilter = (ResourceFilter)filter.getRealPortletFilter();
            resourceFilter.doFilter(request, response, (FilterChain)this);
        } else {
            this.resourceServingPortlet.serveResource(request, response);
        }
    }

    private void initFilters(PortletContext portletContext) throws PortletException {
        if (!this.filtersInitialized) {
            for (PortletFilterInstance filterInstance : this.filterList) {
                if (filterInstance.isInitialized()) continue;
                JetspeedFilterConfigImpl filterConfig = new JetspeedFilterConfigImpl(filterInstance.getFilter(), portletContext);
                filterInstance.init((FilterConfig)filterConfig);
            }
            this.filtersInitialized = true;
        }
    }
}

