/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container.session;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalSessionValidationFilter
implements Filter {
    public static final String SESSION_VALIDATED_ATTRIBUTE_NAME = PortalSessionValidationFilter.class.getName() + ".validated";
    private static Logger log = LoggerFactory.getLogger(PortalSessionValidationFilter.class);

    public static HttpSession getValidSession(HttpServletRequest request) {
        HttpSession httpSession = request.getSession(false);
        if (request.getAttribute(SESSION_VALIDATED_ATTRIBUTE_NAME) == null) {
            request.setAttribute(SESSION_VALIDATED_ATTRIBUTE_NAME, (Object)Boolean.TRUE);
            if (httpSession != null) {
                int maxInactiveInterval = httpSession.getMaxInactiveInterval();
                long lastAccesstime = httpSession.getLastAccessedTime();
                if (maxInactiveInterval >= 0 && lastAccesstime > 0L) {
                    long maxInactiveTime = (long)httpSession.getMaxInactiveInterval() * 1000L;
                    long currentInactiveTime = System.currentTimeMillis() - lastAccesstime;
                    if (currentInactiveTime > maxInactiveTime) {
                        if (log.isDebugEnabled()) {
                            log.debug("The current HttpSession with ID {} is expired and will be invalidated.", (Object)httpSession.getId());
                        }
                        httpSession.invalidate();
                        httpSession = null;
                    }
                }
            }
        }
        return httpSession;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            PortalSessionValidationFilter.getValidSession((HttpServletRequest)request);
        }
        if (filterChain != null) {
            filterChain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

