/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container.session;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import org.apache.jetspeed.container.session.PortalSessionMonitor;
import org.apache.jetspeed.container.session.PortalSessionMonitorImpl;
import org.apache.jetspeed.container.session.PortalSessionsManager;
import org.apache.jetspeed.container.session.PortletApplicationSessionMonitor;
import org.apache.jetspeed.container.session.PortletApplicationSessionMonitorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalSessionsManagerImpl
implements PortalSessionsManager {
    private static Logger log = LoggerFactory.getLogger(PortalSessionsManagerImpl.class);
    private long portalSessionKeySequence = System.currentTimeMillis();
    private Map<String, PortalSessionRegistry> portalSessionsRegistry = Collections.synchronizedMap(new HashMap());
    private boolean forceInvalidate;

    public PortalSessionsManagerImpl() {
        this(true);
    }

    public PortalSessionsManagerImpl(boolean forceInvalidate) {
        this.forceInvalidate = forceInvalidate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void portalSessionCreated(HttpSession portalSession) {
        PortalSessionMonitor psm = null;
        boolean newMonitor = false;
        PortalSessionsManagerImpl portalSessionsManagerImpl = this;
        synchronized (portalSessionsManagerImpl) {
            psm = (PortalSessionMonitor)portalSession.getAttribute(PortalSessionMonitor.SESSION_KEY);
            if (psm != null && psm.getSessionId() != portalSession.getId()) {
                PortalSessionRegistry psr = this.portalSessionsRegistry.remove(psm.getSessionId());
                if (psr != null) {
                    psm.valueBound(new HttpSessionBindingEvent(portalSession, null));
                    for (PortletApplicationSessionMonitor pasm : this.valuesShallowCopy(psr.sessionMonitors.values())) {
                        pasm.syncPortalSessionId(psm);
                    }
                    this.portalSessionsRegistry.put(psm.getSessionId(), psr);
                } else {
                    psm = null;
                }
            }
            if (psm == null) {
                psm = new PortalSessionMonitorImpl(++this.portalSessionKeySequence, this.forceInvalidate);
                newMonitor = true;
            }
        }
        if (newMonitor) {
            portalSession.setAttribute(PortalSessionMonitor.SESSION_KEY, (Object)psm);
        }
        this.portalSessionDidActivate(psm);
    }

    public void portalSessionWillPassivate(PortalSessionMonitor psm) {
        this.portalSessionsRegistry.remove(psm.getSessionId());
    }

    public void portalSessionDidActivate(PortalSessionMonitor restoredPsm) {
        PortalSessionRegistry psr = this.portalSessionsRegistry.get(restoredPsm.getSessionId());
        if (psr != null && psr.portalSessionKey != -1L && psr.portalSessionKey != restoredPsm.getSessionKey()) {
            this.portalSessionDestroyed(psr.psm);
            psr = null;
        }
        if (psr == null) {
            psr = new PortalSessionRegistry();
            this.portalSessionsRegistry.put(restoredPsm.getSessionId(), psr);
        }
        psr.psm = restoredPsm;
        psr.portalSessionKey = restoredPsm.getSessionKey();
        for (PortletApplicationSessionMonitor pasm : this.valuesShallowCopy(psr.sessionMonitors.values())) {
            if (pasm.getPortalSessionKey() == psr.portalSessionKey) continue;
            pasm.invalidateSession();
            psr.sessionMonitors.remove(pasm.getContextPath());
        }
    }

    public void portalSessionDestroyed(PortalSessionMonitor psm) {
        PortalSessionRegistry psr = this.portalSessionsRegistry.remove(psm.getSessionId());
        if (psr != null) {
            for (PortletApplicationSessionMonitor pasm : this.valuesShallowCopy(psr.sessionMonitors.values())) {
                pasm.invalidateSession();
            }
            try {
                psm.invalidateSession();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public void checkMonitorSession(String contextPath, HttpSession portalSession, HttpSession paSession) {
        if (portalSession != null && paSession != null) {
            PortletApplicationSessionMonitor pasm;
            if (portalSession == paSession) {
                log.warn("servlet context name of paSession(" + paSession.getId() + "): " + paSession.getServletContext().getServletContextName());
                return;
            }
            PortalSessionRegistry psr = this.portalSessionsRegistry.get(portalSession.getId());
            if (psr == null) {
                PortalSessionMonitor psm = (PortalSessionMonitor)portalSession.getAttribute(PortalSessionMonitor.SESSION_KEY);
                if (psm == null || this.portalSessionsRegistry.containsKey(psm.getSessionId())) {
                    this.portalSessionCreated(portalSession);
                } else {
                    this.portalSessionDidActivate(psm);
                }
                psr = this.portalSessionsRegistry.get(portalSession.getId());
            }
            if ((pasm = psr.sessionMonitors.get(contextPath)) != null) {
                try {
                    if (paSession.getAttribute(PortletApplicationSessionMonitor.SESSION_KEY) == null) {
                        pasm.invalidateSession();
                        pasm = null;
                    }
                }
                catch (IllegalStateException ise) {
                    // empty catch block
                }
            }
            if (pasm == null) {
                pasm = new PortletApplicationSessionMonitorImpl(contextPath, portalSession.getId(), psr.portalSessionKey, this.forceInvalidate);
                try {
                    paSession.setAttribute(PortletApplicationSessionMonitor.SESSION_KEY, (Object)pasm);
                    psr.sessionMonitors.put(contextPath, pasm);
                }
                catch (IllegalStateException ise) {
                    // empty catch block
                }
            }
        }
    }

    public void sessionWillPassivate(PortletApplicationSessionMonitor pasm) {
        PortalSessionRegistry psr = this.portalSessionsRegistry.get(pasm.getPortalSessionId());
        if (psr != null) {
            psr.sessionMonitors.remove(pasm.getContextPath());
        }
    }

    public void sessionDidActivate(PortletApplicationSessionMonitor restoredPasm) {
        PortalSessionRegistry psr = this.portalSessionsRegistry.get(restoredPasm.getPortalSessionId());
        if (psr == null) {
            psr = new PortalSessionRegistry();
            psr.psm = new PortalSessionMonitorImpl(-1L);
            this.portalSessionsRegistry.put(restoredPasm.getPortalSessionId(), psr);
        }
        restoredPasm.getSession().setAttribute(PortletApplicationSessionMonitor.SESSION_KEY, (Object)restoredPasm);
        psr.sessionMonitors.put(restoredPasm.getContextPath(), restoredPasm);
    }

    public void sessionDestroyed(PortletApplicationSessionMonitor pasm) {
        PortalSessionRegistry psr = this.portalSessionsRegistry.get(pasm.getPortalSessionId());
        if (psr != null) {
            psr.sessionMonitors.remove(pasm.getContextPath());
            try {
                pasm.invalidateSession();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public int sessionCount() {
        return this.portalSessionsRegistry.size();
    }

    private Collection<PortletApplicationSessionMonitor> valuesShallowCopy(Collection<PortletApplicationSessionMonitor> inValues) {
        return Arrays.asList(inValues.toArray(new PortletApplicationSessionMonitor[0]));
    }

    private static final class PortalSessionRegistry {
        long portalSessionKey;
        PortalSessionMonitor psm;
        Map<String, PortletApplicationSessionMonitor> sessionMonitors = Collections.synchronizedMap(new HashMap());

        PortalSessionRegistry() {
        }
    }
}

