/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container.state.impl;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import org.apache.jetspeed.PortalContext;
import org.apache.jetspeed.container.state.FailedToCreateNavStateException;
import org.apache.jetspeed.container.state.NavigationalState;
import org.apache.jetspeed.container.state.NavigationalStateComponent;
import org.apache.jetspeed.container.url.PortalURL;
import org.apache.jetspeed.util.ArgUtil;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

public class JetspeedNavigationalStateComponent
implements NavigationalStateComponent,
BeanFactoryAware {
    private final String navBeanName;
    private final String urlBeanName;
    private final String desktopUrlBeanName;
    private final Map<String, PortletMode> supportedPortletModes = Collections.synchronizedMap(new HashMap());
    private final Map<String, WindowState> supportedWindowStates = Collections.synchronizedMap(new HashMap());
    private BeanFactory beanFactory;

    public JetspeedNavigationalStateComponent(String navBeanName, String urlBeanName, PortalContext portalContext, String desktopUrlBeanName) throws ClassNotFoundException {
        ArgUtil.assertNotNull(String.class, (Object)navBeanName, (Object)this);
        ArgUtil.assertNotNull(String.class, (Object)urlBeanName, (Object)this);
        this.navBeanName = navBeanName;
        this.urlBeanName = urlBeanName;
        this.desktopUrlBeanName = desktopUrlBeanName;
        Enumeration portletModesEnum = portalContext.getSupportedPortletModes();
        while (portletModesEnum.hasMoreElements()) {
            PortletMode portletMode = (PortletMode)portletModesEnum.nextElement();
            this.supportedPortletModes.put(portletMode.toString(), portletMode);
        }
        Enumeration windowStatesEnum = portalContext.getSupportedWindowStates();
        while (windowStatesEnum.hasMoreElements()) {
            WindowState windowState = (WindowState)windowStatesEnum.nextElement();
            this.supportedWindowStates.put(windowState.toString(), windowState);
        }
    }

    public NavigationalState create() throws FailedToCreateNavStateException {
        try {
            return (NavigationalState)this.beanFactory.getBean(this.navBeanName, NavigationalState.class);
        }
        catch (BeansException e) {
            throw new FailedToCreateNavStateException("Spring failed to create the NavigationalState bean.", (Throwable)e);
        }
    }

    public PortalURL createURL(HttpServletRequest request, String characterEncoding) {
        PortalURL url = (PortalURL)this.beanFactory.getBean(this.urlBeanName, PortalURL.class);
        url.setRequest(request);
        url.setCharacterEncoding(characterEncoding);
        return url;
    }

    public WindowState lookupWindowState(String name) {
        return this.supportedWindowStates.get(name.toLowerCase());
    }

    public PortletMode lookupPortletMode(String name) {
        return this.supportedPortletModes.get(name.toLowerCase());
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public PortalURL createDesktopURL(HttpServletRequest request, String characterEncoding) {
        PortalURL url = (PortalURL)this.beanFactory.getBean(this.desktopUrlBeanName, PortalURL.class);
        url.setRequest(request);
        url.setCharacterEncoding(characterEncoding);
        return url;
    }
}

