/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container.state.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.jetspeed.container.state.impl.PortletWindowExtendedNavigationalState;
import org.apache.jetspeed.om.portlet.ContainerRuntimeOption;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.om.portlet.PublicRenderParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletWindowRequestNavigationalState
extends PortletWindowExtendedNavigationalState {
    private static final long serialVersionUID = 3807035638733358425L;
    private String windowId;
    private PortletDefinition pd;
    private String cacheLevel;
    private String resourceId;
    private Map<String, String[]> privateRenderParametersMap;
    private Map<String, String[]> targetPublicRenderParametersMap;
    private Map<String, String[]> publicRenderParametersMap;
    private Map<QName, String> qnameToIdentifierMap;
    private Map<String, QName> identifierToQNameMap;
    private boolean targetted;
    private boolean clearParameters;

    public PortletWindowRequestNavigationalState(String windowId) {
        this.windowId = windowId;
    }

    public String getWindowId() {
        return this.windowId;
    }

    public void setPortletDefinition(PortletDefinition pd) {
        this.pd = pd;
    }

    public void resolveActionScopedRequestAttributes() {
        if (this.pd != null) {
            ContainerRuntimeOption actionScopedRequestAttributesOption = this.pd.getContainerRuntimeOption("javax.portlet.actionScopedRequestAttributes");
            if (actionScopedRequestAttributesOption == null) {
                actionScopedRequestAttributesOption = this.pd.getApplication().getContainerRuntimeOption("javax.portlet.actionScopedRequestAttributes");
            }
            this.setActionScopedRequestAttributes(actionScopedRequestAttributesOption != null && actionScopedRequestAttributesOption.getValues() != null && actionScopedRequestAttributesOption.getValues().size() > 0 && Boolean.parseBoolean((String)actionScopedRequestAttributesOption.getValues().get(0)));
        }
    }

    public void resolvePublicRenderParametersMapping() {
        if (this.pd != null && this.qnameToIdentifierMap == null) {
            this.qnameToIdentifierMap = new HashMap<QName, String>();
            this.identifierToQNameMap = new HashMap<String, QName>();
            for (String identifier : this.pd.getSupportedPublicRenderParameters()) {
                PublicRenderParameter prp = this.pd.getApplication().getPublicRenderParameter(identifier);
                if (prp == null) continue;
                this.qnameToIdentifierMap.put(prp.getQName(), identifier);
                this.identifierToQNameMap.put(identifier, prp.getQName());
            }
        }
    }

    public PortletDefinition getPortletDefinition() {
        return this.pd;
    }

    public Map<QName, String> getPublicRenderParametersQNameToIdentifierMap() {
        this.resolvePublicRenderParametersMapping();
        return this.qnameToIdentifierMap;
    }

    public QName getPublicRenderParameterQNameByIdentifier(String identifier) {
        this.resolvePublicRenderParametersMapping();
        return this.identifierToQNameMap.get(identifier);
    }

    public String getPublicRenderParameterIdentifierByQName(QName qname) {
        this.resolvePublicRenderParametersMapping();
        return this.qnameToIdentifierMap.get(qname);
    }

    public String getCacheLevel() {
        return this.cacheLevel;
    }

    public void setCacheLevel(String cacheLevel) {
        this.cacheLevel = cacheLevel;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public Map<String, String[]> getPrivateRenderParametersMap() {
        if (this.privateRenderParametersMap == null) {
            this.privateRenderParametersMap = Collections.emptyMap();
        }
        return this.privateRenderParametersMap;
    }

    public void setPrivateRenderParameters(String name, String[] values) {
        if (this.privateRenderParametersMap == null) {
            this.privateRenderParametersMap = new HashMap<String, String[]>();
        }
        this.privateRenderParametersMap.put(name, values);
    }

    public void setPrivateRenderParametersMap(Map<String, String[]> privateRenderParametersMap) {
        this.privateRenderParametersMap = privateRenderParametersMap;
    }

    public Map<String, String[]> getPublicRenderParametersMap() {
        return this.publicRenderParametersMap;
    }

    public void setPublicRenderParameters(String name, String[] values) {
        if (this.publicRenderParametersMap == null) {
            this.publicRenderParametersMap = new HashMap<String, String[]>();
        }
        this.publicRenderParametersMap.put(name, values);
    }

    public void setPublicRenderParametersMap(Map<String, String[]> publicRenderParametersMap) {
        this.publicRenderParametersMap = publicRenderParametersMap;
    }

    public Map<String, String[]> getTargetPublicRenderParametersMap() {
        if (this.targetPublicRenderParametersMap == null) {
            this.targetPublicRenderParametersMap = new HashMap<String, String[]>();
        }
        return this.targetPublicRenderParametersMap;
    }

    public void setTargetPublicRenderParametersMap(Map<String, String[]> map) {
        this.targetPublicRenderParametersMap = map;
    }

    public boolean isClearParameters() {
        return this.clearParameters;
    }

    public void setClearParameters(boolean ignoreParameters) {
        this.clearParameters = ignoreParameters;
    }

    public boolean isTargetted() {
        return this.targetted;
    }

    public void setTargetted(boolean targetted) {
        this.targetted = targetted;
    }
}

