/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container.state.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.jetspeed.container.PortletWindow;
import org.apache.jetspeed.container.state.impl.PortletWindowRequestNavigationalState;
import org.apache.jetspeed.container.url.PortalURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletWindowRequestNavigationalStates {
    private String characterEncoding;
    private Map<String, PortletWindowRequestNavigationalState> pwnStates = new HashMap<String, PortletWindowRequestNavigationalState>();
    private PortalURL.URLType urlType;
    private PortletWindow maximizedWindow;
    private PortletWindow actionWindow;
    private PortletWindow resourceWindow;
    private String targetWindowId;
    private Map<QName, String[]> publicRenderParametersMap;

    public PortletWindowRequestNavigationalStates(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public Map<String, PortletWindowRequestNavigationalState> getPortletWindowRequestNavigationalStates() {
        return this.pwnStates;
    }

    public Iterator<String> getWindowIdIterator() {
        return this.pwnStates.keySet().iterator();
    }

    public void removePortletWindowNavigationalState(String windowId) {
        boolean removed;
        boolean bl = removed = this.pwnStates.remove(windowId) != null;
        if (removed) {
            if (this.maximizedWindow != null && windowId.equals(this.maximizedWindow.getId().toString())) {
                this.maximizedWindow = null;
            }
            if (this.actionWindow != null && windowId.equals(this.actionWindow.getId().toString())) {
                this.actionWindow = null;
            }
            if (this.resourceWindow != null && windowId.equals(this.actionWindow.getId().toString())) {
                this.resourceWindow = null;
            }
        }
    }

    public PortalURL.URLType getURLType() {
        return this.urlType;
    }

    public void setURLType(PortalURL.URLType urlType) {
        this.urlType = urlType;
    }

    public PortletWindowRequestNavigationalState getPortletWindowNavigationalState(String windowId) {
        return this.pwnStates.get(windowId);
    }

    public void addPortletWindowNavigationalState(String windowId, PortletWindowRequestNavigationalState pwnState) {
        this.pwnStates.put(windowId, pwnState);
    }

    public PortletWindow getMaximizedWindow() {
        return this.maximizedWindow;
    }

    public void setMaximizedWindow(PortletWindow maximizedWindow) {
        this.maximizedWindow = maximizedWindow;
    }

    public PortletWindow getActionWindow() {
        return this.actionWindow;
    }

    public void setActionWindow(PortletWindow actionWindow) {
        this.actionWindow = actionWindow;
    }

    public void setResourceWindow(PortletWindow resourceWindow) {
        this.resourceWindow = resourceWindow;
    }

    public PortletWindow getResourceWindow() {
        return this.resourceWindow;
    }

    public void setTargetWindowId(String windowId) {
        this.targetWindowId = windowId;
    }

    public String getTargetWindowId() {
        return this.targetWindowId;
    }

    public Map<QName, String[]> getPublicRenderParametersMap() {
        return this.publicRenderParametersMap;
    }

    public Map<String, String[]> getPublicRenderParametersMap(String windowId) {
        HashMap<String, String[]> map = null;
        PortletWindowRequestNavigationalState state = this.pwnStates.get(windowId);
        if (state != null && state.getPublicRenderParametersMap() == null) {
            if (this.publicRenderParametersMap != null && state.getPublicRenderParametersQNameToIdentifierMap() != null) {
                for (Map.Entry<QName, String> entry : state.getPublicRenderParametersQNameToIdentifierMap().entrySet()) {
                    String[] values = this.publicRenderParametersMap.get(entry.getKey());
                    if (values == null) continue;
                    if (map == null) {
                        map = new HashMap<String, String[]>();
                    }
                    map.put(entry.getValue(), values);
                }
            }
            state.setPublicRenderParametersMap(map);
        }
        return map;
    }

    public void setPublicRenderParametersMap(Map<QName, String[]> publicRenderParametersMap) {
        this.publicRenderParametersMap = publicRenderParametersMap;
    }
}

