/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container.state.impl;

import org.apache.jetspeed.cache.JetspeedContentCache;
import org.apache.jetspeed.container.state.impl.NavigationalStateCodec;
import org.apache.jetspeed.container.state.impl.SessionFullNavigationalState;
import org.apache.jetspeed.request.RequestContext;

public class SessionFullExtendedNavigationalState
extends SessionFullNavigationalState {
    private boolean clearStateOnPageChangeEnabled = false;

    public SessionFullExtendedNavigationalState(NavigationalStateCodec codec, JetspeedContentCache cache) {
        super(codec, cache);
    }

    public SessionFullExtendedNavigationalState(NavigationalStateCodec codec, JetspeedContentCache cache, JetspeedContentCache decorationCache) {
        super(codec, cache, decorationCache);
    }

    public SessionFullExtendedNavigationalState(NavigationalStateCodec codec, JetspeedContentCache cache, JetspeedContentCache decorationCache, boolean clearStateOnPageChangeEnabled) {
        super(codec, cache, decorationCache);
        this.clearStateOnPageChangeEnabled = clearStateOnPageChangeEnabled;
    }

    protected boolean clearPagePortletsModeAndWindowState(RequestContext context) {
        Boolean pageNavigationEvent;
        String contextKey = "clearPortletsModeAndWindowState";
        boolean result = false;
        if (this.clearStateOnPageChangeEnabled && (pageNavigationEvent = (Boolean)context.getAttribute(contextKey)) != null) {
            result = pageNavigationEvent;
        }
        context.setAttribute(contextKey, (Object)Boolean.FALSE);
        return result;
    }

    public synchronized boolean sync(RequestContext context) {
        boolean resetPagePortlets = false;
        if (this.clearStateOnPageChangeEnabled) {
            resetPagePortlets = this.clearPagePortletsModeAndWindowState(context);
            if (this.log.isDebugEnabled()) {
                this.log.debug("resetPagePortlets:" + resetPagePortlets);
            }
        }
        this.setClearPortletsModeAndWindowStateEnabled(resetPagePortlets);
        return super.sync(context);
    }
}

