/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container.state.impl;

import java.util.Map;
import javax.portlet.WindowState;
import javax.servlet.http.HttpSession;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.cache.JetspeedContentCache;
import org.apache.jetspeed.container.state.impl.AbstractNavigationalState;
import org.apache.jetspeed.container.state.impl.NavigationalStateCodec;
import org.apache.jetspeed.container.state.impl.PortletWindowBaseNavigationalState;
import org.apache.jetspeed.container.state.impl.PortletWindowRequestNavigationalStates;
import org.apache.jetspeed.container.state.impl.PortletWindowSessionNavigationalStates;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionNavigationalState
extends AbstractNavigationalState {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private Map<String, PortletWindowBaseNavigationalState> currentPageWindowStates;
    private boolean clearPortletsModeAndWindowStateEnabled = false;

    public SessionNavigationalState(NavigationalStateCodec codec, JetspeedContentCache cache) {
        super(codec, cache);
    }

    public SessionNavigationalState(NavigationalStateCodec codec, JetspeedContentCache cache, JetspeedContentCache decorationCache) {
        super(codec, cache, decorationCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sync(RequestContext context) {
        HttpSession session = context.getRequest().getSession(false);
        Object syncLock = session;
        if (syncLock == null) {
            syncLock = new Object();
        }
        HttpSession httpSession = syncLock;
        synchronized (httpSession) {
            ContentPage page;
            PortletWindowSessionNavigationalStates sessionStates;
            boolean result = this.resolvePortletWindows(context);
            this.resolvePublicParametersMap();
            PortletWindowRequestNavigationalStates requestStates = this.getPortletWindowRequestNavigationalStates();
            boolean transientNavState = requestStates.getResourceWindow() != null;
            String clearCacheWindowId = null;
            if (!transientNavState) {
                String requestMaximizedWindowId = null;
                if (requestStates.getMaximizedWindow() != null) {
                    requestMaximizedWindowId = requestStates.getMaximizedWindow().getId().toString();
                    WindowState state = requestStates.getPortletWindowNavigationalState(requestMaximizedWindowId).getWindowState();
                    transientNavState = JetspeedActions.SOLO_STATE.equals((Object)state);
                    clearCacheWindowId = requestMaximizedWindowId;
                }
            }
            if (transientNavState) {
                if (clearCacheWindowId != null && session != null && (sessionStates = (PortletWindowSessionNavigationalStates)session.getAttribute("org.apache.jetspeed.navstate")) != null) {
                    sessionStates.removeFromCache(context, clearCacheWindowId, this.cache);
                    page = context.getPage();
                    sessionStates.removeFromCache(context, page.getId(), this.decorationCache);
                }
            } else if (session != null) {
                sessionStates = (PortletWindowSessionNavigationalStates)session.getAttribute("org.apache.jetspeed.navstate");
                if (sessionStates == null) {
                    sessionStates = new PortletWindowSessionNavigationalStates(this.isRenderParameterStateFull());
                    session.setAttribute("org.apache.jetspeed.navstate", (Object)sessionStates);
                }
                page = context.getPage();
                if (this.isClearPortletsModeAndWindowStateEnabled()) {
                    sessionStates.changeAllPortletsToViewModeAndNormalWindowState(context, page, requestStates, this.cache, this.decorationCache);
                } else {
                    sessionStates.sync(context, context.getPage(), requestStates, this.cache, this.decorationCache);
                }
                if (this.isNavigationalParameterStateFull() && this.isRenderParameterStateFull()) {
                    this.currentPageWindowStates = sessionStates.getWindowStates(page);
                }
            }
            this.syncPublicRequestParameters(context, transientNavState);
            this.resetRequestPortletWindowPublicRenderParameters();
            this.resolveRequestParameterMap(context);
            return result;
        }
    }

    public Map<String, PortletWindowBaseNavigationalState> getCurrentPageWindowStates() {
        return this.currentPageWindowStates;
    }

    public boolean isNavigationalParameterStateFull() {
        return true;
    }

    public boolean isRenderParameterStateFull() {
        return false;
    }

    protected void setClearPortletsModeAndWindowStateEnabled(boolean clearPortletsModeAndWindowStateEnabled) {
        this.clearPortletsModeAndWindowStateEnabled = clearPortletsModeAndWindowStateEnabled;
    }

    protected boolean isClearPortletsModeAndWindowStateEnabled() {
        return this.clearPortletsModeAndWindowStateEnabled;
    }
}

