/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container.url.impl;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.jetspeed.container.url.BasePortalURL;

public class BasePortalURLImpl
implements BasePortalURL {
    private String serverName;
    private String serverScheme;
    private int serverPort;
    private boolean secure;

    public BasePortalURLImpl() {
    }

    public BasePortalURLImpl(String environmentPath) throws ConfigurationException {
        String propertyFilePath = null;
        if (environmentPath != null) {
            propertyFilePath = System.getProperty(environmentPath);
        }
        PropertiesConfiguration config = null;
        if (propertyFilePath != null) {
            config = new PropertiesConfiguration(propertyFilePath);
        }
        if (config != null) {
            this.serverName = config.getString("portal.url.name");
            this.serverScheme = config.getString("portal.url.scheme");
            this.serverPort = config.getInt("portal.url.port");
            this.secure = config.getBoolean("portal.url.secure");
        }
    }

    public BasePortalURLImpl(Configuration config) {
        this.serverName = config.getString("portal.url.name");
        this.serverScheme = config.getString("portal.url.scheme");
        this.serverPort = config.getInt("portal.url.port");
        this.secure = config.getBoolean("portal.url.secure");
    }

    public BasePortalURLImpl(String serverScheme, String serverName, int serverPort, boolean secure) {
        this.serverName = serverName;
        this.serverScheme = serverScheme;
        this.serverPort = serverPort;
        this.secure = secure;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public String getServerScheme() {
        return this.serverScheme;
    }

    public void setServerScheme(String serverScheme) {
        this.serverScheme = serverScheme;
    }
}

