/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container.url.impl;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.StringTokenizer;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import org.apache.jetspeed.PortalContext;
import org.apache.jetspeed.container.PortletWindow;
import org.apache.jetspeed.container.state.NavigationalState;
import org.apache.jetspeed.container.url.BasePortalURL;
import org.apache.jetspeed.container.url.PortalURL;
import org.apache.jetspeed.container.url.impl.AbstractPortalURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DesktopEncodingPortalURL
extends AbstractPortalURL {
    private String baseActionPath = null;
    private String baseRenderPath = null;
    private String desktopActionPipelinePath = null;
    private String desktopRenderPipelinePath = null;

    public DesktopEncodingPortalURL(NavigationalState navState, PortalContext portalContext, String desktopRenderPipelinePath, String desktopActionPipelinePath) {
        super(navState, portalContext);
        this.initializePipelinePaths(desktopRenderPipelinePath, desktopActionPipelinePath);
    }

    public DesktopEncodingPortalURL(NavigationalState navState, PortalContext portalContext, String desktopRenderPipelinePath, String desktopActionPipelinePath, BasePortalURL base) {
        super(navState, portalContext, base);
        this.initializePipelinePaths(desktopRenderPipelinePath, desktopActionPipelinePath);
    }

    public DesktopEncodingPortalURL(String characterEncoding, NavigationalState navState, PortalContext portalContext) {
        super(characterEncoding, navState, portalContext);
        this.initializePipelinePaths(null, null);
    }

    public DesktopEncodingPortalURL(HttpServletRequest request, String characterEncoding, NavigationalState navState, PortalContext portalContext) {
        super(request, characterEncoding, navState, portalContext);
        this.initializePipelinePaths(null, null);
    }

    private void initializePipelinePaths(String desktopRenderPipelinePath, String desktopActionPipelinePath) {
        if (desktopActionPipelinePath == null || desktopActionPipelinePath.length() == 0) {
            desktopActionPipelinePath = "/action";
        }
        if (desktopActionPipelinePath.charAt(0) != '/') {
            desktopActionPipelinePath = "/" + desktopActionPipelinePath;
        }
        if (desktopActionPipelinePath.length() > 1 && desktopActionPipelinePath.charAt(desktopActionPipelinePath.length() - 1) == '/') {
            desktopActionPipelinePath = desktopActionPipelinePath.substring(0, desktopActionPipelinePath.length() - 1);
        }
        if (desktopRenderPipelinePath == null || desktopRenderPipelinePath.length() == 0) {
            desktopRenderPipelinePath = "/render";
        }
        if (desktopRenderPipelinePath.charAt(0) != '/') {
            desktopRenderPipelinePath = "/" + desktopRenderPipelinePath;
        }
        if (desktopRenderPipelinePath.length() > 1 && desktopRenderPipelinePath.charAt(desktopRenderPipelinePath.length() - 1) == '/') {
            desktopRenderPipelinePath = desktopRenderPipelinePath.substring(0, desktopRenderPipelinePath.length() - 1);
        }
        this.desktopRenderPipelinePath = desktopRenderPipelinePath;
        this.desktopActionPipelinePath = desktopActionPipelinePath;
    }

    @Override
    protected void decodeBasePath(HttpServletRequest request) {
        super.decodeBasePath(request);
        if (this.baseActionPath == null) {
            this.baseActionPath = this.contextPath + this.desktopActionPipelinePath;
            this.baseRenderPath = this.contextPath + this.desktopRenderPipelinePath;
        }
    }

    @Override
    protected void decodePathAndNavigationalState(HttpServletRequest request) {
        String path = null;
        String encodedNavState = null;
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            StringTokenizer tokenizer = new StringTokenizer(request.getPathInfo(), "/");
            StringBuffer buffer = new StringBuffer();
            boolean foundNavState = false;
            String navStatePrefix = DesktopEncodingPortalURL.getNavigationalStateParameterName() + ":";
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (!foundNavState && token.startsWith(navStatePrefix)) {
                    foundNavState = true;
                    if (token.length() <= navStatePrefix.length()) continue;
                    encodedNavState = token.substring(navStatePrefix.length());
                    continue;
                }
                buffer.append("/");
                buffer.append(token);
            }
            path = buffer.length() > 0 ? buffer.toString() : "/";
        }
        this.setPath(path);
        this.setEncodedNavigationalState(encodedNavState);
    }

    @Override
    protected String createPortletURL(String encodedNavState, boolean secure) {
        PortletWindow actionWindow = null;
        if (PortalURL.URLType.ACTION == this.navState.getURLType()) {
            actionWindow = this.navState.getPortletWindowOfAction();
        }
        return this.createPortletURL(encodedNavState, secure, actionWindow, PortalURL.URLType.RENDER, false);
    }

    protected String createPortletURL(String encodedNavState, boolean secure, PortletWindow window, PortalURL.URLType urlType, boolean desktopRequestNotAjax) {
        StringBuffer buffer = new StringBuffer("");
        buffer.append(this.getBaseURL(secure));
        boolean desktopEncoder = false;
        if (PortalURL.URLType.ACTION.equals((Object)urlType)) {
            buffer.append(this.baseActionPath);
        } else {
            buffer.append(this.baseRenderPath);
            if (PortalURL.URLType.RESOURCE.equals((Object)urlType)) {
                desktopEncoder = true;
            }
        }
        if (encodedNavState != null) {
            buffer.append("/");
            buffer.append(DesktopEncodingPortalURL.getNavigationalStateParameterName());
            buffer.append(":");
            buffer.append(encodedNavState);
        }
        if (this.getPath() != null) {
            buffer.append(this.getPath());
        }
        if (!desktopEncoder) {
            if (!desktopRequestNotAjax) {
                buffer.append("?entity=").append(window.getId().toString());
                buffer.append("&portlet=").append(window.getPortletDefinition().getUniqueName());
            }
        } else {
            buffer.append("?encoder=desktop");
        }
        return buffer.toString();
    }

    @Override
    public String createPortletURL(PortletWindow window, Map<String, String[]> parameters, String actionScopeId, boolean actionScopeRendered, String cacheLevel, String resourceId, Map<String, String[]> privateRenderParameters, Map<String, String[]> publicRenderParameters, PortletMode mode, WindowState state, PortalURL.URLType urlType, boolean secure) {
        try {
            boolean desktopRequestNotAjax = false;
            if (parameters != null && parameters.containsKey("org.apache.jetspeed.desktop.request.not.ajax")) {
                desktopRequestNotAjax = true;
                parameters.remove("org.apache.jetspeed.desktop.request.not.ajax");
            }
            String ns = this.getNavigationalState().encode(window, parameters, actionScopeId, actionScopeRendered, cacheLevel, resourceId, privateRenderParameters, publicRenderParameters, mode, state, urlType);
            return this.createPortletURL(ns, secure, window, urlType, desktopRequestNotAjax);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }
}

