/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container.url.impl;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.jetspeed.container.state.NavigationalStateComponent;
import org.apache.jetspeed.pipeline.PipelineException;
import org.apache.jetspeed.pipeline.valve.AbstractValve;
import org.apache.jetspeed.pipeline.valve.ValveContext;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.util.HttpUtils;

public class PortalURLValveImpl
extends AbstractValve {
    private NavigationalStateComponent navComponent;
    private boolean pathInfoParamAllowed;
    private String defaultPathInfoParam;

    public PortalURLValveImpl(NavigationalStateComponent navComponent) {
        this.navComponent = navComponent;
    }

    public void setPathInfoParamAllowed(boolean pathInfoParamAllowed) {
        this.pathInfoParamAllowed = pathInfoParamAllowed;
    }

    public void setDefaultPathInfoParam(String defaultPathInfoParam) {
        this.defaultPathInfoParam = defaultPathInfoParam;
    }

    public void invoke(RequestContext request, ValveContext context) throws PipelineException {
        try {
            if (request.getPortalURL() == null) {
                HttpServletRequest servletRequest = this.getHttpServletRequest(request);
                String encoding = request.getRequestParameter("encoder");
                if ("desktop".equals(encoding)) {
                    request.setPortalURL(this.navComponent.createDesktopURL(servletRequest, request.getCharacterEncoding()));
                    request.setAttribute("desktop.enabled", (Object)Boolean.TRUE);
                } else {
                    request.setPortalURL(this.navComponent.createURL(servletRequest, request.getCharacterEncoding()));
                }
            }
        }
        catch (Exception e) {
            throw new PipelineException((Throwable)e);
        }
        context.invokeNext(request);
    }

    private HttpServletRequest getHttpServletRequest(RequestContext request) {
        Object servletRequest = request.getRequest();
        if (this.pathInfoParamAllowed) {
            String param = null;
            Map<String, String[]> queryParamMap = HttpUtils.parseQueryString(servletRequest.getQueryString());
            String[] pathInfoParams = queryParamMap.get("_portalpath");
            if (pathInfoParams != null && pathInfoParams.length != 0) {
                param = pathInfoParams[0];
            }
            if (param == null && (param = servletRequest.getHeader("X-Portal-Path")) == null) {
                param = this.defaultPathInfoParam;
            }
            if (param != null) {
                int offset = param.indexOf(58);
                servletRequest = offset == -1 ? new PortalPathAdjustedHttpServletRequestWrapper((HttpServletRequest)servletRequest, null, param) : new PortalPathAdjustedHttpServletRequestWrapper((HttpServletRequest)servletRequest, param.substring(0, offset), param.substring(offset + 1));
            }
        }
        return servletRequest;
    }

    public String toString() {
        return "PortalURLValveImpl";
    }

    private static class PortalPathAdjustedHttpServletRequestWrapper
    extends HttpServletRequestWrapper {
        private String servletPath;
        private String pathInfo;

        private PortalPathAdjustedHttpServletRequestWrapper(HttpServletRequest request, String servletPath, String pathInfo) {
            super(request);
            this.servletPath = servletPath;
            this.pathInfo = pathInfo;
        }

        public String getServletPath() {
            return this.servletPath != null ? this.servletPath : super.getServletPath();
        }

        public String getPathInfo() {
            return this.pathInfo != null ? this.pathInfo : super.getPathInfo();
        }
    }
}

