/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.decoration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.container.PortletWindow;
import org.apache.jetspeed.container.url.PortalURL;
import org.apache.jetspeed.decoration.Decoration;
import org.apache.jetspeed.decoration.DecoratorAction;
import org.apache.jetspeed.decoration.DecoratorActionTemplate;
import org.apache.jetspeed.decoration.DecoratorActionsFactory;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.SecurityAccessController;
import org.apache.jetspeed.util.ServletRequestThreadLocalCleanupCallback;

public abstract class AbstractDecoratorActionsFactory
implements DecoratorActionsFactory {
    private static ThreadLocal<Map<String, Object>> actionResourcesMap = new ThreadLocal();
    private boolean editMaximizesOption = false;
    private boolean configMaximizesOption = false;
    private boolean editDefaultsMaximizesOption = false;

    public List getDecoratorActions(RequestContext rc, PortletApplication pa, PortletWindow pw, PortletMode pm, WindowState ws, Decoration decoration, List actionTemplates, PortletDefinition portlet, ContentFragment fragment, SecurityAccessController accessController) {
        boolean checkConstraints = false;
        ArrayList<DecoratorAction> actions = new ArrayList<DecoratorAction>();
        Iterator iter = actionTemplates.iterator();
        while (iter.hasNext()) {
            DecoratorAction action;
            checkConstraints = false;
            DecoratorActionTemplate template = (DecoratorActionTemplate)iter.next();
            if (template.getAction().equals(JetspeedActions.EDIT) || template.getAction().equals(JetspeedActions.HELP)) {
                checkConstraints = true;
            }
            if (checkConstraints && this.checkSecurityConstraint(portlet, fragment, accessController, template.getAction())) {
                action = this.createAction(rc, pw, decoration, template);
                if (action == null) continue;
                actions.add(action);
                continue;
            }
            if (checkConstraints || (action = this.createAction(rc, pw, decoration, template)) == null) continue;
            actions.add(action);
        }
        return actions;
    }

    public List getDecoratorActions(RequestContext rc, PortletApplication pa, PortletWindow pw, PortletMode pm, WindowState ws, Decoration decoration, List actionTemplates) {
        ArrayList<DecoratorAction> actions = new ArrayList<DecoratorAction>();
        Iterator iter = actionTemplates.iterator();
        while (iter.hasNext()) {
            DecoratorAction action = this.createAction(rc, pw, decoration, (DecoratorActionTemplate)iter.next());
            if (action == null) continue;
            actions.add(action);
        }
        return actions;
    }

    protected DecoratorAction createAction(RequestContext rc, PortletWindow pw, Decoration decoration, DecoratorActionTemplate template) {
        PortletMode pm;
        WindowState ws;
        String actionName = template.getAction();
        PortalURL portalURL = rc.getPortalURL();
        Boolean isAjaxRequest = (Boolean)rc.getAttribute("org.apache.jetspeed.decoration.ajax");
        if (this.editMaximizesOption || this.configMaximizesOption || this.editDefaultsMaximizesOption) {
            if (this.editMaximizesOption && template.getAction().equals(JetspeedActions.EDIT)) {
                ws = WindowState.MAXIMIZED;
                pm = template.getCustomMode();
            } else if (this.configMaximizesOption && template.getAction().equals(JetspeedActions.CONFIG)) {
                ws = WindowState.MAXIMIZED;
                pm = template.getCustomMode();
            } else if (this.editDefaultsMaximizesOption && template.getAction().equals(JetspeedActions.EDIT_DEFAULTS)) {
                ws = WindowState.MAXIMIZED;
                pm = template.getCustomMode();
            } else if (template.getAction().equals(JetspeedActions.VIEW)) {
                ws = WindowState.NORMAL;
                pm = template.getCustomMode();
            } else if (template.getAction().equals(JetspeedActions.NORMAL)) {
                pm = PortletMode.VIEW;
                ws = template.getCustomState();
            } else {
                ws = template.getCustomState();
                pm = template.getCustomMode();
            }
        } else {
            ws = template.getCustomState();
            pm = template.getCustomMode();
        }
        String actionURL = rc.getResponse().encodeURL(isAjaxRequest == null ? portalURL.createPortletURL(pw, pm, ws, portalURL.isSecure()).toString() : portalURL.createNavigationalEncoding(pw, pm, ws));
        String linkURL = decoration.getResource("images/" + actionName + ".gif");
        boolean customAction = template.getMode() != null && !template.getMode().equals((Object)template.getCustomMode()) || template.getState() != null && !template.getState().equals((Object)template.getCustomState());
        ResourceBundle bundle = DecoratorAction.getResourceBundle(rc.getLocale());
        Map<String, Object> resourcesMap = actionResourcesMap.get();
        if (resourcesMap != null) {
            ResourceBundle cachedBundle = (ResourceBundle)resourcesMap.get("org.apache.jetspeed.decoration.resources.DecoratorActions");
            if (!bundle.getLocale().equals(cachedBundle.getLocale())) {
                resourcesMap = null;
            }
        }
        String localizedName = null;
        if (resourcesMap == null) {
            resourcesMap = new HashMap<String, Object>();
            actionResourcesMap.set(resourcesMap);
            new ServletRequestThreadLocalCleanupCallback(actionResourcesMap);
            resourcesMap.put("org.apache.jetspeed.decoration.resources.DecoratorActions", bundle);
            localizedName = DecoratorAction.getResourceString(bundle, actionName, actionName);
            resourcesMap.put(actionName, localizedName);
        } else {
            localizedName = (String)resourcesMap.get(actionName);
            if (localizedName == null) {
                localizedName = DecoratorAction.getResourceString(bundle, actionName, actionName);
                resourcesMap.put(actionName, localizedName);
            }
        }
        return new DecoratorAction(actionName, localizedName, localizedName, linkURL, actionURL, customAction, template.getActionType());
    }

    protected boolean checkSecurityConstraint(PortletDefinition portlet, ContentFragment fragment, SecurityAccessController accessController, String action) {
        if (fragment.getType().equals("portlet") && accessController != null) {
            return accessController.checkPortletAccess(portlet, JetspeedActions.getContainerActionMask((String)action));
        }
        return true;
    }

    public void setMaximizeOnEdit(boolean maxOnEdit) {
        this.editMaximizesOption = maxOnEdit;
    }

    public boolean getMaximizeOnEdit() {
        return this.editMaximizesOption;
    }

    public void setMaximizeOnConfig(boolean maxOnConfig) {
        this.configMaximizesOption = maxOnConfig;
    }

    public boolean getMaximizeOnConfig() {
        return this.configMaximizesOption;
    }

    public void setMaximizeOnEditDefaults(boolean maxOnEditDefaults) {
        this.editDefaultsMaximizesOption = maxOnEditDefaults;
    }

    public boolean getMaximizeOnEditDefaults() {
        return this.editDefaultsMaximizesOption;
    }
}

