/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.decoration;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.jetspeed.decoration.Decoration;
import org.apache.jetspeed.decoration.PathResolverCache;
import org.apache.jetspeed.decoration.ResourceValidator;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.util.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseDecoration
implements Decoration,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(BaseDecoration.class);
    protected static final String NO_SUCH_RESOURCE = "no_such_resource";
    protected transient Properties config;
    private transient ResourceValidator validator;
    private final String name;
    private final Path basePath;
    private final Path baseClientPath;
    private transient PathResolverCache cache;
    private final String commonStylesheet;
    private final String portalStylesheet;
    private final String desktopStylesheet;
    private List actions;
    private String currentModeAction;
    private String currentStateAction;
    private boolean supportsDesktop;
    private Decoration.ActionsOption actionsOption = Decoration.ActionsOption.SHOW;
    private Decoration.TitleOption titleOption = Decoration.TitleOption.SHOW;
    private String dragHandleOption;
    static final String[] ACTIONS_NAMES = new String[]{"show", "hide", "dropdown", "hover"};
    static final Decoration.ActionsOption[] ACTIONS_VALUES = new Decoration.ActionsOption[]{Decoration.ActionsOption.SHOW, Decoration.ActionsOption.HIDE, Decoration.ActionsOption.DROPDOWN, Decoration.ActionsOption.HOVER};
    static final String[] TITLE_NAMES = new String[]{"show", "hide"};
    static final Decoration.TitleOption[] TITLE_VALUES = new Decoration.TitleOption[]{Decoration.TitleOption.SHOW, Decoration.TitleOption.HIDE};

    public BaseDecoration(Properties config, ResourceValidator validator, Path basePath, Path baseClientPath, PathResolverCache cache) {
        int ix;
        this.config = config;
        this.validator = validator;
        this.basePath = basePath;
        this.baseClientPath = baseClientPath;
        this.cache = cache;
        this.name = config.getProperty("name");
        String temp = config.getProperty("option.actions");
        if (temp != null) {
            for (ix = 0; ix < ACTIONS_NAMES.length; ++ix) {
                if (!temp.equalsIgnoreCase(ACTIONS_NAMES[ix])) continue;
                this.actionsOption = ACTIONS_VALUES[ix];
                break;
            }
        }
        if ((temp = config.getProperty("option.title")) != null) {
            for (ix = 0; ix < TITLE_NAMES.length; ++ix) {
                if (!temp.equalsIgnoreCase(TITLE_NAMES[ix])) continue;
                this.titleOption = TITLE_VALUES[ix];
                break;
            }
        }
        this.dragHandleOption = config.getProperty("option.draghandle", ".PTitle");
        if (this.dragHandleOption.equalsIgnoreCase("none")) {
            this.dragHandleOption = null;
        }
        this.commonStylesheet = config.getProperty("stylesheet", "css/styles.css");
        this.supportsDesktop = "true".equalsIgnoreCase(config.getProperty("desktop.supported"));
        if (this.supportsDesktop) {
            this.portalStylesheet = config.getProperty("stylesheet.portal", "css/portal.css");
            this.desktopStylesheet = config.getProperty("stylesheet.desktop", "css/desktop.css");
        } else {
            this.portalStylesheet = null;
            this.desktopStylesheet = null;
        }
        if (log.isDebugEnabled()) {
            log.debug("BaseDecoration basePath: " + basePath.toString());
            log.debug("BaseDecoration baseClientPath: " + baseClientPath.toString());
        }
    }

    public void init(Properties config, ResourceValidator validator, PathResolverCache cache) {
        this.config = config;
        this.validator = validator;
        this.cache = cache;
    }

    public String getName() {
        return this.name;
    }

    public String getBasePath() {
        return this.basePath.toString();
    }

    public String getBasePath(String relativePath) {
        if (relativePath == null) {
            return this.basePath.toString();
        }
        return this.basePath.addSegment(relativePath).toString();
    }

    public String getResource(String path) {
        Path workingPath = this.baseClientPath.getChild(path);
        String hit = this.cache.getPath(workingPath.toString());
        if (hit != null) {
            return hit;
        }
        String locatedPath = this.getResource(this.baseClientPath, new Path(path));
        if (!locatedPath.startsWith(NO_SUCH_RESOURCE)) {
            if (!path.startsWith("/")) {
                locatedPath = locatedPath.substring(1);
            }
            this.cache.addPath(workingPath.toString(), locatedPath);
            return locatedPath;
        }
        return null;
    }

    protected String getResource(Path rootPath, Path searchPath) {
        String pathString = rootPath.getChild(searchPath).toString();
        if (this.validator.resourceExists(pathString)) {
            return pathString;
        }
        if (rootPath.length() > 0) {
            return this.getResource(rootPath.removeLastPathSegment(), searchPath);
        }
        return NO_SUCH_RESOURCE + searchPath.getFileExtension();
    }

    public String getStyleSheet() {
        if (this.commonStylesheet != null) {
            return this.getResource(this.commonStylesheet);
        }
        return null;
    }

    public String getStyleSheetPortal() {
        if (this.portalStylesheet != null) {
            return this.getResource(this.portalStylesheet);
        }
        return null;
    }

    public String getStyleSheetDesktop() {
        if (this.desktopStylesheet != null) {
            return this.getResource(this.desktopStylesheet);
        }
        return null;
    }

    public List getActions() {
        if (this.actions != null) {
            return this.actions;
        }
        return Collections.EMPTY_LIST;
    }

    public void setActions(List actions) {
        this.actions = actions;
    }

    public String getProperty(String name) {
        return this.config.getProperty(name);
    }

    public String getBaseCSSClass() {
        return this.config.getProperty("base.css.class", this.getName());
    }

    public String getCurrentModeAction() {
        return this.currentModeAction;
    }

    public void setCurrentModeAction(String currentModeAction) {
        this.currentModeAction = currentModeAction;
    }

    public String getCurrentStateAction() {
        return this.currentStateAction;
    }

    public void setCurrentStateAction(String currentStateAction) {
        this.currentStateAction = currentStateAction;
    }

    public String getResourceBundleName() {
        return this.config.getProperty("resource.file");
    }

    public ResourceBundle getResourceBundle(Locale locale, RequestContext context) {
        String resourceDirName = context.getConfig().getServletContext().getRealPath(this.getResource("resources"));
        File resourceDir = new File(resourceDirName);
        String resourceName = this.getResourceBundleName();
        if (resourceName == null) {
            throw new NullPointerException("Decoration cannot get ResourceBundle due to null value for decoration property resource.file.");
        }
        if (!resourceDir.isDirectory()) {
            throw new MissingResourceException("Can't find the resource directory: " + resourceDirName, resourceName + "_" + locale, "");
        }
        URL[] urls = new URL[1];
        try {
            urls[0] = resourceDir.toURL();
        }
        catch (MalformedURLException e) {
            throw new MissingResourceException("The resource directory cannot be parsed as a URL: " + resourceDirName, resourceName + "_" + locale, "");
        }
        return ResourceBundle.getBundle(resourceName, locale, new URLClassLoader(urls));
    }

    public boolean supportsDesktop() {
        return this.supportsDesktop;
    }

    public Decoration.ActionsOption getActionsOption() {
        return this.actionsOption;
    }

    public Decoration.TitleOption getTitleOption() {
        return this.titleOption;
    }

    public String getDragHandle() {
        return this.getDragHandle();
    }
}

