/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.decoration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.container.PortletWindow;
import org.apache.jetspeed.decoration.AbstractDecoratorActionsFactory;
import org.apache.jetspeed.decoration.Decoration;
import org.apache.jetspeed.decoration.DecoratorAction;
import org.apache.jetspeed.decoration.DecoratorActionTemplate;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.SecurityAccessController;

public class CustomDecoratorActionsFactory
extends AbstractDecoratorActionsFactory {
    private static final DecoratorActionTemplate CONFIG_MODE_TEMPLATE = new DecoratorActionTemplate(JetspeedActions.CONFIG_MODE);
    private static final DecoratorActionTemplate EDIT_DEFAULTS_MODE_TEMPLATE = new DecoratorActionTemplate(JetspeedActions.EDIT_DEFAULTS_MODE);
    private static final DecoratorActionTemplate PRINT_MODE_TEMPLATE = new DecoratorActionTemplate(JetspeedActions.PRINT_MODE);
    private static final DecoratorActionTemplate SOLO_ACTION_TEMPLATE = new DecoratorActionTemplate(JetspeedActions.SOLO_STATE);
    private final List supportedActions;
    private final List supportedSoloActions;

    public CustomDecoratorActionsFactory() {
        ArrayList<Object> list = new ArrayList<Object>(JetspeedActions.getStandardPortletModes());
        list.add(JetspeedActions.ABOUT_MODE);
        list.add(JetspeedActions.CONFIG_MODE);
        list.add(JetspeedActions.EDIT_DEFAULTS_MODE);
        list.add(JetspeedActions.PRINT_MODE);
        list.addAll(JetspeedActions.getStandardWindowStates());
        list.add(JetspeedActions.SOLO_STATE);
        this.supportedActions = Collections.unmodifiableList(list);
        list = new ArrayList(JetspeedActions.getStandardPortletModes());
        list.add(JetspeedActions.PRINT_MODE);
        this.supportedSoloActions = Collections.unmodifiableList(list);
    }

    public List getSupportedActions(RequestContext rc, PortletApplication pa, PortletWindow pw, PortletMode cm, WindowState ws, Decoration decoration) {
        return JetspeedActions.SOLO_STATE.equals((Object)ws) ? this.supportedSoloActions : this.supportedActions;
    }

    public List getDecoratorActions(RequestContext rc, PortletApplication pa, PortletWindow pw, PortletMode pm, WindowState ws, Decoration decoration, List actionTemplates, PortletDefinition portlet, ContentFragment fragment, SecurityAccessController accessController) {
        int editDefaultsModeIndex;
        int printModeIndex = actionTemplates.indexOf(PRINT_MODE_TEMPLATE);
        int soloStateIndex = actionTemplates.indexOf(SOLO_ACTION_TEMPLATE);
        if (printModeIndex != -1 && soloStateIndex != -1) {
            DecoratorActionTemplate soloStateTemplate = (DecoratorActionTemplate)actionTemplates.remove(soloStateIndex);
            DecoratorActionTemplate printActionTemplate = (DecoratorActionTemplate)actionTemplates.get(printModeIndex);
            printActionTemplate.setState(soloStateTemplate.getState());
            printActionTemplate.setCustomState(soloStateTemplate.getCustomState());
        } else if (soloStateIndex != -1) {
            actionTemplates.remove(soloStateIndex);
        }
        int configModeIndex = actionTemplates.indexOf(CONFIG_MODE_TEMPLATE);
        if (configModeIndex != -1) {
            try {
                ContentPage page = rc.getPage();
                page.checkAccess(JetspeedActions.CONFIG);
            }
            catch (SecurityException e) {
                actionTemplates.remove(configModeIndex);
            }
        }
        if ((editDefaultsModeIndex = actionTemplates.indexOf(EDIT_DEFAULTS_MODE_TEMPLATE)) != -1) {
            try {
                ContentPage page = rc.getPage();
                page.checkAccess(JetspeedActions.EDIT_DEFAULTS);
            }
            catch (SecurityException e) {
                actionTemplates.remove(editDefaultsModeIndex);
            }
        }
        return super.getDecoratorActions(rc, pa, pw, pm, ws, decoration, actionTemplates, portlet, fragment, accessController);
    }

    protected DecoratorAction createAction(RequestContext rc, PortletWindow pw, Decoration decoration, DecoratorActionTemplate template) {
        DecoratorAction action = super.createAction(rc, pw, decoration, template);
        if (template.getState() != null && JetspeedActions.SOLO_STATE.equals((Object)template.getState())) {
            action.setTarget("_blank");
        }
        return action;
    }
}

