/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.decoration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.cache.CacheElement;
import org.apache.jetspeed.cache.ContentCacheKey;
import org.apache.jetspeed.cache.JetspeedContentCache;
import org.apache.jetspeed.container.PortletWindow;
import org.apache.jetspeed.container.url.PortalURL;
import org.apache.jetspeed.decoration.BaseDecoration;
import org.apache.jetspeed.decoration.Decoration;
import org.apache.jetspeed.decoration.DecorationFactory;
import org.apache.jetspeed.decoration.DecorationFactoryImpl;
import org.apache.jetspeed.decoration.DecoratorAction;
import org.apache.jetspeed.decoration.DecoratorActionTemplate;
import org.apache.jetspeed.decoration.DecoratorActionsFactory;
import org.apache.jetspeed.decoration.DefaultDecoratorActionsFactory;
import org.apache.jetspeed.decoration.PageActionAccess;
import org.apache.jetspeed.decoration.PathResolverCache;
import org.apache.jetspeed.decoration.ResourceValidator;
import org.apache.jetspeed.decoration.Theme;
import org.apache.jetspeed.decoration.caches.SessionPathResolverCache;
import org.apache.jetspeed.factory.PortletFactory;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.om.portlet.Supports;
import org.apache.jetspeed.pipeline.PipelineException;
import org.apache.jetspeed.pipeline.valve.AbstractValve;
import org.apache.jetspeed.pipeline.valve.Valve;
import org.apache.jetspeed.pipeline.valve.ValveContext;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.SecurityAccessController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecorationValve
extends AbstractValve
implements Valve {
    public static final String ACTION_IMAGE_EXTENSION_ATTR = "actionImageExtension";
    public static final String IS_AJAX_DECORATION_REQUEST = "org.apache.jetspeed.decoration.ajax";
    protected static final Logger log = LoggerFactory.getLogger(DecorationValve.class);
    private final DecorationFactory decorationFactory;
    private Map<String, DecoratorActionsFactory> decoratorActionsAdapterCache = Collections.synchronizedMap(new HashMap());
    private DecoratorActionsFactory defaultDecoratorActionsFactory;
    private String defaultDecoratorActionsFactoryClassName;
    private JetspeedContentCache cache = null;
    private boolean useSessionForThemeCaching = false;
    private boolean maxOnEdit = false;
    private boolean maxOnConfig = false;
    private boolean maxOnEditDefaults = false;
    private boolean autoSwitchingForConfigMode = false;
    private boolean autoSwitchingToEditDefaultsModes = true;
    protected SecurityAccessController accessController;
    private PortletFactory portletFactory;

    public DecorationValve(DecorationFactory decorationFactory, SecurityAccessController accessController) {
        this(decorationFactory, accessController, null);
    }

    public DecorationValve(DecorationFactory decorationFactory, SecurityAccessController accessController, JetspeedContentCache cache) {
        this(decorationFactory, accessController, cache, false);
    }

    public DecorationValve(DecorationFactory decorationFactory, SecurityAccessController accessController, JetspeedContentCache cache, boolean useSessionForThemeCaching) {
        this(decorationFactory, accessController, cache, useSessionForThemeCaching, null);
    }

    public DecorationValve(DecorationFactory decorationFactory, SecurityAccessController accessController, JetspeedContentCache cache, boolean useSessionForThemeCaching, PortletFactory portletFactory) {
        this(decorationFactory, accessController, cache, useSessionForThemeCaching, null, new DefaultDecoratorActionsFactory());
    }

    public DecorationValve(DecorationFactory decorationFactory, SecurityAccessController accessController, JetspeedContentCache cache, boolean useSessionForThemeCaching, PortletFactory portletFactory, DecoratorActionsFactory defaultDecoratorActionsFactory) {
        this.decorationFactory = decorationFactory;
        this.defaultDecoratorActionsFactory = defaultDecoratorActionsFactory;
        this.defaultDecoratorActionsFactoryClassName = defaultDecoratorActionsFactory.getClass().getName();
        this.accessController = accessController;
        this.cache = cache;
        this.useSessionForThemeCaching = useSessionForThemeCaching;
        this.portletFactory = portletFactory;
    }

    @Override
    public void invoke(RequestContext requestContext, ValveContext context) throws PipelineException {
        boolean isAjaxRequest = context == null;
        this.initFragments(requestContext, isAjaxRequest, null);
        if (!isAjaxRequest) {
            context.invokeNext(requestContext);
        }
    }

    public void initFragments(RequestContext requestContext, boolean isAjaxRequest, List fragments) {
        CacheElement themeCacheElem;
        if (isAjaxRequest) {
            requestContext.setAttribute(IS_AJAX_DECORATION_REQUEST, (Object)new Boolean(true));
        }
        ContentPage page = requestContext.getPage();
        if (requestContext.getSessionAttribute("org.apache.jetspeed.theme.override") != null) {
            String decoratorName = (String)requestContext.getSessionAttribute("org.apache.jetspeed.theme.override");
            page.overrideDefaultDecorator(decoratorName, "layout");
        }
        PageActionAccess pageActionAccess = (PageActionAccess)requestContext.getAttribute("org.apache.jetspeed.decoration.PageEditAccess");
        String themeCacheKey = null;
        ContentCacheKey themeContentCacheKey = null;
        Theme theme = null;
        if (this.useCache() && !pageActionAccess.isEditing()) {
            if (this.useSessionForThemeCaching) {
                themeCacheKey = this.cache.createSessionKey(requestContext);
                theme = (Theme)requestContext.getSessionAttribute(themeCacheKey);
            } else {
                themeContentCacheKey = this.cache.createCacheKey(requestContext, page.getId());
                themeCacheElem = this.cache.get((Object)themeContentCacheKey);
                if (themeCacheElem != null) {
                    theme = (Theme)themeCacheElem.getContent();
                }
            }
        }
        if (theme != null) {
            theme.init(page, this.decorationFactory, requestContext);
            requestContext.setAttribute("org.apache.jetspeed.theme", (Object)theme);
            boolean solo = this.isSoloMode(requestContext);
            SessionPathResolverCache sessionPathResolver = new SessionPathResolverCache(requestContext.getRequest().getSession());
            this.initDepthFragmentDecorations(requestContext, theme, page.getRootFragment(), pageActionAccess, isAjaxRequest, ((DecorationFactoryImpl)this.decorationFactory).getResourceValidator(), sessionPathResolver, theme.isInvalidated() && !solo);
            if (theme.isInvalidated() && !solo) {
                if (this.useSessionForThemeCaching) {
                    requestContext.setSessionAttribute(themeCacheKey, (Object)theme);
                } else {
                    CacheElement themeCacheElem2 = this.cache.createElement((Object)themeContentCacheKey, (Object)theme);
                    this.cache.put(themeCacheElem2);
                }
                theme.setInvalidated(false);
            }
            return;
        }
        theme = this.decorationFactory.getTheme(page, requestContext);
        requestContext.setAttribute("org.apache.jetspeed.theme", (Object)theme);
        if (fragments == null || fragments.size() == 0) {
            ContentFragment rootFragment = page.getRootFragment();
            this.initDepthFragments(requestContext, theme, rootFragment, pageActionAccess, isAjaxRequest, fragments);
        } else {
            for (ContentFragment fragment : fragments) {
                this.initFragment(requestContext, theme, fragment, pageActionAccess, isAjaxRequest);
            }
        }
        if (this.useCache() && !this.isSoloMode(requestContext)) {
            if (themeContentCacheKey == null && themeCacheKey == null) {
                if (this.useSessionForThemeCaching) {
                    themeCacheKey = this.cache.createSessionKey(requestContext);
                    requestContext.getRequest().getSession().removeAttribute(themeCacheKey);
                } else {
                    themeContentCacheKey = this.cache.createCacheKey(requestContext, page.getId());
                    this.cache.remove((Object)themeContentCacheKey);
                }
            } else if (this.useSessionForThemeCaching) {
                themeContentCacheKey = this.cache.createCacheKey(requestContext, page.getId());
                requestContext.setSessionAttribute(themeCacheKey, (Object)theme);
            } else {
                themeCacheElem = this.cache.createElement((Object)themeContentCacheKey, (Object)theme);
                this.cache.put(themeCacheElem);
            }
        }
    }

    protected boolean isSoloMode(RequestContext requestContext) {
        boolean maximized;
        boolean solo = false;
        PortletWindow window = requestContext.getPortalURL().getNavigationalState().getMaximizedWindow();
        boolean bl = maximized = window != null;
        if (maximized) {
            solo = JetspeedActions.SOLO_STATE.equals((Object)requestContext.getPortalURL().getNavigationalState().getMappedState(window));
        }
        return solo;
    }

    protected boolean useCache() {
        return this.cache != null;
    }

    public String toString() {
        return "DecorationValve";
    }

    public DecoratorActionsFactory getDecoratorActionsAdapter(Decoration decoration) {
        String decoratorActionsAdapterClassName = decoration.getProperty("actions.factory");
        if (decoratorActionsAdapterClassName == null || "".equals(decoratorActionsAdapterClassName) || decoratorActionsAdapterClassName.equals(this.defaultDecoratorActionsFactoryClassName)) {
            return this.defaultDecoratorActionsFactory;
        }
        DecoratorActionsFactory adapter = this.decoratorActionsAdapterCache.get(decoratorActionsAdapterClassName);
        if (adapter == null) {
            try {
                adapter = (DecoratorActionsFactory)Class.forName(decoratorActionsAdapterClassName).newInstance();
                adapter.setMaximizeOnEdit(this.maxOnEdit);
                adapter.setMaximizeOnConfig(this.maxOnConfig);
                adapter.setMaximizeOnEditDefaults(this.maxOnEditDefaults);
                this.decoratorActionsAdapterCache.put(decoratorActionsAdapterClassName, adapter);
            }
            catch (Exception e) {
                adapter = this.defaultDecoratorActionsFactory;
                log.error("Failed to instantiate custom DecoratorActionsAdaptor " + decoratorActionsAdapterClassName + ", falling back to default.", (Throwable)e);
            }
        }
        return adapter;
    }

    protected boolean initActionsForFragment(RequestContext requestContext, ContentFragment fragment, PageActionAccess pageActionAccess, Decoration decoration, boolean isAjaxRequest) {
        boolean fragmentSupportsActions = false;
        PortletWindow window = requestContext.getPortletWindow(fragment);
        if (!window.isValid()) {
            return fragmentSupportsActions;
        }
        PortletDefinition portlet = window.getPortletDefinition();
        List actions = Collections.EMPTY_LIST;
        PortletMode currentMode = requestContext.getPortalURL().getNavigationalState().getMode(window);
        WindowState currentState = requestContext.getPortalURL().getNavigationalState().getState(window);
        List supports = portlet.getSupports();
        if (fragment.equals(requestContext.getPage().getRootFragment())) {
            fragmentSupportsActions = true;
            actions = this.getPageModes(requestContext, window, supports, currentMode, currentState, pageActionAccess, decoration, isAjaxRequest);
        } else if (!"layout".equals(fragment.getType())) {
            fragmentSupportsActions = true;
            String fragmentId = fragment.getId();
            PortletApplication pa = window.getPortletDefinition().getApplication();
            String portletName = portlet.getUniqueName();
            PortletMode currentMappedMode = pa.getMappedPortletMode(currentMode);
            WindowState currentMappedState = pa.getMappedWindowState(currentState);
            ArrayList<DecoratorActionTemplate> actionTemplates = new ArrayList<DecoratorActionTemplate>();
            DecoratorActionsFactory actionsAdapter = this.getDecoratorActionsAdapter(decoration);
            List supportedActions = actionsAdapter.getSupportedActions(requestContext, pa, window, currentMappedMode, currentMappedState, decoration);
            Iterator iter = supportedActions.iterator();
            String currentModeAction = null;
            String currentStateAction = null;
            while (iter.hasNext()) {
                WindowState mappedState;
                WindowState customState;
                Object action = iter.next();
                if (action instanceof PortletMode) {
                    PortletMode mappedMode = (PortletMode)action;
                    PortletMode customMode = pa.getCustomPortletMode(mappedMode);
                    if (customMode == null) continue;
                    boolean equalsCurrentMode = customMode.equals((Object)currentMode);
                    if (equalsCurrentMode) {
                        currentModeAction = mappedMode.toString();
                    }
                    if (equalsCurrentMode && !isAjaxRequest || !this.supportsPortletMode(supports, customMode) && !this.isAutoSwitchableCustomMode(window, customMode) || PortletMode.EDIT.equals((Object)customMode) && !pageActionAccess.isEditAllowed() || !pageActionAccess.checkPortletMode(fragmentId, portletName, mappedMode)) continue;
                    actionTemplates.add(new DecoratorActionTemplate(mappedMode, customMode));
                    continue;
                }
                if (!(action instanceof WindowState) || (customState = pa.getCustomWindowState(mappedState = (WindowState)action)) == null) continue;
                boolean equalsCurrentState = customState.equals((Object)currentState);
                if (equalsCurrentState) {
                    currentStateAction = mappedState.toString();
                }
                if (equalsCurrentState && !isAjaxRequest || !pageActionAccess.checkWindowState(fragmentId, portletName, mappedState)) continue;
                actionTemplates.add(new DecoratorActionTemplate(mappedState, customState));
            }
            actions = actionsAdapter.getDecoratorActions(requestContext, pa, window, currentMode, currentState, decoration, actionTemplates, portlet, fragment, this.accessController);
            decoration.setCurrentModeAction(currentModeAction);
            decoration.setCurrentStateAction(currentStateAction);
        }
        decoration.setActions(actions);
        return fragmentSupportsActions;
    }

    protected boolean supportsPortletMode(List<Supports> supports, PortletMode mode) {
        if (mode.equals((Object)PortletMode.VIEW)) {
            return true;
        }
        String pm = mode.toString();
        for (Supports s : supports) {
            if (!s.getPortletModes().contains(pm)) continue;
            return true;
        }
        return false;
    }

    protected List getPageModes(RequestContext requestContext, PortletWindow window, List<Supports> supports, PortletMode mode, WindowState state, PageActionAccess pageActionAccess, Decoration decoration, boolean isAjaxRequest) {
        ArrayList<DecoratorAction> pageModes = new ArrayList<DecoratorAction>();
        try {
            if (mode.equals((Object)PortletMode.HELP) || !state.equals((Object)WindowState.NORMAL)) {
                PortalURL portalURL = requestContext.getPortalURL();
                String action = requestContext.getResponse().encodeURL(isAjaxRequest ? portalURL.createNavigationalEncoding(window, PortletMode.VIEW, WindowState.NORMAL) : portalURL.createPortletURL(window, PortletMode.VIEW, WindowState.NORMAL, portalURL.isSecure()).toString());
                String actionName = PortletMode.VIEW.toString();
                pageModes.add(new DecoratorAction(actionName, requestContext.getLocale(), decoration.getResource("images/" + actionName + ".gif"), action, "mode"));
            } else if (pageActionAccess.isEditAllowed()) {
                String targetMode = pageActionAccess.isEditing() ? PortletMode.VIEW.toString() : PortletMode.EDIT.toString();
                PortalURL portalURL = requestContext.getPortalURL();
                HashMap<String, String[]> parameters = new HashMap<String, String[]>();
                String[] paramValues = new String[]{targetMode};
                parameters.put("pageMode", paramValues);
                String action = requestContext.getResponse().encodeURL(isAjaxRequest ? portalURL.createNavigationalEncoding(window, parameters, PortletMode.VIEW, WindowState.NORMAL, true) : portalURL.createPortletURL(window, parameters, PortletMode.VIEW, WindowState.NORMAL, true, portalURL.isSecure()).toString());
                pageModes.add(new DecoratorAction(targetMode, requestContext.getLocale(), decoration.getResource("images/" + targetMode + ".gif"), action, "mode"));
                if (this.supportsPortletMode(supports, PortletMode.HELP)) {
                    if (pageActionAccess.isEditing()) {
                        paramValues[0] = PortletMode.VIEW.toString();
                        action = requestContext.getResponse().encodeURL(isAjaxRequest ? portalURL.createNavigationalEncoding(window, parameters, PortletMode.HELP, WindowState.MAXIMIZED, true) : portalURL.createPortletURL(window, parameters, PortletMode.HELP, WindowState.MAXIMIZED, true, portalURL.isSecure()).toString());
                    } else {
                        action = requestContext.getResponse().encodeURL(isAjaxRequest ? portalURL.createNavigationalEncoding(window, PortletMode.HELP, WindowState.MAXIMIZED) : portalURL.createPortletURL(window, PortletMode.HELP, WindowState.MAXIMIZED, portalURL.isSecure()).toString());
                    }
                    String actionName = PortletMode.HELP.toString();
                    pageModes.add(new DecoratorAction(actionName, requestContext.getLocale(), decoration.getResource("images/" + actionName + ".gif"), action, "mode"));
                }
            }
        }
        catch (Exception e) {
            log.warn("Unable to initalize PageLayout actions", (Throwable)e);
            pageModes = null;
        }
        return pageModes;
    }

    protected void initDepthFragments(RequestContext requestContext, Theme theme, ContentFragment fragment, PageActionAccess pageActionAccess, boolean isAjaxRequest, List collectFragments) {
        List contentFragments = fragment.getFragments();
        if (contentFragments != null && contentFragments.size() > 0) {
            for (ContentFragment aFragment : contentFragments) {
                this.initDepthFragments(requestContext, theme, aFragment, pageActionAccess, isAjaxRequest, collectFragments);
            }
        }
        if (this.initFragment(requestContext, theme, fragment, pageActionAccess, isAjaxRequest) && collectFragments != null) {
            collectFragments.add(fragment);
        }
    }

    protected boolean initFragment(RequestContext requestContext, Theme theme, ContentFragment fragment, PageActionAccess pageActionAccess, boolean isAjaxRequest) {
        boolean fragmentSupportsActions = false;
        try {
            Decoration decoration = theme.getDecoration(fragment);
            fragment.setDecoration(decoration);
            fragmentSupportsActions = this.initActionsForFragment(requestContext, fragment, pageActionAccess, decoration, isAjaxRequest);
        }
        catch (Exception e) {
            log.warn("Unable to initalize actions for fragment " + fragment.getId(), (Throwable)e);
        }
        return fragmentSupportsActions;
    }

    protected void initDepthFragmentDecorations(RequestContext requestContext, Theme theme, ContentFragment fragment, PageActionAccess pageActionAccess, boolean isAjaxRequest, ResourceValidator validator, PathResolverCache pathResolverCache, boolean reloadActionList) {
        List contentFragments = fragment.getFragments();
        if (contentFragments != null && contentFragments.size() > 0) {
            for (ContentFragment aFragment : contentFragments) {
                this.initDepthFragmentDecorations(requestContext, theme, aFragment, pageActionAccess, isAjaxRequest, validator, pathResolverCache, reloadActionList);
            }
        }
        try {
            Decoration decoration = theme.getDecoration(fragment);
            Properties config = ((DecorationFactoryImpl)this.decorationFactory).getConfiguration(decoration.getName(), fragment.getType());
            ((BaseDecoration)decoration).init(config, validator, pathResolverCache);
            fragment.setDecoration(decoration);
            if (reloadActionList) {
                this.initActionsForFragment(requestContext, fragment, pageActionAccess, decoration, isAjaxRequest);
            }
        }
        catch (Exception e) {
            log.warn("Unable to initalize actions for fragment " + fragment.getId(), (Throwable)e);
        }
    }

    public void setMaximizeOnEdit(boolean maxOnEdit) {
        this.maxOnEdit = maxOnEdit;
        this.defaultDecoratorActionsFactory.setMaximizeOnEdit(maxOnEdit);
    }

    public boolean getMaximizeOnEdit() {
        return this.maxOnEdit;
    }

    public void setMaximizeOnConfig(boolean maxOnConfig) {
        this.maxOnConfig = maxOnConfig;
        this.defaultDecoratorActionsFactory.setMaximizeOnConfig(maxOnConfig);
    }

    public boolean getMaximizeOnConfig() {
        return this.maxOnConfig;
    }

    public void setMaximizeOnEditDefaults(boolean maxOnEditDefaults) {
        this.maxOnEditDefaults = maxOnEditDefaults;
        this.defaultDecoratorActionsFactory.setMaximizeOnEditDefaults(maxOnEditDefaults);
    }

    public boolean getMaximizeOnEditDefaults() {
        return this.maxOnEditDefaults;
    }

    public void setAutoSwitchingToEditDefaultsModes(boolean autoSwitchingToEditDefaultsModes) {
        this.autoSwitchingToEditDefaultsModes = autoSwitchingToEditDefaultsModes;
    }

    public boolean getAutoSwitchingToEditDefaultsModes() {
        return this.autoSwitchingToEditDefaultsModes;
    }

    public void setAutoSwitchingForConfigMode(boolean autoSwitchingForConfigMode) {
        this.autoSwitchingForConfigMode = autoSwitchingForConfigMode;
    }

    public boolean getAutoSwitchingForConfigMode() {
        return this.autoSwitchingForConfigMode;
    }

    private boolean isAutoSwitchableCustomMode(PortletWindow window, PortletMode customMode) {
        if (this.autoSwitchingForConfigMode && JetspeedActions.CONFIG_MODE.equals((Object)customMode)) {
            return true;
        }
        return this.autoSwitchingToEditDefaultsModes && JetspeedActions.EDIT_DEFAULTS_MODE.equals((Object)customMode) && this.portletFactory != null && this.portletFactory.hasRenderHelperMethod(window.getPortletDefinition(), PortletMode.EDIT);
    }
}

