/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.decoration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jetspeed.decoration.Decoration;
import org.apache.jetspeed.decoration.DecorationFactory;
import org.apache.jetspeed.decoration.LayoutDecoration;
import org.apache.jetspeed.decoration.PortletDecoration;
import org.apache.jetspeed.decoration.Theme;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.request.RequestContext;

public class PageTheme
implements Theme,
Serializable {
    private transient ContentPage page;
    private transient DecorationFactory decorationFactory;
    private transient RequestContext requestContext;
    private final Set styleSheets;
    private final LayoutDecoration layoutDecoration;
    private final Map fragmentDecorations;
    private final Collection portletDecorationNames;
    private boolean invalidated = false;

    public PageTheme(ContentPage page, DecorationFactory decorationFactory, RequestContext requestContext) {
        String defaultDesktopPortletDecoration;
        this.page = page;
        this.decorationFactory = decorationFactory;
        this.requestContext = requestContext;
        this.styleSheets = new LinkedHashSet();
        this.fragmentDecorations = new HashMap();
        boolean isDesktopEnabled = decorationFactory.isDesktopEnabled(requestContext);
        HashMap<String, String> portletDecorationNames = new HashMap<String, String>();
        this.layoutDecoration = (LayoutDecoration)this.setupFragmentDecorations(page.getRootFragment(), true, portletDecorationNames, isDesktopEnabled);
        if (isDesktopEnabled && (defaultDesktopPortletDecoration = decorationFactory.getDefaultDesktopPortletDecoration()) != null && defaultDesktopPortletDecoration.length() > 0 && portletDecorationNames.get(defaultDesktopPortletDecoration) == null) {
            portletDecorationNames.put(defaultDesktopPortletDecoration, defaultDesktopPortletDecoration);
        }
        if (!portletDecorationNames.containsKey(this.layoutDecoration.getName())) {
            portletDecorationNames.put(this.layoutDecoration.getName(), this.layoutDecoration.getName());
            PortletDecoration decoration = decorationFactory.getPortletDecoration(this.layoutDecoration.getName(), requestContext);
            if (decoration.getStyleSheet() != null) {
                this.styleSheets.add(decoration.getStyleSheet());
            }
            if (decoration.getStyleSheetPortal() != null) {
                this.styleSheets.add(decoration.getStyleSheetPortal());
            }
        }
        this.portletDecorationNames = Collections.unmodifiableCollection(new ArrayList(portletDecorationNames.keySet()));
    }

    private Decoration setupFragmentDecorations(ContentFragment fragment, boolean isRootLayout, HashMap portletDecorationNames, boolean isDesktopEnabled) {
        List fragments;
        boolean isPortlet;
        Decoration decoration = this.decorationFactory.getDecoration(this.page, fragment, this.requestContext);
        this.fragmentDecorations.put(fragment.getId(), decoration);
        boolean bl = isPortlet = !isRootLayout && fragment.getType().equals("portlet");
        if (isPortlet || isRootLayout) {
            String commonStyleSheet = decoration.getStyleSheet();
            if (commonStyleSheet != null) {
                this.styleSheets.add(commonStyleSheet);
            }
            if (isDesktopEnabled) {
                String desktopStyleSheet = decoration.getStyleSheetDesktop();
                if (desktopStyleSheet != null) {
                    this.styleSheets.add(desktopStyleSheet);
                }
            } else {
                String portalStyleSheet = decoration.getStyleSheetPortal();
                if (portalStyleSheet != null) {
                    this.styleSheets.add(portalStyleSheet);
                }
            }
            if (isPortlet) {
                portletDecorationNames.put(decoration.getName(), decoration.getName());
            }
        }
        if ((fragments = fragment.getFragments()) != null && !fragments.isEmpty()) {
            Iterator fragmentsIter = fragments.iterator();
            while (fragmentsIter.hasNext()) {
                this.setupFragmentDecorations((ContentFragment)fragmentsIter.next(), false, portletDecorationNames, isDesktopEnabled);
            }
        }
        return decoration;
    }

    public Set getStyleSheets() {
        return this.styleSheets;
    }

    public Decoration getDecoration(ContentFragment fragment) {
        return (Decoration)this.fragmentDecorations.get(fragment.getId());
    }

    public Collection getPortletDecorationNames() {
        return this.portletDecorationNames;
    }

    public LayoutDecoration getPageLayoutDecoration() {
        return this.layoutDecoration;
    }

    public void init(ContentPage page, DecorationFactory decoration, RequestContext context) {
        this.page = page;
        this.decorationFactory = decoration;
        this.requestContext = context;
    }

    public ContentPage getPage() {
        return this.page;
    }

    public ContentPage getContentPage() {
        return this.page;
    }

    public boolean isInvalidated() {
        return this.invalidated;
    }

    public void setInvalidated(boolean flag) {
        this.invalidated = flag;
    }
}

