/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.deployment.impl;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.deployment.DeploymentEvent;
import org.apache.jetspeed.deployment.DeploymentEventListener;
import org.apache.jetspeed.deployment.DeploymentException;
import org.apache.jetspeed.deployment.impl.JarExpander;
import org.apache.jetspeed.tools.deploy.JetspeedDeploy;
import org.apache.jetspeed.tools.pamanager.PortletApplicationManagement;
import org.apache.jetspeed.util.DirectoryHelper;
import org.apache.jetspeed.util.FileSystemHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployPortletAppEventListener
implements DeploymentEventListener {
    protected static final Logger log = LoggerFactory.getLogger((String)"deployment");
    private String webAppDir;
    private int localPAPrefixLength;
    private String localAppDir;
    private String localAppStagingDir;
    private boolean stripLoggers;
    private PortletApplicationManagement pam;

    public DeployPortletAppEventListener(PortletApplicationManagement pam, PortletRegistry registry, String webAppDir, String localAppDir, boolean stripLoggers) throws FileNotFoundException {
        this(pam, registry, webAppDir, localAppDir, null, stripLoggers);
    }

    public DeployPortletAppEventListener(PortletApplicationManagement pam, PortletRegistry registry, String webAppDir, String localAppDir, String localAppStagingDir, boolean stripLoggers) throws FileNotFoundException {
        this.pam = pam;
        this.stripLoggers = stripLoggers;
        this.localPAPrefixLength = "jetspeed-".length();
        File webAppDirFile = new File(webAppDir);
        if (webAppDirFile.exists()) {
            try {
                this.webAppDir = webAppDirFile.getCanonicalPath();
            }
            catch (IOException e) {}
        } else {
            throw new FileNotFoundException("The depoyment directory for portlet applications \"" + webAppDirFile.getAbsolutePath() + "\" does not exist.");
        }
        File localAppDirFile = new File(localAppDir);
        if (!localAppDirFile.exists()) {
            localAppDirFile.mkdirs();
        } else if (!localAppDirFile.isDirectory()) {
            throw new FileNotFoundException("Invalid depoyment directory for local portlet applications: \"" + localAppDirFile.getAbsolutePath());
        }
        try {
            this.localAppDir = localAppDirFile.getCanonicalPath();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (localAppStagingDir != null) {
            File localAppStagingDirFile = new File(localAppStagingDir);
            if (!localAppStagingDirFile.exists()) {
                localAppStagingDirFile.mkdirs();
            } else if (!localAppStagingDirFile.isDirectory()) {
                throw new FileNotFoundException("Invalid staging directory for local portlet applications: \"" + localAppStagingDirFile.getAbsolutePath());
            }
            try {
                this.localAppStagingDir = localAppStagingDirFile.getCanonicalPath();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    protected String getWebAppDir() {
        return this.webAppDir;
    }

    public void initialize() {
        File[] localApps = new File(this.localAppDir).listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        for (int i = 0; i < localApps.length; ++i) {
            if (!new File(localApps[i], "WEB-INF/portlet.xml").exists()) {
                log.warn("Not a local application " + localApps[i].getName());
                continue;
            }
            DirectoryHelper paDirHelper = new DirectoryHelper(localApps[i]);
            try {
                this.pam.startLocalPortletApplication(localApps[i].getName(), (FileSystemHelper)paDirHelper, this.createLocalPAClassLoader(localApps[i]));
                continue;
            }
            catch (Exception e) {
                log.error("Failed to start Local Portlet Application " + localApps[i], (Throwable)e);
            }
        }
    }

    private String getEventParentPath(DeploymentEvent event) {
        try {
            return event.getDeploymentObject().getFile().getParentFile().getCanonicalPath();
        }
        catch (IOException io) {
            return null;
        }
    }

    public void invokeDeploy(DeploymentEvent event) throws DeploymentException {
        String fileName = event.getName();
        if (fileName.endsWith(".war")) {
            if (this.localAppStagingDir != null && this.getEventParentPath(event).equals(this.localAppStagingDir)) {
                this.deployLocalPortletApplication(event);
            } else {
                this.deployPortletApplication(event);
            }
        }
    }

    protected void deployPortletApplication(DeploymentEvent event) throws DeploymentException {
        try {
            String fileName = event.getName();
            File toFile = new File(this.webAppDir, fileName);
            String contextName = fileName.substring(0, fileName.length() - 4);
            new JetspeedDeploy(event.getPath(), toFile.getAbsolutePath(), contextName, this.stripLoggers);
            event.setStatus(1);
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    protected void deployLocalPortletApplication(DeploymentEvent event) throws DeploymentException {
        try {
            String fileName = event.getName();
            String appName = fileName.substring(0, fileName.length() - 4);
            this.pam.stopLocalPortletApplication(appName);
            File targetDir = new File(this.localAppDir, appName);
            JarExpander.expand(event.getDeploymentObject().getFile(), targetDir);
            DirectoryHelper paDirHelper = new DirectoryHelper(targetDir);
            this.pam.startLocalPortletApplication(appName, (FileSystemHelper)paDirHelper, this.createLocalPAClassLoader(targetDir));
            event.setStatus(1);
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    protected ClassLoader createLocalPAClassLoader(File paDir) throws IOException {
        File webInfLib;
        ArrayList<URL> urls = new ArrayList<URL>();
        File webInfClasses = null;
        webInfClasses = new File(paDir, "WEB-INF/classes/");
        if (webInfClasses.exists()) {
            log.info("Adding " + webInfClasses.toURL() + " to class path for Local PA " + paDir.getName());
            urls.add(webInfClasses.toURL());
        }
        if ((webInfLib = new File(paDir, "WEB-INF/lib")).exists()) {
            File[] jars = webInfLib.listFiles();
            for (int i = 0; i < jars.length; ++i) {
                File jar = jars[i];
                log.info("Adding " + jar.toURL() + " to class path for Local PA " + paDir.getName());
                urls.add(jar.toURL());
            }
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), this.getClass().getClassLoader());
    }
}

