/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.deployment.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.jetspeed.util.DirectoryHelper;

public class JarExpander {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void expand(File srcFile, File targetDir) throws IOException {
        if (targetDir.exists()) {
            DirectoryHelper cleanup = new DirectoryHelper(targetDir);
            cleanup.remove();
            cleanup.close();
        }
        targetDir.mkdirs();
        JarFile jarFile = new JarFile(srcFile);
        try {
            Enumeration<JarEntry> entries = jarFile.entries();
            InputStream is = null;
            OutputStream os = null;
            byte[] buf = new byte[1024];
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                String name = jarEntry.getName();
                File entryFile = new File(targetDir, name);
                if (jarEntry.isDirectory()) {
                    entryFile.mkdir();
                    continue;
                }
                if (!entryFile.getParentFile().exists()) {
                    entryFile.getParentFile().mkdirs();
                }
                entryFile.createNewFile();
                try {
                    int len;
                    is = jarFile.getInputStream(jarEntry);
                    os = new FileOutputStream(entryFile);
                    while ((len = is.read(buf)) > 0) {
                        os.write(buf, 0, len);
                    }
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                    if (os == null) continue;
                    os.close();
                }
            }
        }
        finally {
            if (jarFile != null) {
                jarFile.close();
            }
        }
    }
}

