/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.deployment.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.deployment.DeploymentEvent;
import org.apache.jetspeed.deployment.DeploymentException;
import org.apache.jetspeed.deployment.impl.DeployPortletAppEventListener;
import org.apache.jetspeed.tools.pamanager.PortletApplicationManagement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JettyDeployPortletAppEventListener
extends DeployPortletAppEventListener {
    private String jettyContextsDir;

    public JettyDeployPortletAppEventListener(PortletApplicationManagement pam, PortletRegistry registry, String webAppDir, String localAppDir, boolean stripLoggers, String jettyContextsDir) throws FileNotFoundException {
        super(pam, registry, webAppDir, localAppDir, stripLoggers);
        this.initJettyContextsDir(jettyContextsDir);
    }

    public JettyDeployPortletAppEventListener(PortletApplicationManagement pam, PortletRegistry registry, String webAppDir, String localAppDir, String localAppStagingDir, boolean stripLoggers, String jettyContextsDir) throws FileNotFoundException {
        super(pam, registry, webAppDir, localAppDir, localAppStagingDir, stripLoggers);
        this.initJettyContextsDir(jettyContextsDir);
    }

    private void initJettyContextsDir(String jettyContextsDir) throws FileNotFoundException {
        File jettyContextsDirFile = new File(jettyContextsDir);
        if (jettyContextsDirFile.exists()) {
            try {
                this.jettyContextsDir = jettyContextsDirFile.getCanonicalPath();
            }
            catch (IOException iOException) {}
        } else {
            throw new FileNotFoundException("The jetty contexts directory \"" + jettyContextsDirFile.getAbsolutePath() + "\" does not exist.");
        }
    }

    protected void deployPortletApplication(DeploymentEvent event) throws DeploymentException {
        try {
            String fileName = event.getName();
            String filePath = event.getPath();
            String appName = fileName.substring(0, fileName.length() - 4);
            Document context = this.getJettyContext(filePath);
            File contextFile = this.getCurrentJettyContextFile(appName);
            if (contextFile != null) {
                if (context == null) {
                    context = this.getCurrentJettyContext(contextFile);
                }
                contextFile.delete();
            }
            if (context == null) {
                context = this.getJettyContextTemplate();
            }
            this.updateJettyContext(appName, new File(this.getWebAppDir(), fileName).getAbsolutePath(), context);
            this.removeCurrentPA(appName);
            super.deployPortletApplication(event);
            this.writeJettyContext(appName, context);
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    protected void removeCurrentPA(String contextName) throws IOException {
        File warDir;
        File warFile = new File(this.getWebAppDir(), contextName + ".war");
        if (warFile.exists()) {
            warFile.delete();
        }
        if ((warDir = new File(this.getWebAppDir(), contextName)).exists() && warDir.isDirectory()) {
            this.removeDir(warDir);
        }
    }

    protected boolean removeDir(File file) {
        if (file.isDirectory()) {
            String[] children = file.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = this.removeDir(new File(file, children[i]));
                if (success) continue;
                return false;
            }
        }
        return file.delete();
    }

    protected File getCurrentJettyContextFile(String contextName) throws IOException {
        File contextFile = new File(this.jettyContextsDir, contextName + ".xml");
        if (contextFile.exists()) {
            if (contextFile.isDirectory()) {
                throw new IOException("Cannot deploy application" + contextName + " as there already exists a directory in " + this.jettyContextsDir + " with the same name");
            }
            return contextFile;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document getCurrentJettyContext(File contextFile) throws Exception {
        Document document;
        block5: {
            FileInputStream source = null;
            try {
                source = new FileInputStream(contextFile);
                document = this.parseJettyContext(source);
                Object var5_4 = null;
                if (source == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var5_5 = null;
                    if (source == null) break block6;
                    try {
                        ((InputStream)source).close();
                    }
                    catch (IOException e1) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)source).close();
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document getJettyContextTemplate() throws Exception {
        Document document;
        block5: {
            InputStream source = null;
            try {
                source = this.getClass().getResourceAsStream("jetty/context-template.xml");
                document = this.parseJettyContext(source);
                Object var4_3 = null;
                if (source == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var4_4 = null;
                    if (source == null) break block6;
                    try {
                        source.close();
                    }
                    catch (IOException e1) {}
                }
                throw throwable;
            }
            try {
                source.close();
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Document getJettyContext(String fileName) throws Exception {
        block17: {
            block15: {
                block13: {
                    block14: {
                        jin = null;
                        source = null;
                        try {
                            jin = new JarFile(fileName);
                            jarEntries = jin.entries();
                            while (jarEntries.hasMoreElements()) {
                                src = jarEntries.nextElement();
                                target = src.getName();
                                if (!"META-INF/jetspeed-jetty-context.xml".equals(target)) continue;
                                System.out.println("Found jetspeed-jetty-context.xml");
                                source = jin.getInputStream(src);
                                var7_7 = this.parseJettyContext(source);
                                var9_8 = null;
                                if (source == null) break block13;
                                break block14;
                            }
                            var6_6 = null;
                            break block15;
                        }
                        catch (Throwable var8_14) {
                            var9_10 = null;
                            if (source != null) {
                                try {
                                    source.close();
                                }
                                catch (IOException e1) {
                                    // empty catch block
                                }
                            }
                            if (jin == null) throw var8_14;
                            try {
                                jin.close();
                                jin = null;
                                throw var8_14;
                            }
                            catch (IOException e1) {
                                throw var8_14;
                            }
                        }
                    }
                    ** try [egrp 1[TRYBLOCK] [3 : 112->119)] { 
lbl39:
                    // 1 sources

                    source.close();
                    break block13;
lbl41:
                    // 1 sources

                    catch (IOException e1) {
                        // empty catch block
                    }
                }
                if (jin == null) return var7_7;
                ** try [egrp 2[TRYBLOCK] [4 : 125->134)] { 
lbl46:
                // 1 sources

                jin.close();
                return var7_7;
lbl48:
                // 1 sources

                catch (IOException e1) {
                    // empty catch block
                }
                return var7_7;
            }
            var9_9 = null;
            if (source != null) {
                ** try [egrp 1[TRYBLOCK] [3 : 112->119)] { 
lbl55:
                // 1 sources

                source.close();
                break block17;
lbl57:
                // 1 sources

                catch (IOException e1) {
                    // empty catch block
                }
            }
        }
        if (jin == null) return var6_6;
        ** try [egrp 2[TRYBLOCK] [4 : 125->134)] { 
lbl62:
        // 1 sources

        jin.close();
        return var6_6;
lbl64:
        // 1 sources

        catch (IOException e1) {
            // empty catch block
        }
        return var6_6;
    }

    protected void updateJettyContext(String contextName, String warPath, Document context) {
        Element root = context.getDocumentElement();
        NodeList sets = root.getElementsByTagName("Set");
        boolean foundSetWar = false;
        boolean foundSetContextPath = false;
        boolean foundSetConfigurationClasses = false;
        int size = sets.getLength();
        for (int i = 0; i < size; ++i) {
            Element set = (Element)sets.item(i);
            String name = set.getAttribute("name");
            if (name.equals("contextPath")) {
                set.setTextContent("/" + contextName);
                foundSetContextPath = true;
                continue;
            }
            if (name.equals("resourceBase")) {
                root.removeChild(set);
                continue;
            }
            if (name.equals("war")) {
                set.setTextContent(warPath);
                foundSetWar = true;
                continue;
            }
            if (!name.equals("configurationClasses")) continue;
            foundSetConfigurationClasses = true;
        }
        if (!foundSetContextPath) {
            Element set = context.createElement("Set");
            set.setAttribute("name", "contextPath");
            set.setTextContent("/" + contextName);
            root.appendChild(set);
        }
        if (!foundSetWar) {
            Element set = context.createElement("Set");
            set.setAttribute("name", "war");
            set.setTextContent(warPath);
            root.appendChild(set);
        }
        if (!foundSetConfigurationClasses) {
            Element set = context.createElement("Set");
            set.setAttribute("name", "configurationClasses");
            root.appendChild(set);
            Element array = context.createElement("Array");
            array.setAttribute("type", "java.lang.String");
            set.appendChild(array);
            Element item = context.createElement("Item");
            item.setTextContent("org.mortbay.jetty.webapp.WebInfConfiguration");
            array.appendChild(item);
            item = context.createElement("Item");
            item.setTextContent("org.mortbay.jetty.plus.webapp.EnvConfiguration");
            array.appendChild(item);
            item = context.createElement("Item");
            item.setTextContent("org.mortbay.jetty.plus.webapp.Configuration");
            array.appendChild(item);
            item = context.createElement("Item");
            item.setTextContent("org.mortbay.jetty.webapp.JettyWebXmlConfiguration");
            array.appendChild(item);
            item = context.createElement("Item");
            item.setTextContent("org.mortbay.jetty.webapp.TagLibConfiguration");
            array.appendChild(item);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeJettyContext(String contextName, Document context) throws IOException {
        File contextFile = new File(this.jettyContextsDir, contextName + ".xml");
        if (contextFile.exists()) {
            throw new IOException("Jetty context file " + contextFile.getAbsolutePath() + " found.");
        }
        FileOutputStream output = null;
        try {
            try {
                output = new FileOutputStream(contextFile);
                DOMSource domSource = new DOMSource(context);
                StreamResult streamResult = new StreamResult(output);
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                transformer.setOutputProperty("method", "xml");
                if (context.getDoctype() != null) {
                    transformer.setOutputProperty("doctype-public", context.getDoctype().getPublicId());
                    transformer.setOutputProperty("doctype-system", context.getDoctype().getSystemId());
                }
                transformer.setOutputProperty("media-type", "text/xml");
                transformer.setOutputProperty("indent", "yes");
                transformer.transform(domSource, streamResult);
            }
            catch (TransformerConfigurationException e) {
                throw new IOException(e.getMessage());
            }
            catch (TransformerException e) {
                throw new IOException(e.getMessage());
            }
            Object var10_11 = null;
            if (output == null) return;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (output == null) throw throwable;
            try {
                output.close();
                throw throwable;
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e1) {}
        output.close();
        return;
    }

    protected Document parseJettyContext(InputStream source) throws Exception {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(true);
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        builder.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (systemId.equals("http://jetty.mortbay.org/configure.dtd")) {
                    return new InputSource(this.getClass().getResourceAsStream("jetty/configure_6_0.dtd"));
                }
                return null;
            }
        });
        Document document = builder.parse(source);
        return document;
    }
}

