/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.desktop.impl;

import java.io.IOException;
import org.apache.jetspeed.pipeline.PipelineException;
import org.apache.jetspeed.pipeline.valve.AbstractValve;
import org.apache.jetspeed.pipeline.valve.ValveContext;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DesktopEncoderRedirectValveImpl
extends AbstractValve {
    protected Logger log = LoggerFactory.getLogger(DesktopEncoderRedirectValveImpl.class);
    private String desktopPipelinePath = null;
    private String desktopRenderPipelinePath = null;

    public DesktopEncoderRedirectValveImpl(String desktopPipelinePath, String desktopRenderPipelinePath) {
        if (desktopPipelinePath == null || desktopPipelinePath.length() == 0) {
            desktopPipelinePath = "/desktop";
        }
        if (desktopPipelinePath.charAt(0) != '/') {
            desktopPipelinePath = "/" + desktopPipelinePath;
        }
        if (desktopPipelinePath.charAt(desktopPipelinePath.length() - 1) != '/') {
            desktopPipelinePath = desktopPipelinePath + "/";
        }
        if (desktopRenderPipelinePath == null || desktopRenderPipelinePath.length() == 0) {
            desktopRenderPipelinePath = "/render";
        }
        if (desktopRenderPipelinePath.charAt(0) != '/') {
            desktopRenderPipelinePath = "/" + desktopRenderPipelinePath;
        }
        if (desktopRenderPipelinePath.charAt(desktopRenderPipelinePath.length() - 1) != '/') {
            desktopRenderPipelinePath = desktopRenderPipelinePath + "/";
        }
        this.desktopPipelinePath = desktopPipelinePath;
        this.desktopRenderPipelinePath = desktopRenderPipelinePath;
    }

    public void invoke(RequestContext request, ValveContext context) throws PipelineException {
        block5: {
            try {
                String encoding;
                if (request.getPortalURL() != null || (encoding = request.getRequestParameter("encoder")) != null && encoding.equals("desktop")) break block5;
                try {
                    String queryString = request.getRequest().getQueryString();
                    String location = request.getRequest().getRequestURI();
                    if (queryString != null && queryString.length() > 0) {
                        location = location + "?" + queryString;
                    }
                    location = location.replaceAll(this.desktopRenderPipelinePath, this.desktopPipelinePath);
                    request.getResponse().sendRedirect(location);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                return;
            }
            catch (Exception e) {
                throw new PipelineException((Throwable)e);
            }
        }
        context.invokeNext(request);
    }

    public String toString() {
        return "DesktopValve";
    }
}

