/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.desktop.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.cache.CacheElement;
import org.apache.jetspeed.cache.JetspeedCache;
import org.apache.jetspeed.container.url.BasePortalURL;
import org.apache.jetspeed.decoration.DecorationFactory;
import org.apache.jetspeed.decoration.LayoutDecoration;
import org.apache.jetspeed.decoration.PortletDecoration;
import org.apache.jetspeed.decoration.Theme;
import org.apache.jetspeed.desktop.JetspeedDesktop;
import org.apache.jetspeed.desktop.impl.JetspeedDesktopContextImpl;
import org.apache.jetspeed.headerresource.HeaderResource;
import org.apache.jetspeed.headerresource.HeaderResourceFactory;
import org.apache.jetspeed.headerresource.HeaderResourceLib;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ServletContextAware;

public class JetspeedDesktopImpl
implements JetspeedDesktop,
ServletContextAware {
    private static final Logger log = LoggerFactory.getLogger(JetspeedDesktopImpl.class);
    private static final String EOL = "\r\n";
    private static final String DOJO_CONFIG_LAYOUT_DECORATION_PATH_VAR_NAME = "djConfig.jetspeed.layoutDecorationPath";
    private static final String DOJO_CONFIG_LAYOUT_VAR_NAME = "djConfig.jetspeed.layoutName";
    private static final String DOJO_CONFIG_PORTLET_DECORATIONS_PATH_VAR_NAME = "djConfig.jetspeed.portletDecorationsPath";
    private static final String DOJO_CONFIG_PORTLET_DECORATIONS_ALLOWED_VAR_NAME = "djConfig.jetspeed.portletDecorationsAllowed";
    private static final String DOJO_CONFIG_PORTLET_DECORATIONS_CONFIG_VAR_NAME = "djConfig.jetspeed.portletDecorationsProperties";
    private static final String DOJO_CONFIG_ACTION_LABELS_NAME = "djConfig.jetspeed.desktopActionLabels";
    private static final String DOJO_CONFIG_LOADING_IMGPROPS_NAME = "djConfig.jetspeed.loadingImgProps";
    private static final String DOJO_CONFIG_PAGEEDITOR_LABELS_NAME = "djConfig.jetspeed.pageEditorLabels";
    private static final String DOJO_CONFIG_PAGEEDITOR_DIALOG_LABELS_NAME = "djConfig.jetspeed.pageEditorDialogLabels";
    private static final String DOJO_CONFIG_PAGEEDITOR_SETTINGS_NAME = "djConfig.jetspeed.pec";
    private static final String[] DESKTOP_LOADING_PROPERTY_NAMES = new String[]{"dir", "animated", "stepprefix", "stepextension", "steps"};
    private static final String[] DESKTOP_LOADING_OUTPUT_PROPERTY_NAMES = new String[]{"imgdir", "imganimated", "imgstepprefix", "imgstepextension", "imgsteps"};
    private static final String[] DESKTOP_ACTION_RESOURCE_NAMES = new String[]{"menu", "tile", "untile", "heightexpand", "heightnormal", "restore", "removeportlet", "minimized", "maximized", "normal", "help", "edit", "view", "print", "config", "edit_defaults", "about", "addportlet", "editpage", "movetiled", "moveuntiled", "loadpage", "loadpageeditor", "loadportletrender", "loadportletaction", "loadportletupdate"};
    private static final String[] DESKTOP_PAGEEDITOR_RESOURCE_NAMES = new String[]{"title", "changelayout", "changepagelayouttheme", "changepageportlettheme", "newpage", "deletepage", "addlayout", "addportlet", "columnsizes", "deletelayout", "movemode", "movemode_exit", "changeportlettheme"};
    private static final String[] DESKTOP_PAGEEDITOR_DIALOG_RESOURCE_NAMES = new String[]{"columnsizes", "columnsizes_column1", "columnsizes_column2", "columnsizes_column3", "columnsizes_column4", "columnsizes_column5", "newpage", "newpage_name", "newpage_title", "newpage_titleshort", "deletepage", "deletelayout", "removeportlet", "ok", "cancel", "yes", "no"};
    private static final String DESKTOP_LOADING_NAME_PREFIX = "desktop.loading.";
    private static final String DESKTOP_ACTION_NAME_PREFIX = "desktop.action.";
    private static final String DESKTOP_PAGEEDITOR_NAME_PREFIX = "desktop.pageeditor.";
    private static final String DESKTOP_LOADING_IMG_NAME_PREFIX = "desktop.loading.img.";
    private static final String DESKTOP_ACTION_RESOURCE_NAME_PREFIX = "desktop.action.labels.";
    private static final String DESKTOP_PAGEEDITOR_RESOURCE_NAME_PREFIX = "desktop.pageeditor.labels.";
    private static final String DESKTOP_PAGEEDITOR_DIALOG_RESOURCE_NAME_PREFIX = "desktop.pageeditor.dialog.labels.";
    private static final String DESKTOP_PAGEEDITOR_PAGE_LAYOUT_DECORATOR_EDITABLE = "desktop.pageeditor.page.layout.decorator.editable";
    private static final String DESKTOP_PAGEEDITOR_PAGE_LAYOUT_DECORATOR_EDITABLE_DEFAULT = "true";
    private static final String DESKTOP_PAGEEDITOR_LAYOUT_NAME_EDITABLE = "desktop.pageeditor.layout.name.editable";
    private static final String DESKTOP_PAGEEDITOR_LAYOUT_NAME_EDITABLE_DEFAULT = "true";
    private static final String DESKTOP_PAGEEDITOR_LAYOUT_COLUMNSIZE_EDITABLE = "desktop.pageeditor.layout.columnsize.editable";
    private static final String DESKTOP_PAGEEDITOR_LAYOUT_COLUMNSIZE_EDITABLE_DEFAULT = "true";
    private static final String DESKTOP_PAGEEDITOR_PAGE_ADD_ENABLED = "desktop.pageeditor.page.add.enabled";
    private static final String DESKTOP_PAGEEDITOR_PAGE_ADD_ENABLED_DEFAULT = "true";
    private static final String DESKTOP_PAGEEDITOR_PORTLET_ADD_ENABLED = "desktop.pageeditor.portlet.add.enabled";
    private static final String DESKTOP_PAGEEDITOR_PORTLET_ADD_ENABLED_DEFAULT = "true";
    private static final String DESKTOP_PAGEEDITOR_PAGE_PORTLET_DECORATOR_EDITABLE = "desktop.pageeditor.page.portlet.decorator.editable";
    private static final String DESKTOP_PAGEEDITOR_PAGE_PORTLET_DECORATOR_EDITABLE_DEFAULT = "true";
    private static final String DESKTOP_PAGEEDITOR_PORTLET_DECORATOR_EDITABLE = "desktop.pageeditor.portlet.decorator.editable";
    private static final String DESKTOP_PAGEEDITOR_PORTLET_DECORATOR_EDITABLE_DEFAULT = "true";
    private static final String DESKTOP_PAGEEDITOR_MOVEMODE_ISDEFAULT = "desktop.pageeditor.movemode.isdefault";
    private static final String DESKTOP_PAGEEDITOR_MOVEMODE_ISDEFAULT_DEFAULT = "true";
    private static final String DESKTOP_PAGEEDITOR_LAYOUT_NOACTIONS_EDITABLE = "desktop.pageeditor.layout.noactions.editable";
    private static final String DESKTOP_PAGEEDITOR_LAYOUT_NOACTIONS_EDITABLE_DEFAULT = "false";
    private static final String DESKTOP_PAGEEDITOR_LAYOUT_NOACTIONS_TOPLEVEL_MOVEABLE = "desktop.pageeditor.layout.noactions.toplevel.moveable";
    private static final String DESKTOP_PAGEEDITOR_LAYOUT_NOACTIONS_TOPLEVEL_MOVEABLE_DEFAULT = "false";
    private static final String DESKTOP_PAGEEDITOR_LAYOUT_NOACTIONS_COLUMNSIZE_EDITABLE = "desktop.pageeditor.layout.noactions.columnsize.editable";
    private static final String DESKTOP_PAGEEDITOR_LAYOUT_NOACTIONS_COLUMNSIZE_EDITABLE_DEFAULT = "false";
    private static final String DESKTOP_PAGEEDITOR_LAYOUT_NOACTIONS_EDITOR_ROLE = "desktop.pageeditor.layout.noactions.editor.role";
    private static final String DESKTOP_PAGEEDITOR_LAYOUT_NOACTIONS_EDITOR_ROLE_DEFAULT = null;
    private static final String DESKTOP_PAGEEDITOR_PAGE_LAYOUT_DEPTH_MAX = "desktop.pageeditor.page.layout.depth.max";
    private static final int DESKTOP_PAGEEDITOR_PAGE_LAYOUT_DEPTH_MAX_DEFAULT = 2;
    private static final int DESKTOP_PAGEEDITOR_PAGE_LAYOUT_DEPTH_MAX_RESERVED = 15;
    private static final int DESKTOP_PAGEEDITOR_PAGE_LAYOUT_DECORATOR_EDITABLE_TRUE = 16;
    private static final int DESKTOP_PAGEEDITOR_LAYOUT_NAME_EDITABLE_TRUE = 32;
    private static final int DESKTOP_PAGEEDITOR_LAYOUT_COLUMNSIZE_EDITABLE_TRUE = 64;
    private static final int DESKTOP_PAGEEDITOR_PAGE_ADD_ENABLED_TRUE = 128;
    private static final int DESKTOP_PAGEEDITOR_PORTLET_ADD_ENABLED_TRUE = 256;
    private static final int DESKTOP_PAGEEDITOR_PAGE_PORTLET_DECORATOR_EDITABLE_TRUE = 512;
    private static final int DESKTOP_PAGEEDITOR_PORTLET_DECORATOR_EDITABLE_TRUE = 1024;
    private static final int DESKTOP_PAGEEDITOR_MOVEMODE_ISDEFAULT_TRUE = 2048;
    private static final int DESKTOP_PAGEEDITOR_LAYOUT_NOACTIONS_EDITABLE_TRUE = 4096;
    private static final int DESKTOP_PAGEEDITOR_LAYOUT_NOACTIONS_TOPLEVEL_MOVEABLE_TRUE = 8192;
    private static final int DESKTOP_PAGEEDITOR_LAYOUT_NOACTIONS_COLUMNSIZE_EDITABLE_TRUE = 16384;
    private DecorationFactory decorationFactory;
    private String desktopServletPath;
    private String defaultLayoutTemplateExtension;
    private ServletContext servletContext;
    private HeaderResourceFactory headerResourceFactory;
    private JetspeedCache desktopContentCache;
    private BasePortalURL baseUrlAccess = null;

    public JetspeedDesktopImpl(DecorationFactory decorationFactory, HeaderResourceFactory headerResourceFactory, JetspeedCache desktopContentCache, String desktopServletPath, String defaultLayoutTemplateExtension) {
        this(decorationFactory, headerResourceFactory, desktopContentCache, desktopServletPath, defaultLayoutTemplateExtension, null, null, null);
    }

    public JetspeedDesktopImpl(DecorationFactory decorationFactory, HeaderResourceFactory headerResourceFactory, JetspeedCache desktopContentCache, String desktopServletPath, String defaultLayoutTemplateExtension, String defaultDesktopLayoutDecoration, String defaultDesktopPortletDecoration) {
        this(decorationFactory, headerResourceFactory, desktopContentCache, desktopServletPath, defaultLayoutTemplateExtension, defaultDesktopLayoutDecoration, defaultDesktopPortletDecoration, null);
    }

    public JetspeedDesktopImpl(DecorationFactory decorationFactory, HeaderResourceFactory headerResourceFactory, JetspeedCache desktopContentCache, String desktopServletPath, String defaultLayoutTemplateExtension, String defaultDesktopLayoutDecoration, String defaultDesktopPortletDecoration, BasePortalURL baseUrlAccess) {
        String existingDefaultDesktopPortletDecoration;
        String existingDefaultDesktopLayoutDecoration;
        this.decorationFactory = decorationFactory;
        this.headerResourceFactory = headerResourceFactory;
        this.desktopContentCache = desktopContentCache;
        if (desktopServletPath != null && desktopServletPath.length() > 0 && desktopServletPath.charAt(0) != '/') {
            desktopServletPath = "/" + desktopServletPath;
        }
        this.desktopServletPath = desktopServletPath;
        if (this.desktopServletPath == null || this.desktopServletPath.length() == 0) {
            log.warn("JetspeedDesktopImpl initialization is incomplete due to undefined desktop servlet path.");
            this.desktopServletPath = null;
        }
        this.defaultLayoutTemplateExtension = defaultLayoutTemplateExtension;
        if (defaultDesktopLayoutDecoration != null && defaultDesktopLayoutDecoration.length() > 0 && ((existingDefaultDesktopLayoutDecoration = decorationFactory.getDefaultDesktopLayoutDecoration()) == null || existingDefaultDesktopLayoutDecoration.length() == 0)) {
            decorationFactory.setDefaultDesktopLayoutDecoration(defaultDesktopLayoutDecoration);
        }
        if (defaultDesktopPortletDecoration != null && defaultDesktopPortletDecoration.length() > 0 && ((existingDefaultDesktopPortletDecoration = decorationFactory.getDefaultDesktopPortletDecoration()) == null || existingDefaultDesktopPortletDecoration.length() == 0)) {
            decorationFactory.setDefaultDesktopPortletDecoration(defaultDesktopPortletDecoration);
        }
        this.baseUrlAccess = baseUrlAccess;
    }

    public void render(RequestContext request) {
        String layoutDecorationTemplatePath = null;
        boolean layoutDecorationTemplatePathWasAssigned = false;
        try {
            ContentPage page = request.getPage();
            request.setAttribute("desktop.enabled", (Object)Boolean.TRUE);
            Theme theme = this.decorationFactory.getTheme(page, request);
            HeaderResource hr = this.getHeaderResourceFactory().getHeaderResouce(request);
            JetspeedDesktopContextImpl desktopContext = new JetspeedDesktopContextImpl(request, this.baseUrlAccess, theme, hr, this.defaultLayoutTemplateExtension);
            String layoutTemplateIdPropertyName = null;
            if ("true".equals(request.getRequest().getParameter("jsprintmode"))) {
                layoutTemplateIdPropertyName = "template.print.id";
            }
            layoutDecorationTemplatePath = desktopContext.getLayoutTemplatePath(layoutTemplateIdPropertyName);
            layoutDecorationTemplatePathWasAssigned = true;
            RequestDispatcher dispatcher = request.getRequest().getRequestDispatcher(layoutDecorationTemplatePath);
            hr.dojoEnable();
            request.getRequest().setAttribute("jetspeedDesktop", (Object)desktopContext);
            request.getRequest().setAttribute("JS2RequestContext", (Object)request);
            request.getRequest().setAttribute("JS2ComponentManager", (Object)Jetspeed.getComponentManager());
            String layoutDecorationName = desktopContext.getLayoutDecorationName();
            boolean inclStyleLayout = hr.isHeaderSectionIncluded("header.desktop.style.layout");
            String dojoConfigContentCacheKey = "djConfig.jetspeed.layoutName." + layoutDecorationName;
            String dojoConfigContent = this.getCachedContent(dojoConfigContentCacheKey);
            if (dojoConfigContent == null) {
                String portletDecorationsBasePath = this.decorationFactory.getPortletDecorationsBasePath();
                StringBuffer dojoConfigAddOn = new StringBuffer();
                dojoConfigAddOn.append("    ").append(DOJO_CONFIG_LAYOUT_DECORATION_PATH_VAR_NAME).append(" = \"").append(desktopContext.getLayoutBasePath()).append("\";").append(EOL);
                dojoConfigAddOn.append("    ").append(DOJO_CONFIG_LAYOUT_VAR_NAME).append(" = \"").append(layoutDecorationName).append("\";").append(EOL);
                dojoConfigAddOn.append("    ").append(DOJO_CONFIG_PORTLET_DECORATIONS_PATH_VAR_NAME).append(" = \"").append(portletDecorationsBasePath).append("\";").append(EOL);
                LayoutDecoration desktopLayoutDecoration = this.decorationFactory.getLayoutDecoration(layoutDecorationName, request);
                if (desktopLayoutDecoration != null) {
                    boolean atLeastOneFound = false;
                    StringBuffer loadingPropsBuffer = new StringBuffer();
                    loadingPropsBuffer.append("    ").append(DOJO_CONFIG_LOADING_IMGPROPS_NAME).append(" = { ");
                    for (int i = 0; i < DESKTOP_LOADING_PROPERTY_NAMES.length; ++i) {
                        String propValue = desktopLayoutDecoration.getProperty(DESKTOP_LOADING_IMG_NAME_PREFIX + DESKTOP_LOADING_PROPERTY_NAMES[i]);
                        if (propValue == null) continue;
                        if (atLeastOneFound) {
                            loadingPropsBuffer.append(", ");
                        } else {
                            atLeastOneFound = true;
                        }
                        String usePropertyName = DESKTOP_LOADING_PROPERTY_NAMES[i];
                        if (DESKTOP_LOADING_OUTPUT_PROPERTY_NAMES != null && DESKTOP_LOADING_OUTPUT_PROPERTY_NAMES.length > i && DESKTOP_LOADING_OUTPUT_PROPERTY_NAMES[i] != null) {
                            usePropertyName = DESKTOP_LOADING_OUTPUT_PROPERTY_NAMES[i];
                        }
                        loadingPropsBuffer.append(usePropertyName).append(": ").append(propValue);
                    }
                    loadingPropsBuffer.append(" };");
                    if (atLeastOneFound) {
                        dojoConfigAddOn.append(loadingPropsBuffer.toString()).append(EOL);
                    }
                    this.addPageEditorSettings(dojoConfigAddOn, desktopLayoutDecoration);
                } else {
                    log.error("Failed to find desktop layout decoration " + layoutDecorationName + " - layout decoration properties cannot be added to content.");
                }
                Set desktopPortletDecorationsNames = this.decorationFactory.getDesktopPortletDecorations(request);
                String portletDecorationNamesContent = HeaderResourceLib.makeJSONStringArray((Collection)desktopPortletDecorationsNames);
                dojoConfigAddOn.append("    ").append(DOJO_CONFIG_PORTLET_DECORATIONS_ALLOWED_VAR_NAME).append(" = ").append(portletDecorationNamesContent).append(";");
                StringBuffer pDecsOut = new StringBuffer();
                for (String desktopPortletDecorationName : desktopPortletDecorationsNames) {
                    String resizebarEnabledContent;
                    String titlebarEnabledContent;
                    String iconPathContent;
                    String iconEnabledContent;
                    String windowActionButtonMax;
                    String windowActionButtonTooltip;
                    String actionMenuOrderContent;
                    String actionNoImageContent;
                    PortletDecoration desktopPortletDecoration = this.decorationFactory.getPortletDecoration(desktopPortletDecorationName, request);
                    StringBuffer pOut = new StringBuffer();
                    String actionButtonOrderContent = desktopPortletDecoration.getProperty("window.action.button.order");
                    if (actionButtonOrderContent != null && actionButtonOrderContent.length() > 0) {
                        pOut.append(pOut.length() > 0 ? ", " : "").append("windowActionButtonOrder").append(": ").append(actionButtonOrderContent);
                    }
                    if ((actionNoImageContent = desktopPortletDecoration.getProperty("window.action.noimage")) != null && actionNoImageContent.length() > 0) {
                        pOut.append(pOut.length() > 0 ? ", " : "").append("windowActionNoImage").append(": ").append(actionNoImageContent);
                    }
                    if ((actionMenuOrderContent = desktopPortletDecoration.getProperty("window.action.menu.order")) != null && actionMenuOrderContent.length() > 0) {
                        pOut.append(pOut.length() > 0 ? ", " : "").append("windowActionMenuOrder").append(": ").append(actionMenuOrderContent);
                    }
                    if ((windowActionButtonTooltip = desktopPortletDecoration.getProperty("window.action.button.tooltip")) != null && windowActionButtonTooltip.length() > 0) {
                        pOut.append(pOut.length() > 0 ? ", " : "").append("windowActionButtonTooltip").append(": ").append(windowActionButtonTooltip);
                    }
                    if ((windowActionButtonMax = desktopPortletDecoration.getProperty("window.action.button.maximum")) != null && windowActionButtonMax.length() > 0) {
                        pOut.append(pOut.length() > 0 ? ", " : "").append("windowActionButtonMax").append(": ").append(windowActionButtonMax);
                    }
                    if ((iconEnabledContent = desktopPortletDecoration.getProperty("window.icon.enabled")) != null && iconEnabledContent.length() > 0) {
                        pOut.append(pOut.length() > 0 ? ", " : "").append("windowIconEnabled").append(": ").append(iconEnabledContent);
                    }
                    if ((iconPathContent = desktopPortletDecoration.getProperty("window.icon.path")) != null && iconPathContent.length() > 0) {
                        pOut.append(pOut.length() > 0 ? ", " : "").append("windowIconPath").append(": ").append(iconPathContent).append(";").append(EOL);
                    }
                    if ((titlebarEnabledContent = desktopPortletDecoration.getProperty("window.titlebar.enabled")) != null && titlebarEnabledContent.length() > 0) {
                        pOut.append(pOut.length() > 0 ? ", " : "").append("windowTitlebar").append(": ").append(titlebarEnabledContent);
                    }
                    if ((resizebarEnabledContent = desktopPortletDecoration.getProperty("window.resizebar.enabled")) != null && resizebarEnabledContent.length() > 0) {
                        pOut.append(pOut.length() > 0 ? ", " : "").append("windowResizebar").append(": ").append(resizebarEnabledContent);
                    }
                    if (pOut.length() <= 0) continue;
                    if (pDecsOut.length() == 0) {
                        pDecsOut.append(DOJO_CONFIG_PORTLET_DECORATIONS_CONFIG_VAR_NAME).append(" = { ");
                    } else {
                        pDecsOut.append(", ");
                    }
                    pDecsOut.append("\"").append(desktopPortletDecorationName).append("\": { ").append(pOut.toString()).append(" }").append(EOL);
                }
                if (pDecsOut.length() > 0) {
                    pDecsOut.append(" }");
                    dojoConfigAddOn.append(EOL).append("    ").append(pDecsOut.toString()).append(";");
                }
                dojoConfigContent = dojoConfigAddOn.toString();
                this.setCachedContent(dojoConfigContentCacheKey, dojoConfigContent);
            }
            if (dojoConfigContent != null) {
                hr.addHeaderSectionFragment(DOJO_CONFIG_LAYOUT_VAR_NAME, "header.dojo.config", dojoConfigContent);
            }
            if (inclStyleLayout) {
                String contextPath = request.getRequest().getContextPath();
                String styleLayoutContentCacheKey = "header.desktop.style.layout." + layoutDecorationName + "." + contextPath;
                String styleLayoutContent = this.getCachedContent(styleLayoutContentCacheKey);
                if (styleLayoutContent == null) {
                    String portletDecorationsBasePath = this.decorationFactory.getPortletDecorationsBasePath();
                    String portletDecorationsBaseRelative = portletDecorationsBasePath;
                    if (portletDecorationsBaseRelative != null && portletDecorationsBaseRelative.length() > 1 && portletDecorationsBaseRelative.indexOf(47) == 0) {
                        portletDecorationsBaseRelative = portletDecorationsBaseRelative.substring(1);
                    }
                    StringBuffer desktopThemeStyleLink = new StringBuffer();
                    int stylesheetCount = 0;
                    for (String stylesheetHref : theme.getStyleSheets()) {
                        if (stylesheetHref == null || stylesheetHref.length() <= 0 || stylesheetHref.startsWith(portletDecorationsBaseRelative)) continue;
                        if (stylesheetCount > 0) {
                            desktopThemeStyleLink.append(EOL);
                        }
                        desktopThemeStyleLink.append("<link rel=\"stylesheet\" type=\"text/css\" media=\"screen, projection\" href=\"");
                        desktopThemeStyleLink.append(contextPath + "/" + stylesheetHref).append("\"/>");
                        ++stylesheetCount;
                    }
                    styleLayoutContent = desktopThemeStyleLink.toString();
                    this.setCachedContent(styleLayoutContentCacheKey, styleLayoutContent);
                }
                if (styleLayoutContent != null && styleLayoutContent.length() > 0) {
                    hr.setHeaderSectionType("header.desktop.style.layout", "link-tag");
                    hr.addHeaderSectionFragment("desktop.style.layout", "header.desktop.style.layout", styleLayoutContent);
                }
            }
            String layoutDecorationLocaleSuffix = "." + layoutDecorationName + "." + request.getLocale().toString();
            String desktopActionLabelsCacheKey = DOJO_CONFIG_ACTION_LABELS_NAME + layoutDecorationLocaleSuffix;
            String pageEditorLabelsCacheKey = DOJO_CONFIG_PAGEEDITOR_LABELS_NAME + layoutDecorationLocaleSuffix;
            String pageEditorDialogLabelsCacheKey = DOJO_CONFIG_PAGEEDITOR_DIALOG_LABELS_NAME + layoutDecorationLocaleSuffix;
            String desktopActionLabelsContent = this.getCachedContent(desktopActionLabelsCacheKey);
            String pageEditorLabelsContent = this.getCachedContent(pageEditorLabelsCacheKey);
            String pageEditorDialogLabelsContent = this.getCachedContent(pageEditorDialogLabelsCacheKey);
            if (desktopActionLabelsContent == null || pageEditorLabelsContent == null || pageEditorDialogLabelsContent == null) {
                ResourceBundle messages = desktopContext.getLayoutResourceBundle(request.getLocale());
                if (desktopActionLabelsContent == null) {
                    desktopActionLabelsContent = this.getResourcesAsJavascriptObject(DESKTOP_ACTION_RESOURCE_NAME_PREFIX, DESKTOP_ACTION_RESOURCE_NAMES, messages, DOJO_CONFIG_ACTION_LABELS_NAME, "    ", true);
                    this.setCachedContent(desktopActionLabelsCacheKey, desktopActionLabelsContent);
                }
                if (pageEditorLabelsContent == null) {
                    pageEditorLabelsContent = this.getResourcesAsJavascriptObject(DESKTOP_PAGEEDITOR_RESOURCE_NAME_PREFIX, DESKTOP_PAGEEDITOR_RESOURCE_NAMES, messages, DOJO_CONFIG_PAGEEDITOR_LABELS_NAME, "    ", true);
                    this.setCachedContent(pageEditorLabelsCacheKey, pageEditorLabelsContent);
                }
                if (pageEditorDialogLabelsContent == null) {
                    pageEditorDialogLabelsContent = this.getResourcesAsJavascriptObject(DESKTOP_PAGEEDITOR_DIALOG_RESOURCE_NAME_PREFIX, DESKTOP_PAGEEDITOR_DIALOG_RESOURCE_NAMES, messages, DOJO_CONFIG_PAGEEDITOR_DIALOG_LABELS_NAME, "    ", true);
                    this.setCachedContent(pageEditorDialogLabelsCacheKey, pageEditorDialogLabelsContent);
                }
            }
            if (desktopActionLabelsContent != null && desktopActionLabelsContent.length() > 0) {
                hr.addHeaderSectionFragment(DOJO_CONFIG_ACTION_LABELS_NAME, "header.dojo.config", desktopActionLabelsContent);
            }
            if (pageEditorLabelsContent != null && pageEditorLabelsContent.length() > 0) {
                hr.addHeaderSectionFragment(DOJO_CONFIG_PAGEEDITOR_LABELS_NAME, "header.dojo.config", pageEditorLabelsContent);
            }
            if (pageEditorDialogLabelsContent != null && pageEditorDialogLabelsContent.length() > 0) {
                hr.addHeaderSectionFragment(DOJO_CONFIG_PAGEEDITOR_DIALOG_LABELS_NAME, "header.dojo.config", pageEditorDialogLabelsContent);
            }
            dispatcher.include((ServletRequest)request.getRequest(), (ServletResponse)request.getResponse());
        }
        catch (Exception e) {
            try {
                if (layoutDecorationTemplatePathWasAssigned) {
                    layoutDecorationTemplatePath = layoutDecorationTemplatePath == null || layoutDecorationTemplatePath.length() == 0 ? "null" : layoutDecorationTemplatePath;
                    log.error("Failed to include desktop layout decoration at path " + layoutDecorationTemplatePath, (Throwable)e);
                    request.getResponse().getWriter().println("Desktop layout decoration " + layoutDecorationTemplatePath + " is not available");
                } else {
                    log.error("Failed to initialize for inclusion of desktop layout decoration", (Throwable)e);
                    request.getResponse().getWriter().println("Failed to initialize for inclusion of desktop layout decoration");
                }
            }
            catch (IOException ioe) {
                log.error("Failed to write desktop layout decoration exception information to servlet output writer", (Throwable)ioe);
            }
        }
    }

    private void addPageEditorSettings(StringBuffer dojoConfigAddOn, LayoutDecoration desktopLayoutDecoration) {
        char[] allowEditNoactionsRoleChars;
        int[] pageEditorConfigFlags = new int[]{0};
        String propValue = desktopLayoutDecoration.getProperty(DESKTOP_PAGEEDITOR_PAGE_LAYOUT_DECORATOR_EDITABLE);
        this.processBooleanFlagProperty(pageEditorConfigFlags, propValue, "true", 16);
        propValue = desktopLayoutDecoration.getProperty(DESKTOP_PAGEEDITOR_LAYOUT_NAME_EDITABLE);
        this.processBooleanFlagProperty(pageEditorConfigFlags, propValue, "true", 32);
        propValue = desktopLayoutDecoration.getProperty(DESKTOP_PAGEEDITOR_LAYOUT_COLUMNSIZE_EDITABLE);
        this.processBooleanFlagProperty(pageEditorConfigFlags, propValue, "true", 64);
        propValue = desktopLayoutDecoration.getProperty(DESKTOP_PAGEEDITOR_PAGE_ADD_ENABLED);
        this.processBooleanFlagProperty(pageEditorConfigFlags, propValue, "true", 128);
        propValue = desktopLayoutDecoration.getProperty(DESKTOP_PAGEEDITOR_PORTLET_ADD_ENABLED);
        this.processBooleanFlagProperty(pageEditorConfigFlags, propValue, "true", 256);
        propValue = desktopLayoutDecoration.getProperty(DESKTOP_PAGEEDITOR_PAGE_PORTLET_DECORATOR_EDITABLE);
        this.processBooleanFlagProperty(pageEditorConfigFlags, propValue, "true", 512);
        propValue = desktopLayoutDecoration.getProperty(DESKTOP_PAGEEDITOR_PORTLET_DECORATOR_EDITABLE);
        this.processBooleanFlagProperty(pageEditorConfigFlags, propValue, "true", 1024);
        propValue = desktopLayoutDecoration.getProperty(DESKTOP_PAGEEDITOR_LAYOUT_NOACTIONS_EDITABLE);
        this.processBooleanFlagProperty(pageEditorConfigFlags, propValue, "false", 4096);
        propValue = desktopLayoutDecoration.getProperty(DESKTOP_PAGEEDITOR_LAYOUT_NOACTIONS_TOPLEVEL_MOVEABLE);
        this.processBooleanFlagProperty(pageEditorConfigFlags, propValue, "false", 8192);
        propValue = desktopLayoutDecoration.getProperty(DESKTOP_PAGEEDITOR_LAYOUT_NOACTIONS_COLUMNSIZE_EDITABLE);
        this.processBooleanFlagProperty(pageEditorConfigFlags, propValue, "false", 16384);
        propValue = desktopLayoutDecoration.getProperty(DESKTOP_PAGEEDITOR_MOVEMODE_ISDEFAULT);
        this.processBooleanFlagProperty(pageEditorConfigFlags, propValue, "true", 2048);
        propValue = desktopLayoutDecoration.getProperty(DESKTOP_PAGEEDITOR_PAGE_LAYOUT_DEPTH_MAX);
        Integer maxLayoutNestingObj = null;
        try {
            maxLayoutNestingObj = new Integer(propValue);
        }
        catch (NumberFormatException ex) {
            maxLayoutNestingObj = new Integer(2);
        }
        int maxLayoutNesting = maxLayoutNestingObj;
        if (maxLayoutNesting < 0) {
            maxLayoutNesting = 0;
        }
        if (maxLayoutNesting > 15) {
            maxLayoutNesting = 15;
        }
        pageEditorConfigFlags[0] = pageEditorConfigFlags[0] + maxLayoutNesting;
        String allowEditNoactionsRole = desktopLayoutDecoration.getProperty(DESKTOP_PAGEEDITOR_LAYOUT_NOACTIONS_EDITOR_ROLE);
        if (allowEditNoactionsRole == null) {
            allowEditNoactionsRole = DESKTOP_PAGEEDITOR_LAYOUT_NOACTIONS_EDITOR_ROLE_DEFAULT;
        }
        if (allowEditNoactionsRole == null) {
            allowEditNoactionsRole = "";
        }
        int allowEditNoactionsRoleCharsLen = (allowEditNoactionsRoleChars = allowEditNoactionsRole.toCharArray()) == null ? 0 : allowEditNoactionsRoleChars.length;
        Random rnd = new Random();
        int extrasCount = allowEditNoactionsRoleCharsLen > 0 ? this.getRandom(rnd, 2, 5) : this.getRandom(rnd, 5, 8);
        int hexLen = 1 + extrasCount + allowEditNoactionsRoleCharsLen;
        int addedExtras = 0;
        int nextRoleChar = 0;
        StringBuffer pageEditorSettings = new StringBuffer();
        for (int i = 0; i < hexLen; ++i) {
            int valToHex;
            int rndValTensEven;
            int rndVal = this.getRandom(rnd, 4096, 65533);
            boolean isRndValEven = rndVal % 2 == 0;
            int rndValTens = (int)Math.floor(rndVal / 10);
            int n = rndValTensEven = rndValTens % 2 == 1 ? Math.max(rndValTens - 1, 2) : rndValTens;
            if (i == 0) {
                valToHex = pageEditorConfigFlags[0];
            } else if (addedExtras < extrasCount && (i % 2 == 1 || nextRoleChar >= allowEditNoactionsRoleCharsLen)) {
                if (!isRndValEven) {
                    ++rndVal;
                }
                if ((valToHex = this.getRandom(rnd, 2560, 57343)) % 2 == 1) {
                    ++valToHex;
                }
                pageEditorSettings.append(", ");
                ++addedExtras;
            } else {
                valToHex = allowEditNoactionsRoleChars[nextRoleChar] << 4 | 1;
                pageEditorSettings.append(", ");
                ++nextRoleChar;
            }
            String rndValHex = Integer.toHexString(0x10000 | rndVal).substring(1);
            String realValHex = Integer.toHexString(0x10000 | valToHex + rndValTensEven).substring(1);
            if (isRndValEven && i > 0) {
                pageEditorSettings.append("0x").append(realValHex).append(rndValHex);
                continue;
            }
            pageEditorSettings.append("0x").append(rndValHex).append(realValHex);
        }
        dojoConfigAddOn.append("    ").append(DOJO_CONFIG_PAGEEDITOR_SETTINGS_NAME).append(" = [ ").append(pageEditorSettings.toString()).append(" ];").append(EOL);
    }

    private int getRandom(Random rnd, int minValueInclusive, int maxValueExclusive) {
        if (minValueInclusive > maxValueExclusive) {
            throw new IllegalArgumentException("minValueInclusive (" + minValueInclusive + ") cannot be greater than maxValueExclusive (" + maxValueExclusive + ")");
        }
        int diff = maxValueExclusive - minValueInclusive;
        if (diff == 0) {
            return minValueInclusive;
        }
        double sample = rnd.nextDouble();
        int result = (int)(sample * (double)diff + (double)minValueInclusive);
        result = result != maxValueExclusive ? result : result - 1;
        return result;
    }

    private void processBooleanFlagProperty(int[] flags, Object propVal, Object propValDefault, int propIsTrueBit) {
        String boolStr;
        String string = propVal == null ? (propValDefault == null ? (String)null : propValDefault.toString()) : (boolStr = propVal.toString());
        if (boolStr != null && boolStr.toLowerCase().equals("true")) {
            flags[0] = flags[0] | propIsTrueBit;
        }
    }

    private String getCachedContent(String cacheKey) {
        CacheElement cachedElement = this.desktopContentCache.get((Object)cacheKey);
        if (cachedElement != null) {
            return (String)cachedElement.getContent();
        }
        return null;
    }

    private void setCachedContent(String cacheKey, String content) {
        CacheElement cachedElement = this.desktopContentCache.createElement((Object)cacheKey, (Object)content);
        cachedElement.setTimeToIdleSeconds(this.desktopContentCache.getTimeToIdleSeconds());
        cachedElement.setTimeToLiveSeconds(this.desktopContentCache.getTimeToLiveSeconds());
        this.desktopContentCache.put(cachedElement);
    }

    private String getResourcesAsJavascriptObject(String resourceNamePrefix, String[] resourceNames, ResourceBundle messages, String varName, String indent, boolean ifEmptyReturnEmptyString) {
        StringBuffer jsObjBuffer = new StringBuffer();
        boolean atLeastOneFound = false;
        if (indent != null) {
            jsObjBuffer.append(indent);
        }
        if (varName != null) {
            jsObjBuffer.append(varName).append(" = ");
        }
        jsObjBuffer.append("{ ");
        for (int i = 0; i < resourceNames.length; ++i) {
            String resourceValue = null;
            try {
                resourceValue = messages.getString(resourceNamePrefix + resourceNames[i]);
            }
            catch (MissingResourceException ex) {
                // empty catch block
            }
            if (resourceValue == null) continue;
            if (atLeastOneFound) {
                jsObjBuffer.append(", ");
            } else {
                atLeastOneFound = true;
            }
            jsObjBuffer.append(resourceNames[i]).append(": \"").append(resourceValue).append("\"");
        }
        jsObjBuffer.append(" };");
        if (!atLeastOneFound && ifEmptyReturnEmptyString) {
            return "";
        }
        return jsObjBuffer.toString();
    }

    public boolean isDesktopEnabled(RequestContext requestContext) {
        return this.decorationFactory.isDesktopEnabled(requestContext);
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public HeaderResourceFactory getHeaderResourceFactory() {
        return this.headerResourceFactory;
    }

    public String getDesktopServletPath() {
        return this.desktopServletPath;
    }

    public String getPortalBaseUrl(RequestContext context) {
        return HeaderResourceLib.getPortalBaseUrl((RequestContext)context, (BasePortalURL)this.baseUrlAccess);
    }

    public String getPortalBaseUrl(RequestContext context, boolean encode) {
        String baseurl = this.getPortalBaseUrl(context);
        if (!encode) {
            return baseurl;
        }
        return context.getResponse().encodeURL(baseurl);
    }

    public String getPortalResourceUrl(RequestContext context, String relativePath) {
        return this.getPortalResourceUrl(context, relativePath, false);
    }

    public String getPortalResourceUrl(RequestContext context, String relativePath, boolean encode) {
        return HeaderResourceLib.getPortalResourceUrl((String)relativePath, (String)this.getPortalBaseUrl(context), (boolean)encode, (RequestContext)context);
    }

    public String getPortalUrl(RequestContext context) {
        return HeaderResourceLib.getPortalUrl((String)this.getPortalBaseUrl(context), (RequestContext)context, (String)this.getDesktopServletPath());
    }

    public String getPortalUrl(RequestContext context, boolean encode) {
        return this.getPortalUrl(context, null, encode);
    }

    public String getPortalUrl(RequestContext context, String relativePath) {
        return this.getPortalUrl(context, relativePath, false);
    }

    public String getPortalUrl(RequestContext context, String relativePath, boolean encode) {
        return HeaderResourceLib.getPortalResourceUrl((String)relativePath, (String)this.getPortalUrl(context), (boolean)encode, (RequestContext)context);
    }
}

