/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.engine;

import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.cache.UserContentCacheManager;
import org.apache.jetspeed.components.ComponentManager;
import org.apache.jetspeed.components.JetspeedBeanDefinitionFilter;
import org.apache.jetspeed.components.SpringComponentManager;
import org.apache.jetspeed.components.factorybeans.ServletConfigFactoryBean;
import org.apache.jetspeed.container.session.PortalSessionsManager;
import org.apache.jetspeed.engine.Engine;
import org.apache.jetspeed.engine.JetspeedEngine;
import org.apache.jetspeed.engine.JetspeedEngineConstants;
import org.apache.jetspeed.engine.servlet.ServletHelper;
import org.apache.jetspeed.exception.JetspeedException;
import org.apache.jetspeed.pipeline.valve.SecurityValve;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.request.RequestContextComponent;
import org.apache.jetspeed.request.RequestDiagnostics;
import org.apache.jetspeed.request.RequestDiagnosticsFactory;
import org.apache.jetspeed.request.RequestDiagnosticsHolder;
import org.apache.jetspeed.security.SubjectHelper;
import org.apache.jetspeed.security.UserSubjectPrincipal;
import org.apache.jetspeed.services.JetspeedPortletServices;
import org.apache.jetspeed.services.PortletServices;
import org.apache.jetspeed.statistics.PortalStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JetspeedServlet
extends HttpServlet
implements JetspeedEngineConstants,
HttpSessionListener {
    private static Logger log;
    private static Logger console;
    private static boolean firstInit;
    private static Throwable initFailure;
    private static boolean firstDoGet;
    private static final String ERROR_HANDLER_PATH_PARM = "errorHandlerPath";
    private static final String DEFAULT_ERROR_HANDLER_PATH = "/diagnostics";
    private static Engine engine;
    private static RequestContextComponent contextComponent;
    private static String webappRoot;
    private static final String INIT_START_MSG = "Jetspeed Starting Initialization...";
    private static final String INIT_DONE_MSG = "Jetspeed Initialization complete, Ready to service requests.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init(ServletConfig config) throws ServletException {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        synchronized (clazz) {
            if (log == null) {
                log = LoggerFactory.getLogger(JetspeedServlet.class);
                console = LoggerFactory.getLogger((String)"console");
            }
            console.info(INIT_START_MSG);
            super.init(config);
            if (!firstInit) {
                log.info("Double initialization of Jetspeed was attempted!");
                console.info("Double initialization of Jetspeed was attempted!");
                return;
            }
            firstInit = false;
            try {
                PropertiesConfiguration extraProps;
                ServletContext context = config.getServletContext();
                String propertiesFilename = ServletHelper.findInitParameter(context, config, "properties", "/WEB-INF/conf/jetspeed.properties");
                String applicationRoot = ServletHelper.findInitParameter(context, config, "applicationRoot", "webContext");
                console.info("JetspeedServlet identifying web application root...");
                webappRoot = config.getServletContext().getRealPath("/");
                console.info("JetspeedServlet identifed web application root as " + webappRoot);
                if (applicationRoot == null || applicationRoot.equals("webContext")) {
                    applicationRoot = webappRoot;
                }
                applicationRoot = applicationRoot.replace('\\', '/');
                PropertiesConfiguration properties = new PropertiesConfiguration();
                File propsFile = new File(ServletHelper.getRealPath(config, propertiesFilename));
                if (!propsFile.isFile()) {
                    throw new IOException("Jetspeed properties not found: " + propsFile.getAbsolutePath());
                }
                File jetspeedPropertiesPath = propsFile.getParentFile();
                properties.load(propsFile);
                propsFile = new File(jetspeedPropertiesPath, "override.properties");
                if (propsFile.exists()) {
                    extraProps = new PropertiesConfiguration();
                    extraProps.load(propsFile);
                    ConfigurationUtils.copy((Configuration)extraProps, (Configuration)properties);
                }
                if ((propsFile = new File(jetspeedPropertiesPath, "spring-filter-key.properties")).exists()) {
                    extraProps = new PropertiesConfiguration();
                    extraProps.load(propsFile);
                    Object springFilterKey = extraProps.getProperty("spring.filter.key");
                    if (springFilterKey != null) {
                        properties.setProperty("spring.filter.key", springFilterKey);
                    }
                }
                properties.setProperty("applicationRoot", (Object)applicationRoot);
                properties.setProperty("webappRoot", (Object)webappRoot);
                properties.setProperty("jetspeedPropertiesPath", (Object)jetspeedPropertiesPath.getAbsolutePath());
                console.info("JetspeedServlet attempting to create the  portlet engine...");
                engine = new JetspeedEngine((Configuration)properties, applicationRoot, config, this.initializeComponentManager(config, applicationRoot, (Configuration)properties));
                console.info("JetspeedServlet attempting to start the Jetspeed Portal Engine...");
                Jetspeed.setEngine((Engine)engine);
                engine.start();
                console.info("JetspeedServlet has successfuly started the Jetspeed Portal Engine....");
                contextComponent = (RequestContextComponent)Jetspeed.getComponentManager().getComponent(RequestContextComponent.class);
            }
            catch (Throwable e) {
                String msg = "Jetspeed: init() failed: ";
                initFailure = e;
                log.error("Jetspeed: init() failed: ", e);
                console.error("Jetspeed: init() failed: ", e);
            }
            console.info(INIT_DONE_MSG);
            log.info(INIT_DONE_MSG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init(HttpServletRequest request, HttpServletResponse response) {
        Class<JetspeedServlet> clazz = JetspeedServlet.class;
        synchronized (JetspeedServlet.class) {
            if (firstDoGet) {
                engine.getContext().setContextPath(request.getContextPath());
                firstDoGet = false;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invoke(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        block6: {
            RequestContext context = null;
            try {
                String wasFiltered;
                this.cleanupError(req);
                if (initFailure != null) {
                    throw new ServletException("Failed to initalize jetspeed.  " + initFailure.toString(), initFailure);
                }
                if (firstDoGet) {
                    this.init(req, res);
                }
                if ((wasFiltered = (String)req.getAttribute("org.apache.jetspeed.content.filtered")) != null && wasFiltered.equals("true")) break block6;
                res.setHeader("Cache-Control", "no-cache,no-store,private");
                res.setHeader("Pragma", "no-cache");
                res.setHeader("Expires", "0");
                try {
                    context = contextComponent.create(req, res, this.getServletConfig());
                    engine.service(context);
                    Object var6_6 = null;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    contextComponent.setRequestContext(null);
                    throw throwable;
                }
                contextComponent.setRequestContext(null);
                {
                }
            }
            catch (Throwable e) {
                this.handleError(req, res, context, e);
            }
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.invoke(request, response);
    }

    public final void destroy() {
        try {
            Jetspeed.shutdown();
        }
        catch (JetspeedException e) {
            log.error("Jetspeed: shutdown() failed: ", (Throwable)e);
            System.err.println(ExceptionUtils.getStackTrace((Throwable)e));
        }
        firstInit = true;
        log.info("Done shutting down!");
    }

    protected ComponentManager initializeComponentManager(ServletConfig servletConfig, String appRoot, Configuration configuration) throws IOException {
        ServletConfigFactoryBean.setServletConfig((ServletConfig)servletConfig);
        String assemblyDir = configuration.getString("assembly.dir", "/WEB-INF/assembly");
        String assemblyFileExtension = configuration.getString("assembly.extension", ".xml");
        String springFilterKey = configuration.getString("spring.filter.key", "portal");
        File springFilterProperties = new File(configuration.getString("jetspeedPropertiesPath"), "spring-filter.properties");
        if (!springFilterProperties.isFile()) {
            throw new IOException("Spring filter properties not found: " + springFilterProperties.getAbsolutePath());
        }
        String[] bootConfigs = new String[]{"/WEB-INF/assembly/boot/*.xml"};
        String[] appConfigs = new String[]{assemblyDir + "/*" + assemblyFileExtension, assemblyDir + "/override/*" + assemblyFileExtension};
        ServletContext servletContext = servletConfig.getServletContext();
        JetspeedBeanDefinitionFilter filter = new JetspeedBeanDefinitionFilter("file:" + springFilterProperties.getAbsolutePath(), springFilterKey);
        Properties initProperties = new Properties();
        initProperties.put("jetspeedPropertiesPath", configuration.getString("jetspeedPropertiesPath"));
        SpringComponentManager cm = new SpringComponentManager(filter, bootConfigs, appConfigs, servletContext, appRoot, initProperties);
        return cm;
    }

    public void sessionCreated(HttpSessionEvent se) {
        PortalSessionsManager psm;
        PortletServices services = JetspeedPortletServices.getSingleton();
        if (services != null && (psm = (PortalSessionsManager)services.getService(PortalSessionsManager.SERVICE_NAME)) != null) {
            psm.portalSessionCreated(se.getSession());
        }
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        Subject subject = (Subject)se.getSession().getAttribute("org.apache.jetspeed.security.subject");
        if (subject == null) {
            return;
        }
        if (firstInit) {
            return;
        }
        Principal subjectUserPrincipal = SubjectHelper.getPrincipal((Subject)subject, UserSubjectPrincipal.class);
        PortalStatistics statistics = (PortalStatistics)engine.getComponentManager().getComponent((Object)"PortalStatistics");
        long sessionLength = System.currentTimeMillis() - se.getSession().getCreationTime();
        String ipAddress = (String)se.getSession().getAttribute(SecurityValve.IP_ADDRESS);
        statistics.logUserLogout(ipAddress, subjectUserPrincipal.getName(), sessionLength);
        UserContentCacheManager userContentCacheManager = (UserContentCacheManager)engine.getComponentManager().getComponent((Object)"userContentCacheManager");
        userContentCacheManager.evictUserContentCache(subjectUserPrincipal.getName(), se.getSession().getId());
    }

    protected void handleError(HttpServletRequest req, HttpServletResponse res, RequestContext context, Throwable t) throws IOException, ServletException {
        String errorHandlerPath = this.getInitParameter(ERROR_HANDLER_PATH_PARM);
        if (errorHandlerPath == null || errorHandlerPath.trim().length() == 0) {
            errorHandlerPath = DEFAULT_ERROR_HANDLER_PATH;
        }
        String msg = "Request error encountered while processing portal request: " + t.getMessage();
        log.error(msg, t);
        RequestDiagnostics rd = null;
        Throwable e = t;
        do {
            if (!(e instanceof RequestDiagnosticsHolder) || ((RequestDiagnosticsHolder)e).getRequestDiagnostics() == null) continue;
            rd = ((RequestDiagnosticsHolder)e).getRequestDiagnostics();
            break;
        } while ((e = e.getCause()) != null);
        if (rd == null) {
            rd = RequestDiagnosticsFactory.newRequestDiagnostics();
        }
        RequestDiagnosticsFactory.fillInRequestContext(rd, req, context, t);
        rd.logAsError();
        req.getSession(true).setAttribute("org.apache.jetspeed.request.RequestDiagnostics", (Object)rd);
        res.sendRedirect(req.getContextPath() + errorHandlerPath);
    }

    protected void cleanupError(HttpServletRequest req) {
        HttpSession session = req.getSession(false);
        if (session != null) {
            session.removeAttribute("org.apache.jetspeed.request.RequestDiagnostics");
        }
    }

    static {
        firstInit = true;
        initFailure = null;
        firstDoGet = true;
    }
}

