/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.engine.servlet;

import java.io.File;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;

public class ServletHelper {
    public static final String CONFIG_NAMESPACE = "org.apache.jetspeed";
    public static final String LOGGING_ROOT_DEFAULT = "/logs";
    public static final String LOGGING_ROOT = "loggingRoot";

    public static String getRealPath(ServletConfig config, String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        } else if (path.startsWith("file:")) {
            return new File(path.substring(5)).getAbsolutePath();
        }
        return new File(config.getServletContext().getRealPath(""), path).getAbsolutePath();
    }

    public static final String findInitParameter(ServletContext context, ServletConfig config, String name, String defaultValue) {
        String path = null;
        boolean usingNamespace = name.startsWith(CONFIG_NAMESPACE);
        while (StringUtils.isEmpty((String)(path = config.getInitParameter(name))) && StringUtils.isEmpty((String)(path = context.getInitParameter(name)))) {
            if (usingNamespace) {
                path = defaultValue;
                break;
            }
            name = "org.apache.jetspeed." + name;
            usingNamespace = true;
        }
        return path;
    }

    public static void createRuntimeDirectories(ServletContext context, ServletConfig config) throws ServletException {
        String path = ServletHelper.findInitParameter(context, config, LOGGING_ROOT, LOGGING_ROOT_DEFAULT);
        File logDir = new File(ServletHelper.getRealPath(config, path));
        if (!logDir.exists() && !logDir.mkdirs()) {
            throw new ServletException("Cannot create directory for logs!");
        }
    }
}

