/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.engine.servlet;

import java.io.IOException;
import java.util.TimeZone;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class StaticResourceCachingFilter
implements Filter {
    private static final String HTTP_HEADER_EXPIRES = "Expires";
    private static final String HTTP_HEADER_CACHE_CONTROL = "Cache-Control";
    private static final String HTTP_HEADER_CACHE_MAX_AGE = "max-age";
    private static final String HTTP_HEADER_CACHE_MAX_AGE_EQ = "max-age=";
    private static String PARAM_EXPIRES_HOURS = "ExpireHours";
    private static final TimeZone GMT_TIME_ZONE = TimeZone.getTimeZone("GMT");
    private double expires_in_hours = 0.0;
    private int max_age = 0;

    public void init(FilterConfig config) {
        try {
            this.expires_in_hours = Double.parseDouble(config.getInitParameter(PARAM_EXPIRES_HOURS));
        }
        catch (NumberFormatException ex) {
            this.expires_in_hours = 0.0;
        }
        this.max_age = (int)(this.expires_in_hours * 3600.0);
    }

    public void doFilter(ServletRequest aRequest, ServletResponse aResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)aRequest;
        HttpServletResponse response = (HttpServletResponse)aResponse;
        if (this.max_age > 0) {
            String cacheControlVal = HTTP_HEADER_CACHE_MAX_AGE_EQ + this.max_age;
            response.setHeader(HTTP_HEADER_CACHE_CONTROL, cacheControlVal);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
    }
}

