/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.healthcheck.validators;

import java.util.List;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.factory.PortletFactory;
import org.apache.jetspeed.healthcheck.validators.HealthCheckValidator;
import org.apache.jetspeed.healthcheck.validators.HealthCheckValidatorResult;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletApplicationAvailableHeathCheckValidator
implements HealthCheckValidator {
    private static final Logger log = LoggerFactory.getLogger(PortletApplicationAvailableHeathCheckValidator.class);
    public static boolean isInfoEnabled = log.isInfoEnabled();
    public static boolean isDebugEnabled = log.isDebugEnabled();
    private int numberOfRetries;
    private long retryDelay;
    private List requiredPortletApplications;
    private PortletRegistry portletRegistry;
    private PortletFactory portletFactory;
    private boolean stopValidationOnError;

    public PortletApplicationAvailableHeathCheckValidator(List requiredPortletApplications, int numberOfRetries, long retryDelay, PortletRegistry portletRegistry, PortletFactory portletFactory, boolean stopValidationOnError) {
        this.requiredPortletApplications = requiredPortletApplications;
        this.numberOfRetries = numberOfRetries;
        this.retryDelay = retryDelay;
        this.portletRegistry = portletRegistry;
        this.portletFactory = portletFactory;
        this.stopValidationOnError = stopValidationOnError;
    }

    public HealthCheckValidatorResult validate() {
        HealthCheckValidatorResult result = new HealthCheckValidatorResult();
        boolean allPAStatus = true;
        StringBuffer messages = new StringBuffer();
        try {
            for (String paName : this.requiredPortletApplications) {
                if (isDebugEnabled) {
                    log.debug("Checking portlet application: " + paName);
                }
                if (messages.length() > 0) {
                    messages.append(LINE_SEPARATOR);
                }
                messages.append(paName + ": ");
                PortletApplication pa = this.portletRegistry.getPortletApplication(paName, true);
                boolean thisPAStatus = this.portletFactory.isPortletApplicationRegistered(pa);
                if (thisPAStatus) {
                    messages.append("is up");
                    continue;
                }
                messages.append("is down");
                allPAStatus = false;
                if (!this.stopValidationOnError) continue;
                break;
            }
            if (!allPAStatus) {
                result.setHealthCheckResult(100);
            }
        }
        catch (Exception e) {
            log.error("Exception while running the portlet application validator", (Throwable)e);
            result.setHealthCheckResult(100);
            messages.append("Exception while running the portlet application validator: " + e.getMessage());
        }
        if (isDebugEnabled) {
            log.debug(messages.toString());
        }
        result.setResultMessage(messages.toString());
        return result;
    }

    public int getNumberOfRetries() {
        return this.numberOfRetries;
    }

    public long getRetryDelay() {
        return this.retryDelay;
    }
}

