/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.layout.impl;

import java.util.List;
import java.util.Map;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.ajax.AJAXException;
import org.apache.jetspeed.ajax.AjaxAction;
import org.apache.jetspeed.ajax.AjaxBuilder;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.layout.PortletActionSecurityBehavior;
import org.apache.jetspeed.layout.impl.Constants;
import org.apache.jetspeed.layout.impl.GetPortletsAction;
import org.apache.jetspeed.layout.impl.MovePortletAction;
import org.apache.jetspeed.layout.impl.NestedFragmentContext;
import org.apache.jetspeed.layout.impl.PortletInfo;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddPortletAction
extends MovePortletAction
implements AjaxAction,
AjaxBuilder,
Constants {
    protected Logger log = LoggerFactory.getLogger(AddPortletAction.class);
    protected GetPortletsAction getPortletsAction = null;
    protected boolean allowDuplicatePortlets = true;

    public AddPortletAction(String template, String errorTemplate, PortletRegistry registry, GetPortletsAction getPortletsAction) throws AJAXException {
        this(template, errorTemplate, registry, null, null, getPortletsAction, true);
    }

    public AddPortletAction(String template, String errorTemplate, PortletRegistry registry, PageManager pageManager, PortletActionSecurityBehavior securityBehavior, GetPortletsAction getPortletsAction) throws AJAXException {
        this(template, errorTemplate, registry, pageManager, securityBehavior, getPortletsAction, true);
    }

    public AddPortletAction(String template, String errorTemplate, PortletRegistry registry, PageManager pageManager, PortletActionSecurityBehavior securityBehavior, GetPortletsAction getPortletsAction, boolean allowDuplicatePortlets) throws AJAXException {
        super(template, errorTemplate, registry, pageManager, securityBehavior);
        this.getPortletsAction = getPortletsAction;
        this.allowDuplicatePortlets = allowDuplicatePortlets;
    }

    protected boolean runAction(RequestContext requestContext, Map resultMap, boolean batch) throws AJAXException {
        boolean success = true;
        String status = "success";
        try {
            ContentFragment fragment;
            resultMap.put("action", "add");
            String portletId = this.getActionParameter(requestContext, "id");
            if (portletId == null) {
                throw new RuntimeException("portlet id not provided");
            }
            resultMap.put("id", portletId);
            this.verifyPortletId(requestContext, portletId);
            if (!this.allowDuplicatePortlets) {
                this.checkForDuplicatePortlet(requestContext, resultMap, portletId);
            }
            String layoutId = this.getActionParameter(requestContext, "layoutid");
            if (!this.checkAccess(requestContext, JetspeedActions.EDIT)) {
                NestedFragmentContext addToFragmentContext = null;
                if (layoutId != null && layoutId.length() > 0) {
                    ContentPage page = requestContext.getPage();
                    fragment = page.getFragmentById(layoutId);
                    if (fragment == null) {
                        success = false;
                        resultMap.put("reason", "Specified layout fragment not found: " + layoutId);
                        return success;
                    }
                    try {
                        addToFragmentContext = new NestedFragmentContext(fragment, page, this.getPortletRegistry());
                    }
                    catch (Exception ex) {
                        this.log.error("Failure to construct nested context for fragment " + layoutId, (Throwable)ex);
                        success = false;
                        resultMap.put("reason", "Cannot construct nested context for specified layout fragment");
                        return success;
                    }
                }
                if (!this.createNewPageOnEdit(requestContext)) {
                    success = false;
                    resultMap.put("reason", "Insufficient access to edit page");
                    return success;
                }
                status = "refresh";
                if (addToFragmentContext != null) {
                    ContentPage newPage = requestContext.getPage();
                    ContentFragment newFragment = null;
                    try {
                        newFragment = addToFragmentContext.getFragmentOnNewPage(newPage, this.getPortletRegistry());
                    }
                    catch (Exception ex) {
                        this.log.error("Failure to locate copy of fragment " + layoutId, (Throwable)ex);
                        success = false;
                        resultMap.put("reason", "Failed to find new fragment for specified layout id: " + layoutId);
                        return success;
                    }
                    layoutId = newFragment.getId();
                }
            }
            ContentPage page = requestContext.getPage();
            ContentFragment placeInLayoutFragment = null;
            if (layoutId != null && layoutId.length() > 0) {
                placeInLayoutFragment = page.getFragmentById(layoutId);
                if (placeInLayoutFragment == null) {
                    throw new Exception("layout id not found: " + layoutId);
                }
            } else {
                placeInLayoutFragment = page.getRootFragment();
            }
            fragment = placeInLayoutFragment.addPortlet("portlet", portletId);
            success = this.placeFragment(requestContext, batch, resultMap, fragment, placeInLayoutFragment);
            resultMap.put("entity", fragment.getId());
            if (success) {
                resultMap.put("status", status);
            }
        }
        catch (Exception e) {
            this.log.error("exception while adding a portlet", (Throwable)e);
            resultMap.put("reason", e.toString());
            success = false;
        }
        return success;
    }

    protected void verifyPortletId(RequestContext requestContext, String portletId) throws Exception {
        List portletList = this.getPortletsAction.retrievePortlets(requestContext, null);
        if (portletList != null) {
            for (int i = 0; i < portletList.size(); ++i) {
                PortletInfo portletInfo = (PortletInfo)portletList.get(i);
                if (portletInfo == null || !portletInfo.getName().equalsIgnoreCase(portletId)) continue;
                return;
            }
        }
        throw new Exception(portletId + " is not a valid portlet or not allowed for this user");
    }

    protected void checkForDuplicatePortlet(RequestContext requestContext, Map resultMap, String portletId) throws AJAXException {
        ContentPage page = requestContext.getPage();
        boolean duplicateFound = this.isDuplicateFragment(page.getRootFragment(), portletId);
        if (duplicateFound) {
            throw new AJAXException(portletId + " is already on the page, duplicates are not allowed");
        }
    }

    protected boolean isDuplicateFragment(ContentFragment fragment, String portletId) {
        if (fragment != null) {
            String fragmentName = fragment.getName();
            if (fragmentName.equals(portletId)) {
                return true;
            }
            List childFragments = fragment.getFragments();
            if (childFragments != null) {
                for (int i = 0; i < childFragments.size(); ++i) {
                    if (!this.isDuplicateFragment((ContentFragment)childFragments.get(i), portletId)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

