/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.layout.impl;

import java.util.Map;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.ajax.AjaxAction;
import org.apache.jetspeed.ajax.AjaxBuilder;
import org.apache.jetspeed.layout.PortletActionSecurityBehavior;
import org.apache.jetspeed.layout.impl.BaseGetResourceAction;
import org.apache.jetspeed.layout.impl.Constants;
import org.apache.jetspeed.om.common.SecuredResource;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetFolderAction
extends BaseGetResourceAction
implements AjaxAction,
AjaxBuilder,
Constants {
    protected Logger log = LoggerFactory.getLogger(GetFolderAction.class);

    public GetFolderAction(String template, String errorTemplate, PageManager pageManager, PortletActionSecurityBehavior securityBehavior) {
        super(template, errorTemplate, pageManager, securityBehavior);
    }

    public boolean run(RequestContext requestContext, Map resultMap) {
        boolean success = true;
        String status = "success";
        try {
            resultMap.put("action", "getfolder");
            if (!this.checkAccess(requestContext, JetspeedActions.VIEW)) {
                success = false;
                resultMap.put("reason", "Insufficient access to get portlets");
                return success;
            }
            Folder folder = this.retrieveFolder(requestContext);
            resultMap.put("status", status);
            resultMap.put("folder", folder);
            this.putSecurityInformation(resultMap, (SecuredResource)folder);
        }
        catch (Exception e) {
            this.log.error("exception while getting folder info", (Throwable)e);
            success = false;
        }
        return success;
    }

    protected Folder retrieveFolder(RequestContext requestContext) throws Exception {
        String folderName = this.getActionParameter(requestContext, "folder");
        if (folderName == null) {
            folderName = "/";
        }
        Folder folder = this.pageManager.getFolder(folderName);
        return folder;
    }
}

