/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.layout.impl;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.ajax.AjaxAction;
import org.apache.jetspeed.ajax.AjaxBuilder;
import org.apache.jetspeed.layout.PortletActionSecurityBehavior;
import org.apache.jetspeed.layout.impl.BasePortletAction;
import org.apache.jetspeed.layout.impl.Constants;
import org.apache.jetspeed.page.document.NodeNotFoundException;
import org.apache.jetspeed.portalsite.Menu;
import org.apache.jetspeed.portalsite.PortalSiteRequestContext;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetMenusAction
extends BasePortletAction
implements AjaxAction,
AjaxBuilder,
Constants {
    protected static final Logger log = LoggerFactory.getLogger(GetMenusAction.class);

    public GetMenusAction(String template, String errorTemplate, PortletActionSecurityBehavior securityBehavior) {
        super(template, errorTemplate, securityBehavior);
    }

    public boolean run(RequestContext requestContext, Map resultMap) {
        boolean success = true;
        String status = "success";
        try {
            resultMap.put("action", "getmenus");
            if (!this.checkAccess(requestContext, JetspeedActions.VIEW)) {
                success = false;
                resultMap.put("reason", "Insufficient access to get menus");
                return success;
            }
            PortalSiteRequestContext siteRequestContext = (PortalSiteRequestContext)requestContext.getAttribute("org.apache.jetspeed.portalsite.PortalSiteRequestContext");
            if (siteRequestContext == null) {
                success = false;
                resultMap.put("reason", "Missing portal site request context from ProfilerValve");
                return success;
            }
            Set standardMenuNames = siteRequestContext.getStandardMenuNames();
            Set customMenuNames = null;
            try {
                customMenuNames = siteRequestContext.getCustomMenuNames();
            }
            catch (NodeNotFoundException nnfe) {
                // empty catch block
            }
            resultMap.put("standardMenus", standardMenuNames);
            resultMap.put("customMenus", customMenuNames);
            String includeMenuDefinitions = this.getActionParameter(requestContext, "includeMenuDefs");
            if (includeMenuDefinitions != null && includeMenuDefinitions.toLowerCase().equals("true")) {
                Menu menuDefinition;
                Locale locale = requestContext.getLocale();
                HashMap<String, Menu> menuDefinitionsMap = new HashMap<String, Menu>();
                StringBuffer failReason = new StringBuffer();
                for (String menuName : standardMenuNames) {
                    menuDefinition = this.getMenuDefinition(menuName, siteRequestContext, failReason);
                    if (menuDefinition == null) continue;
                    menuDefinitionsMap.put(menuName, menuDefinition);
                }
                for (String menuName : customMenuNames) {
                    menuDefinition = this.getMenuDefinition(menuName, siteRequestContext, failReason);
                    if (menuDefinition == null) continue;
                    menuDefinitionsMap.put(menuName, menuDefinition);
                }
                if (failReason.length() > 0) {
                    success = false;
                    resultMap.put("reason", failReason.toString());
                    return success;
                }
                resultMap.put("includeMenuDefs", new Boolean(true));
                resultMap.put("menuDefinitions", menuDefinitionsMap);
                resultMap.put("menuContext", siteRequestContext);
                resultMap.put("menuLocale", locale);
            } else {
                resultMap.put("includeMenuDefs", new Boolean(false));
            }
            resultMap.put("status", status);
        }
        catch (Exception e) {
            log.error("Exception while getting page menus info", (Throwable)e);
            success = false;
        }
        return success;
    }

    private Menu getMenuDefinition(String menuName, PortalSiteRequestContext siteRequestContext, StringBuffer failReason) {
        Menu menuDefinition = null;
        try {
            menuDefinition = siteRequestContext.getMenu(menuName);
        }
        catch (NodeNotFoundException nnfe) {
            // empty catch block
        }
        if (menuDefinition == null && failReason != null) {
            if (failReason.length() == 0) {
                failReason.append("Unable to lookup specified menus: ").append(menuName);
            } else {
                failReason.append(", ").append(menuName);
            }
        }
        return menuDefinition;
    }
}

