/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.layout.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.ajax.AjaxAction;
import org.apache.jetspeed.ajax.AjaxBuilder;
import org.apache.jetspeed.layout.PortletActionSecurityBehavior;
import org.apache.jetspeed.layout.impl.BasePortletAction;
import org.apache.jetspeed.layout.impl.Constants;
import org.apache.jetspeed.layout.impl.GetPortletsAction;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetPagesAction
extends BasePortletAction
implements AjaxAction,
AjaxBuilder,
Constants,
Comparator {
    protected static final Logger log = LoggerFactory.getLogger(GetPortletsAction.class);

    public GetPagesAction(String template, String errorTemplate, PageManager pageManager, PortletActionSecurityBehavior securityBehavior) {
        super(template, errorTemplate, pageManager, securityBehavior);
    }

    public boolean run(RequestContext requestContext, Map resultMap) {
        boolean success = true;
        String status = "success";
        try {
            resultMap.put("action", "getpages");
            if (!this.checkAccess(requestContext, JetspeedActions.VIEW)) {
                success = false;
                resultMap.put("reason", "Insufficient access to get portlets");
                return success;
            }
            List pages = this.retrievePages(requestContext);
            resultMap.put("status", status);
            resultMap.put("pages", pages);
        }
        catch (Exception e) {
            log.error("exception while getting portlet info", (Throwable)e);
            success = false;
        }
        return success;
    }

    protected List retrievePages(RequestContext requestContext) {
        ArrayList<Page> list = new ArrayList<Page>();
        String folderName = this.getActionParameter(requestContext, "folder");
        if (folderName == null) {
            return list;
        }
        try {
            Folder folder = this.pageManager.getFolder(folderName);
            for (Page page : folder.getPages()) {
                list.add(page);
            }
            Collections.sort(list, this);
        }
        catch (Exception e) {
            // empty catch block
        }
        return list;
    }

    public int compare(Object obj1, Object obj2) {
        Page page1 = (Page)obj1;
        Page page2 = (Page)obj2;
        String name1 = page1.getName();
        String name2 = page2.getName();
        name1 = name1 == null ? "unknown" : name1;
        name2 = name2 == null ? "unknown" : name2;
        return name1.compareTo(name2);
    }
}

