/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.layout.impl;

import java.util.Map;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.ajax.AjaxAction;
import org.apache.jetspeed.ajax.AjaxBuilder;
import org.apache.jetspeed.decoration.DecorationFactory;
import org.apache.jetspeed.layout.PortletActionSecurityBehavior;
import org.apache.jetspeed.layout.impl.BasePortletAction;
import org.apache.jetspeed.layout.impl.Constants;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetThemesAction
extends BasePortletAction
implements AjaxAction,
AjaxBuilder,
Constants {
    protected static final Logger log = LoggerFactory.getLogger(GetThemesAction.class);
    protected DecorationFactory decorationFactory;

    public GetThemesAction(String template, String errorTemplate, DecorationFactory decorationFactory, PortletActionSecurityBehavior securityBehavior) {
        super(template, errorTemplate, securityBehavior);
        this.decorationFactory = decorationFactory;
    }

    public boolean run(RequestContext requestContext, Map resultMap) {
        boolean success = true;
        String status = "success";
        try {
            resultMap.put("action", "getthemes");
            if (!this.checkAccess(requestContext, JetspeedActions.VIEW)) {
                success = false;
                resultMap.put("reason", "Insufficient access to get themes");
                return success;
            }
            String type = this.getActionParameter(requestContext, "type");
            String format = this.getActionParameter(requestContext, "format");
            if (format == null) {
                format = "xml";
            }
            if (type == null || type.equals("pageDecorations")) {
                resultMap.put("pageDecorations", this.decorationFactory.getPageDecorations(requestContext));
            }
            if (type == null || type.equals("portletDecorations")) {
                resultMap.put("portletDecorations", this.decorationFactory.getPortletDecorations(requestContext));
            }
            if (type == null || type.equals("layouts")) {
                resultMap.put("layouts", this.decorationFactory.getLayouts(requestContext));
            }
            if (type == null || type.equals("desktopPageDecorations")) {
                resultMap.put("desktopPageDecorations", this.decorationFactory.getDesktopPageDecorations(requestContext));
            }
            if (type == null || type.equals("desktopPortletDecorations")) {
                resultMap.put("desktopPortletDecorations", this.decorationFactory.getDesktopPortletDecorations(requestContext));
            }
            resultMap.put("type", type);
            resultMap.put("format", format);
            resultMap.put("status", status);
        }
        catch (Exception e) {
            log.error("exception while getting theme info", (Throwable)e);
            success = false;
        }
        return success;
    }
}

