/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.layout.impl;

import java.util.Map;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.ajax.AJAXException;
import org.apache.jetspeed.ajax.AjaxAction;
import org.apache.jetspeed.ajax.AjaxBuilder;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.layout.Coordinate;
import org.apache.jetspeed.layout.PortletActionSecurityBehavior;
import org.apache.jetspeed.layout.PortletPlacementContext;
import org.apache.jetspeed.layout.PortletPlacementException;
import org.apache.jetspeed.layout.impl.BasePortletAction;
import org.apache.jetspeed.layout.impl.Constants;
import org.apache.jetspeed.layout.impl.CoordinateImpl;
import org.apache.jetspeed.layout.impl.NestedFragmentContext;
import org.apache.jetspeed.layout.impl.PortletPlacementContextImpl;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.document.NodeException;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MovePortletAction
extends BasePortletAction
implements AjaxAction,
AjaxBuilder,
Constants {
    protected static final Logger log = LoggerFactory.getLogger(MovePortletAction.class);
    protected static final String eol = System.getProperty("line.separator");
    private PortletRegistry registry;
    private int iMoveType = -1;
    private String sMoveType = null;

    public MovePortletAction(String template, String errorTemplate, PortletRegistry registry, String sMoveType) throws AJAXException {
        this(template, errorTemplate, registry, sMoveType, null, null);
    }

    public MovePortletAction(String template, String errorTemplate, PortletRegistry registry, PageManager pageManager, PortletActionSecurityBehavior securityBehavior) throws AJAXException {
        this(template, errorTemplate, registry, "moveabs", pageManager, securityBehavior);
    }

    public MovePortletAction(String template, String errorTemplate, PortletRegistry registry, String sMoveType, PageManager pageManager, PortletActionSecurityBehavior securityBehavior) throws AJAXException {
        super(template, errorTemplate, pageManager, securityBehavior);
        this.setMoveType(sMoveType);
        this.registry = registry;
    }

    public void setMoveType(String p_sMoveType) throws AJAXException {
        this.sMoveType = p_sMoveType;
        if (p_sMoveType.equalsIgnoreCase("moveabs")) {
            this.iMoveType = 1;
        } else if (p_sMoveType.equalsIgnoreCase("moveup")) {
            this.iMoveType = 2;
        } else if (p_sMoveType.equalsIgnoreCase("movedown")) {
            this.iMoveType = 3;
        } else if (p_sMoveType.equalsIgnoreCase("moveleft")) {
            this.iMoveType = 4;
        } else if (p_sMoveType.equalsIgnoreCase("moveright")) {
            this.iMoveType = 5;
        } else if (p_sMoveType.equalsIgnoreCase("move")) {
            this.iMoveType = 6;
        } else {
            throw new AJAXException("invalid move type of:" + p_sMoveType);
        }
    }

    public boolean runBatch(RequestContext requestContext, Map resultMap) throws AJAXException {
        return this.runAction(requestContext, resultMap, true);
    }

    public boolean run(RequestContext requestContext, Map resultMap) throws AJAXException {
        return this.runAction(requestContext, resultMap, false);
    }

    protected boolean runAction(RequestContext requestContext, Map resultMap, boolean batch) throws AJAXException {
        boolean success = true;
        String status = "success";
        try {
            ContentPage page;
            resultMap.put("action", this.sMoveType);
            String moveFragmentId = this.getActionParameter(requestContext, "id");
            String layoutId = this.getActionParameter(requestContext, "layoutid");
            if (moveFragmentId == null) {
                throw new Exception("id not provided; must specify portlet or layout id");
            }
            resultMap.put("id", moveFragmentId);
            ContentFragment currentLayoutFragment = null;
            ContentFragment moveToLayoutFragment = null;
            if (layoutId != null && layoutId.length() > 0 && this.iMoveType != 6) {
                page = requestContext.getPage();
                currentLayoutFragment = page.getFragmentById(layoutId);
                if (currentLayoutFragment == null) {
                    throw new Exception("layout id not found: " + layoutId);
                }
                moveToLayoutFragment = currentLayoutFragment;
                for (ContentFragment childFrag : moveToLayoutFragment.getFragments()) {
                    if (childFrag == null || !moveFragmentId.equals(childFrag.getId())) continue;
                    moveToLayoutFragment = null;
                    break;
                }
                if (moveToLayoutFragment != null) {
                    ContentFragment root = requestContext.getPage().getRootFragment();
                    currentLayoutFragment = this.getParentFragmentById(moveFragmentId, root);
                }
                if (currentLayoutFragment == null) {
                    throw new Exception("parent layout id not found for portlet id:" + moveFragmentId);
                }
            }
            if (!this.checkAccess(requestContext, JetspeedActions.EDIT)) {
                if (!this.isPageQualifiedForCreateNewPageOnEdit(requestContext)) {
                    success = false;
                    resultMap.put("reason", "Page is not qualified for create-new-page-on-edit");
                    return success;
                }
                page = requestContext.getPage();
                ContentFragment fragment = page.getFragmentById(moveFragmentId);
                if (fragment == null) {
                    success = false;
                    resultMap.put("reason", "Fragment not found");
                    return success;
                }
                NestedFragmentContext moveFragmentContext = null;
                NestedFragmentContext moveToFragmentContext = null;
                try {
                    moveFragmentContext = new NestedFragmentContext(fragment, page, this.registry);
                    if (moveToLayoutFragment != null) {
                        moveToFragmentContext = new NestedFragmentContext(moveToLayoutFragment, page, this.registry);
                    }
                }
                catch (Exception ex) {
                    log.error("Failure to construct nested context for fragment " + moveFragmentId, (Throwable)ex);
                    success = false;
                    resultMap.put("reason", "Cannot construct nested context for fragment");
                    return success;
                }
                if (!this.createNewPageOnEdit(requestContext)) {
                    success = false;
                    resultMap.put("reason", "Insufficient access to edit page");
                    return success;
                }
                status = "refresh";
                ContentPage newPage = requestContext.getPage();
                ContentFragment newPageRootFragment = newPage.getRootFragment();
                ContentFragment newFragment = null;
                try {
                    newFragment = moveFragmentContext.getFragmentOnNewPage(newPage, this.registry);
                }
                catch (Exception ex) {
                    log.error("Failure to locate copy of fragment " + moveFragmentId, (Throwable)ex);
                    success = false;
                    resultMap.put("reason", "Failed to find new fragment for portlet id: " + moveFragmentId);
                    return success;
                }
                moveFragmentId = newFragment.getId();
                currentLayoutFragment = this.getParentFragmentById(moveFragmentId, newPageRootFragment);
                if (currentLayoutFragment == null) {
                    success = false;
                    resultMap.put("reason", "Failed to find parent layout for copied fragment " + moveFragmentId);
                    return success;
                }
                if (moveToLayoutFragment != null) {
                    ContentFragment newMoveToFragment = null;
                    try {
                        newMoveToFragment = moveToFragmentContext.getFragmentOnNewPage(newPage, this.registry);
                    }
                    catch (Exception ex) {
                        log.error("Failure to locate copy of destination fragment " + moveToLayoutFragment.getId(), (Throwable)ex);
                        success = false;
                        resultMap.put("reason", "Failed to find copy of destination fragment");
                        return success;
                    }
                    moveToLayoutFragment = newMoveToFragment;
                }
            }
            if (moveToLayoutFragment != null) {
                success = this.moveToOtherLayoutFragment(requestContext, batch, resultMap, moveFragmentId, moveToLayoutFragment, currentLayoutFragment);
            } else {
                ContentFragment fragment;
                PortletPlacementContextImpl placement = null;
                ContentPage page2 = requestContext.getPage();
                if (currentLayoutFragment == null) {
                    currentLayoutFragment = this.getParentFragmentById(moveFragmentId, page2.getRootFragment());
                }
                if ((fragment = (placement = currentLayoutFragment != null ? new PortletPlacementContextImpl(page2, this.registry, currentLayoutFragment) : new PortletPlacementContextImpl(page2, this.registry)).getFragmentById(moveFragmentId)) == null) {
                    success = false;
                    resultMap.put("reason", "Failed to find fragment for portlet id: " + moveFragmentId);
                    return success;
                }
                success = this.moveInFragment(requestContext, placement, fragment, false, resultMap, batch);
            }
            if (success) {
                resultMap.put("status", status);
            }
        }
        catch (Exception e) {
            log.error("exception while moving a portlet", (Throwable)e);
            resultMap.put("reason", e.toString());
            success = false;
        }
        return success;
    }

    protected boolean moveInFragment(RequestContext requestContext, PortletPlacementContext placement, ContentFragment fragment, boolean addFragment, Map resultMap, boolean batch) throws PortletPlacementException, NodeException, AJAXException {
        boolean success = true;
        String moveFragmentId = fragment.getId();
        Coordinate returnCoordinate = null;
        float oldX = 0.0f;
        float oldY = 0.0f;
        float oldZ = 0.0f;
        float oldWidth = 0.0f;
        float oldHeight = 0.0f;
        float x = -1.0f;
        float y = -1.0f;
        float z = -1.0f;
        float width = -1.0f;
        float height = -1.0f;
        boolean absHeightChanged = false;
        String posExtended = this.getActionParameter(requestContext, "jsdesktop");
        if (posExtended != null) {
            String oldDeskExt = fragment.getProperty("jsdesktop");
            resultMap.put("oldjsdesktop", oldDeskExt != null ? oldDeskExt : "");
            fragment.updateProperty("jsdesktop", posExtended);
        }
        if (this.iMoveType == 1) {
            Coordinate newCoordinate = this.getCoordinateFromParams(requestContext);
            returnCoordinate = placement.moveAbsolute(fragment, newCoordinate, addFragment);
            String sHeight = this.getActionParameter(requestContext, "height");
            if (sHeight != null && sHeight.length() > 0) {
                oldHeight = fragment.getLayoutHeight();
                height = Float.parseFloat(sHeight);
                absHeightChanged = true;
            }
            fragment.updatePosition(-1.0f, -1.0f, -1.0f, -1.0f, height);
        } else if (this.iMoveType == 4) {
            returnCoordinate = placement.moveLeft(fragment);
        } else if (this.iMoveType == 5) {
            returnCoordinate = placement.moveRight(fragment);
        } else if (this.iMoveType == 2) {
            returnCoordinate = placement.moveUp(fragment);
        } else if (this.iMoveType == 3) {
            returnCoordinate = placement.moveDown(fragment);
        } else if (this.iMoveType == 6) {
            String sx = this.getActionParameter(requestContext, "x");
            String sy = this.getActionParameter(requestContext, "y");
            String sz = this.getActionParameter(requestContext, "z");
            String sWidth = this.getActionParameter(requestContext, "width");
            String sHeight = this.getActionParameter(requestContext, "height");
            if (sx != null) {
                oldX = fragment.getLayoutX();
                x = Float.parseFloat(sx);
            }
            if (sy != null) {
                oldY = fragment.getLayoutY();
                y = Float.parseFloat(sy);
            }
            if (sz != null) {
                oldZ = fragment.getLayoutZ();
                z = Float.parseFloat(sz);
            }
            if (sWidth != null) {
                oldWidth = fragment.getLayoutWidth();
                width = Float.parseFloat(sWidth);
            }
            if (sHeight != null) {
                oldHeight = fragment.getLayoutHeight();
                height = Float.parseFloat(sHeight);
            }
            fragment.updatePosition(x, y, z, width, height);
        }
        ContentPage page = placement.syncPageFragments();
        if (this.iMoveType == 6) {
            this.putCartesianResult(resultMap, x, oldX, "x", "oldx");
            this.putCartesianResult(resultMap, y, oldY, "y", "oldy");
            this.putCartesianResult(resultMap, z, oldZ, "z", "oldz");
            this.putCartesianResult(resultMap, width, oldWidth, "width", "oldwidth");
            this.putCartesianResult(resultMap, height, oldHeight, "height", "oldheight");
        } else {
            resultMap.put("oldcol", String.valueOf(returnCoordinate.getOldCol()));
            resultMap.put("oldrow", String.valueOf(returnCoordinate.getOldRow()));
            resultMap.put("newcol", String.valueOf(returnCoordinate.getNewCol()));
            resultMap.put("newrow", String.valueOf(returnCoordinate.getNewRow()));
            if (absHeightChanged) {
                this.putCartesianResult(resultMap, height, oldHeight, "height", "oldheight");
            }
        }
        resultMap.put("id", moveFragmentId);
        return success;
    }

    protected boolean moveToOtherLayoutFragment(RequestContext requestContext, boolean batch, Map resultMap, String moveFragmentId, ContentFragment moveToLayoutFragment, ContentFragment removeFromLayoutFragment) throws PortletPlacementException, NodeException, AJAXException {
        boolean success = true;
        ContentFragment placeFragment = null;
        if (removeFromLayoutFragment != null) {
            ContentPage page = requestContext.getPage();
            PortletPlacementContextImpl placement = new PortletPlacementContextImpl(page, this.registry, removeFromLayoutFragment);
            placeFragment = placement.getFragmentById(moveFragmentId);
            if (placeFragment == null) {
                success = false;
                resultMap.put("reason", "Failed to find fragment to move to another layout for fragment id: " + moveFragmentId);
                return success;
            }
            placement.remove(placeFragment);
            page = placement.syncPageFragments();
            page.moveFragment(placeFragment.getId(), removeFromLayoutFragment.getId(), moveToLayoutFragment.getId());
        }
        if (placeFragment != null) {
            resultMap.put("entity", placeFragment.getId());
            return this.placeFragment(requestContext, batch, resultMap, placeFragment, moveToLayoutFragment);
        }
        return success;
    }

    protected boolean placeFragment(RequestContext requestContext, boolean batch, Map resultMap, ContentFragment placeFragment, ContentFragment placeInLayoutFragment) throws PortletPlacementException, NodeException, AJAXException {
        boolean success = true;
        if (placeFragment == null) {
            success = false;
            return success;
        }
        ContentPage page = requestContext.getPage();
        PortletPlacementContextImpl placement = new PortletPlacementContextImpl(page, this.registry, placeInLayoutFragment, placeFragment);
        success = this.moveInFragment(requestContext, placement, placeFragment, true, resultMap, batch);
        return success;
    }

    protected Coordinate getCoordinateFromParams(RequestContext requestContext) {
        String a_sCol = this.getActionParameter(requestContext, "col");
        String a_sRow = this.getActionParameter(requestContext, "row");
        int a_iCol = 0;
        int a_iRow = 0;
        if (a_sCol != null) {
            a_iCol = Integer.parseInt(a_sCol);
        }
        if (a_sRow != null) {
            a_iRow = Integer.parseInt(a_sRow);
        }
        CoordinateImpl a_oCoordinate = new CoordinateImpl(0, 0, a_iCol, a_iRow);
        return a_oCoordinate;
    }

    protected void putCartesianResult(Map resultMap, float value, float oldValue, String name, String oldName) {
        if (value != -1.0f) {
            resultMap.put(oldName, new Float(oldValue));
            resultMap.put(name, new Float(value));
        }
    }

    protected PortletRegistry getPortletRegistry() {
        return this.registry;
    }
}

