/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.layout.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.layout.PortletPlacementException;
import org.apache.jetspeed.layout.impl.CoordinateImpl;
import org.apache.jetspeed.layout.impl.PortletPlacementContextImpl;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NestedFragmentContext {
    protected static final Logger log = LoggerFactory.getLogger(NestedFragmentContext.class);
    protected static final String eol = System.getProperty("line.separator");
    private ContentFragment targetFragment;
    private ContentFragment rootFragment;
    private ContentPage page;
    private List fragmentLevels;

    public NestedFragmentContext(ContentFragment targetFragment, ContentPage page, PortletRegistry registry) throws PortletPlacementException {
        this.targetFragment = targetFragment;
        this.page = page;
        this.rootFragment = page.getRootFragment();
        this.init(registry);
    }

    protected void init(PortletRegistry registry) throws PortletPlacementException {
        ArrayList<NestedFragmentLevel> nestedFragmentLevels = new ArrayList<NestedFragmentLevel>();
        ContentFragment nextTarget = this.targetFragment;
        ContentFragment nextParent = null;
        do {
            if ((nextParent = NestedFragmentContext.getParentFragmentById(nextTarget.getId(), this.rootFragment)) != null) {
                NestedFragmentLevel level = new NestedFragmentLevel(nextTarget, nextParent, registry);
                nestedFragmentLevels.add(level);
                nextTarget = nextParent;
                continue;
            }
            if (!nextTarget.getId().equals(this.rootFragment.getId())) {
                throw new PortletPlacementException("Cannot determine complete nested structure for fragment " + this.targetFragment.getId());
            }
            nextTarget = null;
        } while (nextTarget != null);
        this.fragmentLevels = nestedFragmentLevels;
    }

    public ContentFragment getFragmentOnNewPage(ContentPage newPage, PortletRegistry registry) throws PortletPlacementException {
        ContentFragment newPageRootFragment = newPage.getRootFragment();
        int depth = this.fragmentLevels.size();
        ContentFragment nextFragment = newPageRootFragment;
        for (int i = depth - 1; i >= 0; --i) {
            NestedFragmentLevel level = (NestedFragmentLevel)this.fragmentLevels.get(i);
            PortletPlacementContextImpl placement = new PortletPlacementContextImpl(newPage, registry, nextFragment);
            try {
                nextFragment = placement.getFragmentAtOldCoordinate(new CoordinateImpl(level.getChildCol(), level.getChildRow()));
            }
            catch (PortletPlacementException ppex) {
                log.error("getFragmentOnNewPage failure to locate fragment on new page (index=" + i + ") :" + eol + this.toString() + (placement != null ? eol + placement.dumpFragments(null) : "") + eol, (Throwable)ppex);
                throw ppex;
            }
            catch (RuntimeException ex) {
                log.error("getFragmentOnNewPage failure to locate fragment on new page (index=" + i + ") :" + eol + this.toString() + (placement != null ? eol + placement.dumpFragments(null) : "") + eol, (Throwable)ex);
                throw ex;
            }
            if (nextFragment != null) continue;
            throw new PortletPlacementException("Cannot locate copy of fragment " + this.targetFragment.getId() + " in the new page structure :" + eol + this.toString() + (placement != null ? eol + placement.dumpFragments(null) : ""));
        }
        return nextFragment;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        int depth = this.fragmentLevels.size();
        int ldepth = 0;
        for (int i = depth - 1; i >= 0; --i) {
            NestedFragmentLevel level = (NestedFragmentLevel)this.fragmentLevels.get(i);
            if (ldepth > 0) {
                out.append(eol);
                for (int j = 0; j < ldepth; ++j) {
                    out.append("   ");
                }
            }
            ++ldepth;
            out.append(level.toString());
        }
        return out.toString();
    }

    public static ContentFragment getParentFragmentById(String id, ContentFragment parent) {
        if (id == null) {
            return null;
        }
        ContentFragment matchedParent = null;
        if (parent != null) {
            List children = parent.getFragments();
            int cSize = children.size();
            for (int i = 0; i < cSize; ++i) {
                ContentFragment childFrag = (ContentFragment)children.get(i);
                if (childFrag == null) continue;
                if (id.equals(childFrag.getId())) {
                    matchedParent = parent;
                    break;
                }
                matchedParent = NestedFragmentContext.getParentFragmentById(id, childFrag);
                if (matchedParent != null) break;
            }
        }
        return matchedParent;
    }

    class NestedFragmentLevel {
        private int childRow;
        private int childCol;
        private ContentFragment child;
        private ContentFragment parent;

        NestedFragmentLevel(ContentFragment child, ContentFragment parent, PortletRegistry registry) throws PortletPlacementException {
            this.child = child;
            this.parent = parent;
            PortletPlacementContextImpl placement = new PortletPlacementContextImpl(NestedFragmentContext.this.page, registry, parent);
            this.childRow = placement.getFragmentRow(child);
            this.childCol = placement.getFragmentCol(child);
        }

        protected int getChildRow() {
            return this.childRow;
        }

        protected int getChildCol() {
            return this.childCol;
        }

        protected ContentFragment getChild() {
            return this.child;
        }

        protected ContentFragment getParent() {
            return this.parent;
        }

        public String toString() {
            return this.child.getType() + " col=" + this.childCol + " row=" + this.childRow + " id=" + this.child.getId() + " parent-id=" + this.parent.getId();
        }
    }
}

