/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.layout.impl;

import java.security.Principal;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.administration.PortalConfiguration;
import org.apache.jetspeed.layout.PortletActionSecurityBehavior;
import org.apache.jetspeed.layout.impl.PortletActionSecurityPathBehavior;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.pipeline.valve.PageProfilerValve;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletActionSecurityConstraintsBehavior
extends PortletActionSecurityPathBehavior
implements PortletActionSecurityBehavior {
    protected Logger log = LoggerFactory.getLogger(PortletActionSecurityConstraintsBehavior.class);
    protected String guest = "guest";

    public PortletActionSecurityConstraintsBehavior(PageManager pageManager, PageProfilerValve profilerValve) {
        this(pageManager, profilerValve, Boolean.FALSE);
    }

    public PortletActionSecurityConstraintsBehavior(PageManager pageManager, PageProfilerValve profilerValve, Boolean enableCreateUserPagesFromRolesOnEdit) {
        super(pageManager, profilerValve, enableCreateUserPagesFromRolesOnEdit);
        PortalConfiguration config = Jetspeed.getConfiguration();
        if (config != null) {
            this.guest = config.getString("default.user.principal");
        }
    }

    public boolean checkAccess(RequestContext context, String action) {
        ContentPage page = context.getPage();
        try {
            page.checkAccess(action);
        }
        catch (Exception e) {
            Principal principal = context.getRequest().getUserPrincipal();
            String userName = this.guest;
            if (principal != null) {
                userName = principal.getName();
            }
            this.log.warn("Insufficient access to page " + page.getPath() + " by user " + userName);
            return false;
        }
        return true;
    }
}

