/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.layout.impl;

import java.util.Map;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.Fragment;
import org.apache.jetspeed.om.portlet.InitParam;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletPlacementMetadataAccess {
    private static Logger log = LoggerFactory.getLogger(PortletPlacementMetadataAccess.class);

    public static int getColumnCountAndSizes(Object layoutFragment, PortletRegistry registry, Map fragSizes) {
        return PortletPlacementMetadataAccess.getColumnCountAndSizes(layoutFragment, registry, fragSizes, false);
    }

    public static int getColumnCountAndSizes(Object layoutFragment, PortletRegistry registry, Map fragSizes, boolean suppressErrorLogging) {
        if (!(layoutFragment instanceof ContentFragment) && !(layoutFragment instanceof Fragment)) {
            throw new NullPointerException("getColumnCountAndSizes cannot accept a null or non Fragment argument");
        }
        if (registry == null) {
            throw new NullPointerException("getColumnCountAndSizes cannot accept a null PortletRegistry argument");
        }
        int columnCount = -1;
        if (!"layout".equals(PortletPlacementMetadataAccess.getType(layoutFragment))) {
            if (!suppressErrorLogging) {
                log.error("getColumnCountAndSizes not a layout fragment - " + PortletPlacementMetadataAccess.getId(layoutFragment) + " type=" + PortletPlacementMetadataAccess.getType(layoutFragment));
            }
        } else {
            String sizesVal = PortletPlacementMetadataAccess.getProperty(layoutFragment, "sizes");
            String layoutName = PortletPlacementMetadataAccess.getName(layoutFragment);
            layoutName = layoutName != null && layoutName.length() > 0 ? layoutName : (String)null;
            PortletDefinition portletDef = null;
            if ((sizesVal == null || sizesVal.length() == 0) && layoutName != null && (portletDef = registry.getPortletDefinitionByUniqueName(layoutName, true)) != null) {
                InitParam sizesParam = portletDef.getInitParam("sizes");
                String string = sizesVal = sizesParam == null ? null : sizesParam.getParamValue();
            }
            if (sizesVal != null && sizesVal.length() > 0) {
                if (fragSizes != null) {
                    fragSizes.put(PortletPlacementMetadataAccess.getId(layoutFragment), sizesVal);
                }
                int sepPos = -1;
                int startPos = 0;
                int sizesLen = sizesVal.length();
                columnCount = 0;
                do {
                    if ((sepPos = sizesVal.indexOf(44, startPos)) != -1) {
                        if (sepPos > startPos) {
                            ++columnCount;
                        }
                        startPos = sepPos + 1;
                        continue;
                    }
                    if (startPos >= sizesLen) continue;
                    ++columnCount;
                } while (startPos < sizesLen && sepPos != -1);
                if (!suppressErrorLogging && columnCount <= 0) {
                    log.error("getColumnCountAndSizes invalid columnCount - " + PortletPlacementMetadataAccess.getId(layoutFragment) + " / " + layoutName + " count=" + columnCount + " sizes=" + sizesVal);
                }
            } else if (portletDef == null || portletDef.getInitParams().isEmpty()) {
                if (!suppressErrorLogging) {
                    if (layoutName == null) {
                        log.error("getColumnCountAndSizes null sizes, null layoutName - " + PortletPlacementMetadataAccess.getId(layoutFragment));
                    } else if (portletDef == null) {
                        log.error("getColumnCountAndSizes null sizes, null PortletDefinition - " + PortletPlacementMetadataAccess.getId(layoutFragment) + " / " + layoutName);
                    } else {
                        log.error("getColumnCountAndSizes null sizes, null ParameterSet - " + PortletPlacementMetadataAccess.getId(layoutFragment) + " / " + layoutName);
                    }
                }
            } else {
                String colsParamVal;
                InitParam colsParam = portletDef.getInitParam("columns");
                String string = colsParamVal = colsParam == null ? null : colsParam.getParamValue();
                if (colsParamVal != null && colsParamVal.length() > 0) {
                    try {
                        columnCount = Integer.parseInt(colsParamVal);
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                    if (columnCount < 1) {
                        columnCount = 2;
                    }
                    switch (columnCount) {
                        case 1: {
                            sizesVal = "100%";
                            break;
                        }
                        case 2: {
                            sizesVal = "50%,50%";
                            break;
                        }
                        case 3: {
                            sizesVal = "34%,33%,33%";
                            break;
                        }
                        case 4: {
                            sizesVal = "25%,25%,25%,25%";
                            break;
                        }
                        default: {
                            sizesVal = "50%,50%";
                            columnCount = 2;
                        }
                    }
                    if (fragSizes != null) {
                        fragSizes.put(PortletPlacementMetadataAccess.getId(layoutFragment), sizesVal);
                    }
                } else if (!suppressErrorLogging) {
                    log.error("getColumnCountAndSizes null sizes, columns not defined in ParameterSet - " + PortletPlacementMetadataAccess.getId(layoutFragment) + " / " + layoutName);
                }
            }
        }
        return columnCount;
    }

    private static String getType(Object f) {
        return f instanceof ContentFragment ? ((ContentFragment)f).getType() : ((Fragment)f).getType();
    }

    private static String getId(Object f) {
        return f instanceof ContentFragment ? ((ContentFragment)f).getId() : ((Fragment)f).getId();
    }

    private static String getName(Object f) {
        return f instanceof ContentFragment ? ((ContentFragment)f).getName() : ((Fragment)f).getName();
    }

    private static String getProperty(Object f, String propertyName) {
        return f instanceof ContentFragment ? ((ContentFragment)f).getProperty(propertyName) : ((Fragment)f).getProperty(propertyName);
    }
}

