/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.layout.impl;

import java.util.Map;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.ajax.AJAXException;
import org.apache.jetspeed.ajax.AjaxAction;
import org.apache.jetspeed.ajax.AjaxBuilder;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.layout.PortletActionSecurityBehavior;
import org.apache.jetspeed.layout.impl.BasePortletAction;
import org.apache.jetspeed.layout.impl.Constants;
import org.apache.jetspeed.layout.impl.NestedFragmentContext;
import org.apache.jetspeed.layout.impl.PortletPlacementContextImpl;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.pipeline.PipelineException;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemovePortletAction
extends BasePortletAction
implements AjaxAction,
AjaxBuilder,
Constants {
    protected static final Logger log = LoggerFactory.getLogger(RemovePortletAction.class);
    private PortletRegistry registry;

    public RemovePortletAction(String template, String errorTemplate, PortletRegistry registry) throws PipelineException {
        this(template, errorTemplate, registry, null, null);
    }

    public RemovePortletAction(String template, String errorTemplate, PortletRegistry registry, PageManager pageManager, PortletActionSecurityBehavior securityBehavior) throws PipelineException {
        super(template, errorTemplate, pageManager, securityBehavior);
        this.registry = registry;
    }

    public boolean runBatch(RequestContext requestContext, Map resultMap) throws AJAXException {
        return this.runAction(requestContext, resultMap, true);
    }

    public boolean run(RequestContext requestContext, Map resultMap) throws AJAXException {
        return this.runAction(requestContext, resultMap, false);
    }

    public boolean runAction(RequestContext requestContext, Map resultMap, boolean batch) {
        boolean success = true;
        String status = "success";
        try {
            ContentPage page;
            resultMap.put("action", "remove");
            String portletId = this.getActionParameter(requestContext, "id");
            if (portletId == null) {
                success = false;
                resultMap.put("reason", "Portlet ID not provided");
                return success;
            }
            resultMap.put("id", portletId);
            if (!this.checkAccess(requestContext, JetspeedActions.EDIT)) {
                page = requestContext.getPage();
                ContentFragment fragment = page.getFragmentById(portletId);
                if (fragment == null) {
                    success = false;
                    resultMap.put("reason", "Fragment not found");
                    return success;
                }
                NestedFragmentContext removeFragmentContext = null;
                try {
                    removeFragmentContext = new NestedFragmentContext(fragment, page, this.registry);
                }
                catch (Exception ex) {
                    log.error("Failure to construct nested context for fragment " + portletId, (Throwable)ex);
                    success = false;
                    resultMap.put("reason", "Cannot construct nested context for fragment");
                    return success;
                }
                if (!this.createNewPageOnEdit(requestContext)) {
                    success = false;
                    resultMap.put("reason", "Insufficient access to edit page");
                    return success;
                }
                status = "refresh";
                ContentPage newPage = requestContext.getPage();
                ContentFragment newFragment = null;
                try {
                    newFragment = removeFragmentContext.getFragmentOnNewPage(newPage, this.registry);
                }
                catch (Exception ex) {
                    log.error("Failure to locate copy of fragment " + portletId, (Throwable)ex);
                    success = false;
                    resultMap.put("reason", "Failed to find new fragment for portlet id: " + portletId);
                    return success;
                }
                portletId = newFragment.getId();
            }
            page = requestContext.getPage();
            ContentFragment root = page.getRootFragment();
            ContentFragment layoutContainerFragment = this.getParentFragmentById(portletId, root);
            PortletPlacementContextImpl placement = null;
            ContentFragment fragment = null;
            if (layoutContainerFragment != null) {
                placement = new PortletPlacementContextImpl(page, this.registry, layoutContainerFragment);
                fragment = placement.getFragmentById(portletId);
            }
            if (fragment == null) {
                success = false;
                resultMap.put("reason", "Fragment not found");
                return success;
            }
            placement.remove(fragment);
            page = placement.syncPageFragments();
            page.removeFragment(fragment.getId());
            resultMap.put("id", portletId);
            resultMap.put("status", status);
            resultMap.put("oldcol", String.valueOf(fragment.getLayoutColumn()));
            resultMap.put("oldrow", String.valueOf(fragment.getLayoutRow()));
        }
        catch (Exception e) {
            log.error("exception while adding a portlet", (Throwable)e);
            resultMap.put("reason", e.toString());
            success = false;
        }
        return success;
    }

    protected PortletRegistry getPortletRegistry() {
        return this.registry;
    }
}

