/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.layout.impl;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.ajax.AJAXException;
import org.apache.jetspeed.ajax.AjaxAction;
import org.apache.jetspeed.ajax.AjaxBuilder;
import org.apache.jetspeed.layout.PortletActionSecurityBehavior;
import org.apache.jetspeed.layout.impl.BasePortletAction;
import org.apache.jetspeed.layout.impl.Constants;
import org.apache.jetspeed.om.common.SecurityConstraint;
import org.apache.jetspeed.om.page.PageSecurity;
import org.apache.jetspeed.om.page.SecurityConstraintsDef;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SecurityConstraintsAction
extends BasePortletAction
implements AjaxAction,
AjaxBuilder,
Constants {
    protected static final Logger log = LoggerFactory.getLogger(SecurityConstraintsAction.class);

    public SecurityConstraintsAction(String template, String errorTemplate, PageManager pm, PortletActionSecurityBehavior securityBehavior) {
        super(template, errorTemplate, pm, securityBehavior);
    }

    public SecurityConstraintsAction(String template, String errorTemplate, PageManager pm) {
        this(template, errorTemplate, pm, null);
    }

    public boolean run(RequestContext requestContext, Map resultMap) throws AJAXException {
        System.out.println("SecurityConstraintsAction run");
        boolean success = true;
        String status = "success";
        try {
            resultMap.put("action", "constraints");
            String method = this.getActionParameter(requestContext, "method");
            if (method == null) {
                throw new RuntimeException("Method not provided");
            }
            resultMap.put("method", method);
            if (!this.checkAccess(requestContext, JetspeedActions.EDIT)) {
                success = false;
                resultMap.put("reason", "Insufficient access to administer portal permissions");
                return success;
            }
            int count = 0;
            if (method.equals("add-def") || method.equals("update-def")) {
                count = this.updateConstraintDefinition(requestContext, resultMap);
            } else if (method.equals("remove-def")) {
                count = this.removeConstraintDefinition(requestContext, resultMap);
            } else if (method.equals("add-global")) {
                count = this.addGlobal(requestContext, resultMap);
            } else if (method.equals("remove-global")) {
                count = this.removeGlobal(requestContext, resultMap);
            } else {
                success = false;
                resultMap.put("reason", "Unsupported portal constraints method: " + method);
                return success;
            }
            resultMap.put("count", Integer.toString(count));
            resultMap.put("status", status);
        }
        catch (Exception e) {
            System.out.println("SecurityConstraintsAction run failure caused by " + e.getClass().getName() + " " + e.getMessage());
            e.printStackTrace();
            log.error("exception administering portal permissions", (Throwable)e);
            resultMap.put("reason", e.toString());
            success = false;
        }
        System.out.println("SecurityConstraintsAction complete " + resultMap.toString());
        return success;
    }

    protected int removeConstraintDefinition(RequestContext requestContext, Map resultMap) throws AJAXException {
        String name = this.getActionParameter(requestContext, "name");
        if (name == null) {
            throw new AJAXException("Missing 'name' parameter");
        }
        try {
            PageSecurity pageSecurity = this.pageManager.getPageSecurity();
            SecurityConstraintsDef def = pageSecurity.getSecurityConstraintsDef(name);
            if (def == null) {
                return 0;
            }
            List defs = pageSecurity.getSecurityConstraintsDefs();
            defs.remove(def);
            pageSecurity.setSecurityConstraintsDefs(defs);
            this.pageManager.updatePageSecurity(pageSecurity);
        }
        catch (Exception e) {
            throw new AJAXException((Throwable)e);
        }
        return 1;
    }

    protected int updateConstraintDefinition(RequestContext requestContext, Map resultMap) throws AJAXException {
        System.out.println("SecurityConstraintsAction updateConstraintDefinition started");
        int count = 0;
        boolean added = false;
        String xml = this.getActionParameter(requestContext, "xml");
        if (xml == null) {
            throw new AJAXException("Missing 'xml' parameter");
        }
        try {
            SecurityConstraint constraint;
            Element xmlConstraint;
            int ix;
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            String charset = requestContext.getCharacterEncoding();
            byte[] bytes = charset != null ? xml.getBytes(charset) : xml.getBytes();
            Document document = builder.parse(new ByteArrayInputStream(bytes));
            Element root = document.getDocumentElement();
            String name = root.getAttribute("name");
            PageSecurity pageSecurity = this.pageManager.getPageSecurity();
            SecurityConstraintsDef def = pageSecurity.getSecurityConstraintsDef(name);
            int defsSize = 0;
            if (def == null) {
                def = this.pageManager.newSecurityConstraintsDef();
                def.setName(name);
                added = true;
            }
            NodeList xmlConstraints = root.getElementsByTagName("security-constraint");
            int xmlSize = xmlConstraints.getLength();
            if (!added) {
                defsSize = def.getSecurityConstraints().size();
            }
            int min = xmlSize < defsSize ? xmlSize : defsSize;
            List constraints = def.getSecurityConstraints();
            NodeList owners = root.getElementsByTagName("owner");
            if (owners.getLength() == 1) {
                // empty if block
            }
            for (ix = 0; ix < min; ++ix) {
                xmlConstraint = (Element)xmlConstraints.item(ix);
                constraint = (SecurityConstraint)constraints.get(ix);
                this.updateConstraintValues(xmlConstraint, constraint);
                ++count;
            }
            if (xmlSize < defsSize) {
                int ix2;
                ArrayList deletes = new ArrayList(defsSize - xmlSize);
                for (ix2 = min; ix2 < defsSize; ++ix2) {
                    deletes.add(constraints.get(ix2));
                }
                for (ix2 = 0; ix2 < deletes.size(); ++ix2) {
                    constraints.remove(deletes.get(ix2));
                    ++count;
                }
            } else if (xmlSize > defsSize) {
                for (ix = min; ix < xmlSize; ++ix) {
                    xmlConstraint = (Element)xmlConstraints.item(ix);
                    constraint = this.pageManager.newPageSecuritySecurityConstraint();
                    this.updateConstraintValues(xmlConstraint, constraint);
                    constraints.add(constraint);
                    ++count;
                }
            }
            if (added) {
                pageSecurity.getSecurityConstraintsDefs().add(def);
                pageSecurity.setSecurityConstraintsDefs(pageSecurity.getSecurityConstraintsDefs());
            }
            this.pageManager.updatePageSecurity(pageSecurity);
        }
        catch (Exception e) {
            System.out.println("SecurityConstraintsAction updateConstraintDefinition failure caused by " + e.getClass().getName() + " " + e.getMessage());
            e.printStackTrace();
            log.error("SecurityConstraintsAction updateConstraintDefinition failure caused by " + e.getClass().getName() + " " + e.getMessage(), (Throwable)e);
            throw new AJAXException((Throwable)e);
        }
        return count;
    }

    protected void updateConstraintValues(Element xmlConstraint, SecurityConstraint constraint) {
        constraint.setRoles(this.parseCSVList(this.getChildText(xmlConstraint, "roles")));
        constraint.setGroups(this.parseCSVList(this.getChildText(xmlConstraint, "groups")));
        constraint.setPermissions(this.parseCSVList(this.getChildText(xmlConstraint, "permissions")));
        constraint.setUsers(this.parseCSVList(this.getChildText(xmlConstraint, "users")));
    }

    protected String getChildText(Element parent, String childName) {
        NodeList children = parent.getElementsByTagName(childName);
        if (children.getLength() > 0) {
            return ((Element)children.item(0)).getTextContent();
        }
        return null;
    }

    protected List parseCSVList(String csv) {
        if (csv != null) {
            ArrayList<String> csvList = new ArrayList<String>(4);
            if (csv.indexOf(44) != -1) {
                StringTokenizer csvTokens = new StringTokenizer(csv, ",");
                while (csvTokens.hasMoreTokens()) {
                    csvList.add(csvTokens.nextToken().trim());
                }
            } else {
                csvList.add(csv);
            }
            return csvList;
        }
        return null;
    }

    protected int removeGlobal(RequestContext requestContext, Map resultMap) throws AJAXException {
        int count = 0;
        String name = this.getActionParameter(requestContext, "name");
        if (name == null) {
            throw new AJAXException("Missing 'name' parameter");
        }
        try {
            PageSecurity pageSecurity = this.pageManager.getPageSecurity();
            List globals = pageSecurity.getGlobalSecurityConstraintsRefs();
            if (!globals.contains(name)) {
                return 0;
            }
            globals.remove(name);
            pageSecurity.setGlobalSecurityConstraintsRefs(globals);
            this.pageManager.updatePageSecurity(pageSecurity);
        }
        catch (Exception e) {
            throw new AJAXException((Throwable)e);
        }
        return ++count;
    }

    protected int addGlobal(RequestContext requestContext, Map resultMap) throws AJAXException {
        int count = 0;
        String name = this.getActionParameter(requestContext, "name");
        if (name == null) {
            throw new AJAXException("Missing 'name' parameter");
        }
        try {
            PageSecurity pageSecurity = this.pageManager.getPageSecurity();
            List globals = pageSecurity.getGlobalSecurityConstraintsRefs();
            if (pageSecurity.getSecurityConstraintsDef(name) == null) {
                throw new AJAXException("global name doesnt exist in definitions");
            }
            if (globals.contains(name)) {
                return count;
            }
            globals.add(name);
            pageSecurity.setGlobalSecurityConstraintsRefs(globals);
            this.pageManager.updatePageSecurity(pageSecurity);
        }
        catch (Exception e) {
            throw new AJAXException((Throwable)e);
        }
        return ++count;
    }
}

