/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.layout.impl;

import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.ajax.AJAXException;
import org.apache.jetspeed.ajax.AjaxAction;
import org.apache.jetspeed.ajax.AjaxBuilder;
import org.apache.jetspeed.layout.PortletActionSecurityBehavior;
import org.apache.jetspeed.layout.impl.BasePortletAction;
import org.apache.jetspeed.layout.impl.Constants;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.JetspeedPermission;
import org.apache.jetspeed.security.PermissionManager;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.impl.TransientRole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityPermissionAction
extends BasePortletAction
implements AjaxAction,
AjaxBuilder,
Constants {
    protected static final Logger log = LoggerFactory.getLogger(SecurityPermissionAction.class);
    protected PermissionManager pm = null;

    public SecurityPermissionAction(String template, String errorTemplate, PermissionManager pm, PortletActionSecurityBehavior securityBehavior) {
        super(template, errorTemplate, securityBehavior);
        this.pm = pm;
    }

    public boolean run(RequestContext requestContext, Map resultMap) throws AJAXException {
        boolean success = true;
        String status = "success";
        try {
            resultMap.put("action", "permissions");
            String method = this.getActionParameter(requestContext, "method");
            if (method == null) {
                throw new RuntimeException("Method not provided");
            }
            resultMap.put("method", method);
            if (!this.checkAccess(requestContext, JetspeedActions.EDIT)) {
                success = false;
                resultMap.put("reason", "Insufficient access to administer portal permissions");
                return success;
            }
            int count = 0;
            if (method.equals("add")) {
                count = this.addPermission(requestContext, resultMap);
            } else if (method.equals("update")) {
                count = this.updatePermission(requestContext, resultMap);
            } else if (method.equals("remove")) {
                count = this.removePermission(requestContext, resultMap);
            } else {
                success = false;
                resultMap.put("reason", "Unsupported portal permissions method: " + method);
                return success;
            }
            resultMap.put("count", Integer.toString(count));
            resultMap.put("resource", this.getActionParameter(requestContext, "resource"));
            resultMap.put("type", this.getActionParameter(requestContext, "type"));
            resultMap.put("actions", this.getActionParameter(requestContext, "actions"));
            resultMap.put("roles", this.getActionParameter(requestContext, "roles"));
            resultMap.put("status", status);
        }
        catch (Exception e) {
            log.error("exception administering portal permissions", (Throwable)e);
            resultMap.put("reason", e.toString());
            success = false;
        }
        return success;
    }

    protected int addPermission(RequestContext requestContext, Map resultMap) throws AJAXException {
        try {
            String type = this.getActionParameter(requestContext, "type");
            if (type == null) {
                throw new AJAXException("Missing 'type' parameter");
            }
            String resource = this.getActionParameter(requestContext, "resource");
            if (resource == null) {
                throw new AJAXException("Missing 'resource' parameter");
            }
            String actions = this.getActionParameter(requestContext, "actions");
            if (actions == null) {
                throw new AJAXException("Missing 'actions' parameter");
            }
            JetspeedPermission permission = this.pm.newPermission(type, resource, actions);
            if (this.pm.permissionExists(permission)) {
                throw new AJAXException("Permission " + resource + " already exists");
            }
            this.pm.addPermission(permission);
            String roleNames = this.getActionParameter(requestContext, "roles");
            return this.updateRoles(permission, roleNames);
        }
        catch (SecurityException e) {
            throw new AJAXException(e.toString(), (Throwable)e);
        }
    }

    protected int updatePermission(RequestContext requestContext, Map resultMap) throws AJAXException {
        try {
            String type = this.getActionParameter(requestContext, "type");
            if (type == null) {
                throw new AJAXException("Missing 'type' parameter");
            }
            String resource = this.getActionParameter(requestContext, "resource");
            if (resource == null) {
                throw new AJAXException("Missing 'resource' parameter");
            }
            String actions = this.getActionParameter(requestContext, "actions");
            if (actions == null) {
                throw new AJAXException("Missing 'actions' parameter");
            }
            String oldActions = this.getActionParameter(requestContext, "oldactions");
            if (oldActions == null) {
                oldActions = actions;
            }
            JetspeedPermission permission = this.pm.newPermission(type, resource, actions);
            if (!oldActions.equals(actions)) {
                this.pm.updatePermission(permission);
            }
            String roleNames = this.getActionParameter(requestContext, "roles");
            return this.updateRoles(permission, roleNames);
        }
        catch (SecurityException e) {
            throw new AJAXException(e.toString(), (Throwable)e);
        }
    }

    protected int updateRoles(JetspeedPermission permission, String roleNames) throws SecurityException {
        int count = 0;
        LinkedList<TransientRole> principals = new LinkedList<TransientRole>();
        if (roleNames != null) {
            StringTokenizer toke = new StringTokenizer(roleNames, ",");
            while (toke.hasMoreTokens()) {
                principals.add(new TransientRole(toke.nextToken()));
                ++count;
            }
        }
        this.pm.grantPermissionOnlyTo(permission, "role", principals);
        return count;
    }

    protected int removePermission(RequestContext requestContext, Map resultMap) throws AJAXException {
        try {
            String type = this.getActionParameter(requestContext, "type");
            if (type == null) {
                throw new AJAXException("Missing 'type' parameter");
            }
            String resource = this.getActionParameter(requestContext, "resource");
            if (resource == null) {
                throw new AJAXException("Missing 'resource' parameter");
            }
            String actions = this.getActionParameter(requestContext, "actions");
            if (actions == null) {
                throw new AJAXException("Missing 'actions' parameter");
            }
            JetspeedPermission permission = this.pm.newPermission(type, resource, actions);
            if (this.pm.permissionExists(permission)) {
                this.pm.removePermission(permission);
                return 1;
            }
            return 0;
        }
        catch (SecurityException e) {
            throw new AJAXException(e.toString(), (Throwable)e);
        }
    }
}

