/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.localization.impl;

import java.security.Principal;
import java.util.Enumeration;
import java.util.Locale;
import javax.security.auth.Subject;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.i18n.CurrentLocale;
import org.apache.jetspeed.pipeline.PipelineException;
import org.apache.jetspeed.pipeline.valve.AbstractValve;
import org.apache.jetspeed.pipeline.valve.LocalizationValve;
import org.apache.jetspeed.pipeline.valve.ValveContext;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.SecurityAttribute;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.SubjectHelper;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.util.JetspeedLocale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalizationValveImpl
extends AbstractValve
implements LocalizationValve {
    private static final Logger log = LoggerFactory.getLogger(LocalizationValveImpl.class);
    private Locale defaultLocale = null;

    public LocalizationValveImpl() {
    }

    public LocalizationValveImpl(String defaultLanguage) {
        String language;
        String string = language = defaultLanguage != null ? defaultLanguage.trim() : "";
        if (language.length() > 0) {
            String country = "";
            String variant = "";
            int countryIndex = language.indexOf(95);
            if (countryIndex > -1) {
                country = language.substring(countryIndex + 1).trim();
                language = language.substring(0, countryIndex).trim();
                int vDash = country.indexOf("_");
                if (vDash > 0) {
                    String cTemp = country.substring(0, vDash);
                    variant = country.substring(vDash + 1);
                    country = cTemp;
                }
            }
            this.defaultLocale = new Locale(language, country, variant);
            if (this.defaultLocale.getLanguage().length() == 0) {
                this.defaultLocale = null;
                log.warn("Invalid or unrecognized default language: " + language);
            } else {
                log.info("Default language set: " + this.defaultLocale);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(RequestContext request, ValveContext context) throws PipelineException {
        Principal userPrincipal;
        Subject subject;
        Locale locale = (Locale)request.getRequest().getSession().getAttribute("org.apache.jetspeed.prefered.locale");
        if (null == locale && null != (subject = request.getSubject()) && null != (userPrincipal = SubjectHelper.getPrincipal((Subject)subject, User.class))) {
            log.debug("Got user principal: " + userPrincipal.getName());
            UserManager userMgr = (UserManager)Jetspeed.getComponentManager().getComponent(UserManager.class);
            try {
                String localeString;
                User user;
                SecurityAttribute attrib;
                if (!userMgr.getAnonymousUser().equals(userPrincipal.getName()) && userMgr.userExists(userPrincipal.getName()) && (attrib = (user = userMgr.getUser(userPrincipal.getName())).getSecurityAttributes().getAttribute("org.apache.jetspeed.prefered.locale")) != null && (localeString = attrib.getStringValue()) != null) {
                    locale = JetspeedLocale.convertStringToLocale((String)localeString);
                }
            }
            catch (SecurityException e) {
                log.warn("Unexpected SecurityException in UserInfoManager", (Throwable)e);
            }
        }
        if (locale == null) {
            locale = (Locale)request.getSessionAttribute("org.apache.jetspeed.prefered.locale");
        }
        if (locale == null && this.defaultLocale != null) {
            locale = this.defaultLocale;
        }
        if (locale == null) {
            locale = request.getRequest().getLocale();
        }
        if (locale == null) {
            Enumeration preferedLocales = request.getRequest().getLocales();
            while (preferedLocales.hasMoreElements() && locale == null) {
                locale = (Locale)preferedLocales.nextElement();
            }
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        request.setLocale(locale);
        request.getRequest().setAttribute("org.apache.jetspeed.prefered.locale", (Object)locale);
        request.getRequest().getSession().setAttribute("org.apache.jetspeed.prefered.locale", (Object)locale);
        CurrentLocale.set((Locale)locale);
        try {
            context.invokeNext(request);
        }
        finally {
            CurrentLocale.set(null);
        }
    }

    public String toString() {
        return "LocalizationValve";
    }
}

