/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.login;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.administration.PortalAuthenticationConfiguration;
import org.apache.jetspeed.security.activeauthentication.ActiveAuthenticationIdentityProvider;
import org.apache.jetspeed.security.activeauthentication.IdentityToken;

public class LoginProxyServlet
extends HttpServlet {
    private boolean credentialsFromRequest = true;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String s = config.getInitParameter("credentialsFromRequest");
        if (s != null) {
            this.credentialsFromRequest = s.equalsIgnoreCase("true");
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String username;
        request.setCharacterEncoding("UTF-8");
        HttpSession session = request.getSession(true);
        String parameter = request.getParameter("org.apache.jetspeed.login.destination");
        if (parameter != null) {
            parameter = StringEscapeUtils.escapeHtml((String)parameter);
            session.setAttribute("org.apache.jetspeed.login.destination", (Object)parameter);
        } else {
            session.removeAttribute("org.apache.jetspeed.login.destination");
        }
        if (this.credentialsFromRequest) {
            username = request.getParameter("org.apache.jetspeed.login.username");
            if (username != null) {
                username = StringEscapeUtils.escapeHtml((String)username);
                session.setAttribute("org.apache.jetspeed.login.username", (Object)username);
            } else {
                session.removeAttribute("org.apache.jetspeed.login.username");
            }
            parameter = request.getParameter("org.apache.jetspeed.login.password");
            if (parameter != null) {
                parameter = StringEscapeUtils.escapeHtml((String)parameter);
                session.setAttribute("org.apache.jetspeed.login.password", (Object)parameter);
            } else {
                session.removeAttribute("org.apache.jetspeed.login.password");
            }
        } else {
            username = (String)session.getAttribute("org.apache.jetspeed.login.username");
            parameter = (String)session.getAttribute("org.apache.jetspeed.login.password");
        }
        if (request.getParameter("org.apache.jetspeed.theme.override") != null) {
            String decoratorName = request.getParameter("org.apache.jetspeed.theme.override");
            session.setAttribute("org.apache.jetspeed.theme.override", (Object)decoratorName);
        }
        Boolean portalFiltered = Boolean.valueOf((String)request.getAttribute("org.apache.jetspeed.login.filter.PortalFilter"));
        PortalAuthenticationConfiguration authenticationConfiguration = (PortalAuthenticationConfiguration)Jetspeed.getComponentManager().getComponent((Object)"org.apache.jetspeed.administration.PortalAuthenticationConfiguration");
        if (!portalFiltered.booleanValue() && authenticationConfiguration.isCreateNewSessionOnLogin()) {
            ActiveAuthenticationIdentityProvider identityProvider = (ActiveAuthenticationIdentityProvider)Jetspeed.getComponentManager().getComponent((Object)"org.apache.jetspeed.security.activeauthentication.ActiveAuthenticationIdentityProvider");
            IdentityToken token = identityProvider.createIdentityToken(username);
            this.saveState(session, token, identityProvider.getSessionAttributeNames());
            request.getSession().invalidate();
            HttpSession newSession = request.getSession(true);
            this.restoreState(newSession, token);
            response.sendRedirect(response.encodeURL(request.getContextPath() + "/login/redirector?token=") + token.getToken());
        } else {
            response.sendRedirect(response.encodeURL(request.getContextPath() + "/login/redirector"));
        }
    }

    protected void saveState(HttpSession session, IdentityToken token, List sessionAttributes) {
        for (String name : sessionAttributes) {
            token.setAttribute(name, session.getAttribute(name));
        }
    }

    protected void restoreState(HttpSession session, IdentityToken token) {
        Iterator names = token.getAttributeNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            Object attribute = token.getAttribute(name);
            session.setAttribute(name, attribute);
        }
    }

    public final void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doGet(request, response);
    }
}

